/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldDeletedEntriesCleanup
implements Runnable,
Closeable,
Predicate<ReplicableEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(OldDeletedEntriesCleanup.class);
    private final ReplicatedChronicleMap<?, ?, ?> map;
    private final int[] segmentsPermutation;
    private final int[] inverseSegmentsPermutation;
    private volatile boolean shutdown;
    private volatile Thread runnerThread;
    private long prevSegment0ScanStart = -1L;
    private long removedCompletely;

    public OldDeletedEntriesCleanup(ReplicatedChronicleMap<?, ?, ?> map) {
        this.map = map;
        this.segmentsPermutation = OldDeletedEntriesCleanup.randomPermutation(map.segments());
        this.inverseSegmentsPermutation = OldDeletedEntriesCleanup.inversePermutation(this.segmentsPermutation);
    }

    @Override
    public void run() {
        this.runnerThread = Thread.currentThread();
        while (!this.shutdown) {
            int nextSegmentIndex;
            TimeProvider timeProvider;
            block19: {
                int segmentIndex = this.map.globalMutableState().getCurrentCleanupSegmentIndex();
                timeProvider = this.map.timeProvider;
                try (HashSegmentContext context = this.map.segmentContext(segmentIndex);){
                    if (segmentIndex == 0) {
                        this.prevSegment0ScanStart = timeProvider.currentTime();
                    }
                    this.removedCompletely = 0L;
                    if (((ReplicatedHashSegmentContext)context).forEachSegmentReplicableEntryWhile(this)) {
                        LOG.debug("Removed {} old deleted entries in the segment {}", (Object)this.removedCompletely, (Object)segmentIndex);
                        nextSegmentIndex = this.nextSegmentIndex(segmentIndex);
                        this.map.globalMutableState().setCurrentCleanupSegmentIndex(nextSegmentIndex);
                        break block19;
                    }
                    assert (this.shutdown);
                    return;
                }
            }
            if (nextSegmentIndex != 0) continue;
            long currentTime = timeProvider.currentTime();
            TimeUnit cleanupTimeoutUnit = this.map.cleanupTimeoutUnit;
            long mapScanTime = timeProvider.systemTimeIntervalBetween(this.prevSegment0ScanStart, currentTime, cleanupTimeoutUnit);
            LOG.debug("Old deleted entries scan time: {} {}", (Object)mapScanTime, (Object)cleanupTimeoutUnit);
            long cleanupTimeout = this.map.cleanupTimeout;
            if (mapScanTime >= cleanupTimeout) continue;
            long timeToSleep = cleanupTimeoutUnit.toMillis(cleanupTimeout - mapScanTime);
            if (timeToSleep > 0L) {
                this.sleepMillis(timeToSleep);
                continue;
            }
            this.sleepNanos(cleanupTimeoutUnit.toNanos(cleanupTimeout - mapScanTime));
        }
    }

    @Override
    public boolean test(ReplicableEntry e) {
        long deleteTimeout;
        if (this.shutdown) {
            return false;
        }
        if (e instanceof MapAbsentEntry && (deleteTimeout = this.map.timeProvider.systemTimeIntervalBetween(e.originTimestamp(), this.map.timeProvider.currentTime(), this.map.cleanupTimeoutUnit)) > this.map.cleanupTimeout && !e.isChanged()) {
            e.doRemoveCompletely();
            ++this.removedCompletely;
        }
        return true;
    }

    private void sleepMillis(long millis) {
        long deadline = System.currentTimeMillis() + millis;
        while (System.currentTimeMillis() < deadline && !this.shutdown) {
            LockSupport.parkUntil(this, deadline);
        }
    }

    private void sleepNanos(long nanos) {
        long deadline = System.nanoTime() + nanos;
        while (System.nanoTime() < deadline && !this.shutdown) {
            LockSupport.parkNanos(this, deadline);
        }
    }

    public void close() {
        this.shutdown = true;
        if (this.runnerThread != null && LockSupport.getBlocker(this.runnerThread) == this) {
            this.runnerThread.interrupt();
        }
    }

    private int nextSegmentIndex(int segmentIndex) {
        int permutationIndex = this.inverseSegmentsPermutation[segmentIndex];
        int nextPermutationIndex = (permutationIndex + 1) % this.map.segments();
        return this.segmentsPermutation[nextPermutationIndex];
    }

    private static int[] randomPermutation(int n) {
        int[] a = new int[n];
        for (int i = 0; i < n; ++i) {
            a[i] = i;
        }
        OldDeletedEntriesCleanup.shuffle(a);
        return a;
    }

    private static void shuffle(int[] a) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = a.length - 1; i > 0; --i) {
            int index = ((Random)rnd).nextInt(i + 1);
            int e = a[index];
            a[index] = a[i];
            a[i] = e;
        }
    }

    private static int[] inversePermutation(int[] permutation) {
        int n = permutation.length;
        int[] inverse = new int[n];
        for (int i = 0; i < n; ++i) {
            inverse[permutation[i]] = i;
        }
        return inverse;
    }
}

