/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.hash.serialization.impl.EnumMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntegerMarshaller
implements SizedReader<Integer>,
BytesReader<Integer>,
SizedWriter<Integer>,
BytesWriter<Integer>,
EnumMarshallable<IntegerMarshaller> {
    public static final IntegerMarshaller INSTANCE = new IntegerMarshaller();

    private IntegerMarshaller() {
    }

    @Override
    @NotNull
    public Integer read(@NotNull Bytes in, long size, @Nullable Integer using) {
        return in.readInt();
    }

    @Override
    public long size(@NotNull Integer toWrite) {
        return 4L;
    }

    @Override
    public void write(@NotNull Bytes out, long size, @NotNull Integer toWrite) {
        out.writeInt(toWrite.intValue());
    }

    @Override
    @NotNull
    public Integer read(Bytes in, @Nullable Integer using) {
        return in.readInt();
    }

    @Override
    public void write(Bytes out, @NotNull Integer toWrite) {
        out.writeInt(toWrite.intValue());
    }

    public IntegerMarshaller readResolve() {
        return INSTANCE;
    }
}

