/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.iter;

import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.hash.ChronicleHashRecoveryFailedException;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.iter.IterationKeyHashCode;
import net.openhft.chronicle.map.ChronicleHashCorruptionImpl;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.entry.MapEntryStages;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public class TierRecovery {
    @StageRef
    VanillaChronicleMapHolder<?, ?, ?> mh;
    @StageRef
    SegmentStages s;
    @StageRef
    MapEntryStages<?, ?> e;
    @StageRef
    IterationKeyHashCode khc;

    public int recoverTier(int segmentIndex, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        this.s.freeList.clearAll();
        VanillaChronicleHash<?, ?, ?, ?> h = this.mh.h();
        CompactOffHeapLinearHashTable hl = h.hashLookup;
        long hlAddr = this.s.tierBaseAddr;
        long validEntries = 0L;
        long hlPos = 0L;
        block0: do {
            long startInsertPos;
            long entryPos;
            long hlEntry;
            if (hl.empty(hlEntry = hl.readEntry(hlAddr, hlPos))) continue;
            hl.clearEntry(hlAddr, hlPos);
            if (validEntries >= h.maxEntriesPerHashLookup) {
                ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Too many entries in tier with index {}, max is {}", this.s.tierIndex, h.maxEntriesPerHashLookup));
                continue;
            }
            long searchKey = hl.key(hlEntry);
            int si = this.checkEntry(searchKey, entryPos = hl.value(hlEntry), segmentIndex, corruptionListener, corruption);
            if (si < 0) continue;
            this.s.freeList.setRange(entryPos, entryPos + (long)this.e.entrySizeInChunks);
            segmentIndex = si;
            long insertPos = startInsertPos = hl.hlPos(searchKey);
            do {
                long hlInsertEntry;
                if (hl.empty(hlInsertEntry = hl.readEntry(hlAddr, insertPos))) {
                    hl.writeEntry(hlAddr, insertPos, hl.entry(searchKey, entryPos));
                    ++validEntries;
                    continue block0;
                }
                if (insertPos == hlPos) {
                    throw new ChronicleHashRecoveryFailedException("Concurrent modification of " + h.toIdentityString() + " while recovery procedure is in progress");
                }
                if (hl.key(hlInsertEntry) != searchKey) continue;
                long anotherEntryPos = hl.value(hlInsertEntry);
                if (anotherEntryPos == entryPos) {
                    ++validEntries;
                    continue block0;
                }
                long currentKeyOffset = this.e.keyOffset;
                long currentKeySize = this.e.keySize;
                int currentEntrySizeInChunks = this.e.entrySizeInChunks;
                if (insertPos >= 0L && insertPos < hlPos) {
                    this.e.readExistingEntry(anotherEntryPos);
                } else if (this.checkEntry(searchKey, anotherEntryPos, segmentIndex, corruptionListener, corruption) < 0) continue;
                if (this.e.keySize != currentKeySize || !BytesUtil.bytesEqual((RandomDataInput)this.s.segmentBS, (long)currentKeyOffset, (RandomDataInput)this.s.segmentBS, (long)this.e.keyOffset, (long)currentKeySize)) continue;
                ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Entries with duplicate keys within a tier: at pos {} and {} with key {}, first value is {}", entryPos, anotherEntryPos, this.e.key(), this.e.value()));
                this.s.freeList.clearRange(entryPos, entryPos + (long)currentEntrySizeInChunks);
                continue block0;
            } while ((insertPos = hl.step(insertPos)) != startInsertPos);
            throw new ChronicleHashRecoveryFailedException("HashLookup overflow should never occur. It might also be concurrent access to " + h.toIdentityString() + " while recovery procedure is in progress");
        } while ((hlPos = hl.step(hlPos)) != 0L);
        this.shiftHashLookupEntries();
        return segmentIndex;
    }

    private void shiftHashLookupEntries() {
        VanillaChronicleHash<?, ?, ?, ?> h = this.mh.h();
        CompactOffHeapLinearHashTable hl = h.hashLookup;
        long hlAddr = this.s.tierBaseAddr;
        long hlPos = 0L;
        long steps = 0L;
        block0: do {
            long hlEntry;
            if (hl.empty(hlEntry = hl.readEntry(hlAddr, hlPos))) continue;
            long searchKey = hl.key(hlEntry);
            long hlHolePos = hl.hlPos(searchKey);
            while (hlHolePos != hlPos) {
                long hlHoleEntry = hl.readEntry(hlAddr, hlHolePos);
                if (hl.empty(hlHoleEntry)) {
                    hl.writeEntry(hlAddr, hlHolePos, hlEntry);
                    if (hl.remove(hlAddr, hlPos) == hlPos) continue block0;
                    hlPos = hl.stepBack(hlPos);
                    --steps;
                    continue block0;
                }
                hlHolePos = hl.step(hlHolePos);
            }
        } while ((hlPos = hl.step(hlPos)) != 0L || ++steps == 0L);
    }

    public void removeDuplicatesInSegment(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long startHlPos = 0L;
        VanillaChronicleMap<?, ?, ?> m = this.mh.m();
        CompactOffHeapLinearHashTable hashLookup = m.hashLookup;
        long currentTierBaseAddr = this.s.tierBaseAddr;
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startHlPos))) {
            startHlPos = hashLookup.step(startHlPos);
        }
        long hlPos = startHlPos;
        int steps = 0;
        long entries = 0L;
        do {
            hlPos = hashLookup.step(hlPos);
            ++steps;
            long entry = hashLookup.readEntry(currentTierBaseAddr, hlPos);
            if (hashLookup.empty(entry)) continue;
            this.e.readExistingEntry(hashLookup.value(entry));
            Data key = this.e.key();
            try (ExternalHashQueryContext c = m.queryContext(key);){
                HashEntry entry2 = c.entry();
                Data key2 = ((MapEntry)((Object)c)).key();
                long keyAddress = key.bytes().address(key.offset());
                long key2Address = key2.bytes().address(key2.offset());
                if (key2Address != keyAddress) {
                    ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.s.segmentIndex, () -> this.lambda$removeDuplicatesInSegment$143(key, (ExternalMapQueryContext)c, (MapEntry)entry2));
                    if (hashLookup.remove(currentTierBaseAddr, hlPos) == hlPos) continue;
                    hlPos = hashLookup.stepBack(hlPos);
                    --steps;
                    continue;
                }
            }
            ++entries;
        } while (hlPos != startHlPos || steps == 0);
        this.recoverTierEntriesCounter(entries, corruptionListener, corruption);
        this.recoverLowestPossibleFreeChunkTiered(corruptionListener, corruption);
    }

    private void recoverTierEntriesCounter(long entries, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        if (this.s.tierEntries() != entries) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.s.segmentIndex, () -> ChronicleHashCorruptionImpl.format("Wrong number of entries counter for tier with index {}, stored: {}, should be: {}", this.s.tierIndex, this.s.tierEntries(), entries));
            this.s.tierEntries(entries);
        }
    }

    private void recoverLowestPossibleFreeChunkTiered(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long lowestFreeChunk = this.s.freeList.nextClearBit(0L);
        if (lowestFreeChunk == -1L) {
            lowestFreeChunk = this.mh.m().actualChunksPerSegmentTier;
        }
        if (this.s.lowestPossiblyFreeChunk() != lowestFreeChunk) {
            long finalLowestFreeChunk = lowestFreeChunk;
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.s.segmentIndex, () -> ChronicleHashCorruptionImpl.format("wrong lowest free chunk for tier with index {}, stored: {}, should be: {}", this.s.tierIndex, this.s.lowestPossiblyFreeChunk(), finalLowestFreeChunk));
            this.s.lowestPossiblyFreeChunk(lowestFreeChunk);
        }
    }

    private int checkEntry(long searchKey, long entryPos, int segmentIndex, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        VanillaChronicleHash<?, ?, ?, ?> h = this.mh.h();
        if (entryPos < 0L || entryPos >= h.actualChunksPerSegmentTier) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Entry pos is out of range: {}, should be 0-{}", entryPos, h.actualChunksPerSegmentTier - 1L));
            return -1;
        }
        try {
            this.e.readExistingEntry(entryPos);
        }
        catch (Exception e) {
            ChronicleHashCorruptionImpl.reportException(corruptionListener, corruption, segmentIndex, () -> "Exception while reading entry key size", e);
            return -1;
        }
        if (this.e.keyEnd() > this.s.segmentBytes.capacity()) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Wrong key size: {}", this.e.keySize));
            return -1;
        }
        long keyHashCode = this.khc.keyHashCode();
        int segmentIndexFromKey = h.hashSplitting.segmentIndex(keyHashCode);
        if (segmentIndexFromKey < 0 || segmentIndexFromKey >= h.actualSegments) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Segment index from the entry key hash code is out of range: {}, should be 0-{}, entry key: {}", segmentIndexFromKey, h.actualSegments - 1, this.e.key()));
            return -1;
        }
        long segmentHashFromKey = h.hashSplitting.segmentHash(keyHashCode);
        long searchKeyFromKey = h.hashLookup.maskUnsetKey(segmentHashFromKey);
        if (searchKey != searchKeyFromKey) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("HashLookup searchKey: {}, HashLookup searchKey from the entry key hash code: {}, entry key: {}, entry pos: {}", searchKey, searchKeyFromKey, this.e.key(), entryPos));
            return -1;
        }
        try {
            long entryAndChecksumEnd = this.e.entryEnd() + this.e.checksumStrategy.extraEntryBytes();
            if (entryAndChecksumEnd > this.s.segmentBytes.capacity()) {
                ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Wrong value size: {}, key: {}", this.e.valueSize, this.e.key()));
                return -1;
            }
        }
        catch (Exception ex) {
            ChronicleHashCorruptionImpl.reportException(corruptionListener, corruption, segmentIndex, () -> "Exception while reading entry value size, key: " + this.e.key(), ex);
            return -1;
        }
        int storedChecksum = this.e.checksumStrategy.storedChecksum();
        int checksumFromEntry = this.e.checksumStrategy.computeChecksum();
        if (storedChecksum != checksumFromEntry) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Checksum doesn't match, stored: {}, should be from the entry bytes: {}, key: {}, value: {}", storedChecksum, checksumFromEntry, this.e.key(), this.e.value()));
            return -1;
        }
        if (!this.s.freeList.isRangeClear(entryPos, entryPos + (long)this.e.entrySizeInChunks)) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Overlapping entry: positions {}-{}, key: {}, value: {}", entryPos, entryPos + (long)this.e.entrySizeInChunks - 1L, this.e.key(), this.e.value()));
            return -1;
        }
        if (segmentIndex < 0) {
            return segmentIndexFromKey;
        }
        if (segmentIndex != segmentIndexFromKey) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Expected segment index: {}, segment index from the entry key: {}, key: {}, value: {}", segmentIndex, searchKeyFromKey, this.e.key(), this.e.value()));
            return -1;
        }
        return segmentIndex;
    }

    private /* synthetic */ String lambda$removeDuplicatesInSegment$143(Data key, ExternalMapQueryContext c, MapEntry entry2) {
        return ChronicleHashCorruptionImpl.format("entries with duplicate key {} in segment {}: with values {} and {}, removing the latter", key, c.segmentIndex(), entry2 != null ? ((MapEntry)((Object)c)).value() : "<deleted>", !this.e.entryDeleted() ? this.e.value() : "<deleted>");
    }
}

