/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.replication;

import java.util.function.Consumer;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.query.QueryAlloc;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public class ReplicatedQueryAlloc
extends QueryAlloc {
    @StageRef
    ReplicatedChronicleMapHolder<?, ?, ?> mh;
    @StageRef
    SegmentStages s;
    final CleanupAction cleanupAction = new CleanupAction();

    public boolean forcedOldDeletedEntriesCleanup(long prevPos) {
        VanillaChronicleMap map = this.mh.m();
        if (!((ReplicatedChronicleMap)map).cleanupRemovedEntries) {
            return false;
        }
        try (HashSegmentContext sc = map.segmentContext(this.s.segmentIndex);){
            this.cleanupAction.removedCompletely = 0;
            this.cleanupAction.posToSkip = prevPos;
            this.cleanupAction.iterationContext = (IterationContext)sc;
            ((ReplicatedHashSegmentContext)sc).forEachSegmentReplicableEntry(this.cleanupAction);
            boolean bl = this.cleanupAction.removedCompletely > 0;
            return bl;
        }
    }

    @Override
    public long alloc(int chunks, long prevPos, int prevChunks) {
        long ret = this.s.allocReturnCode(chunks);
        if (ret >= 0L) {
            if (prevPos >= 0L) {
                this.s.free(prevPos, prevChunks);
            }
            return ret;
        }
        int firstAttemptedTier = this.s.tier;
        long firstAttemptedTierIndex = this.s.tierIndex;
        long firstAttemptedTierBaseAddr = this.s.tierBaseAddr;
        boolean cleanedFirstAttemptedTier = this.forcedOldDeletedEntriesCleanup(prevPos);
        this.s.goToFirstTier();
        while (true) {
            boolean visitingFirstAttemptedTier;
            boolean bl = visitingFirstAttemptedTier = this.s.tier == firstAttemptedTier;
            if ((cleanedFirstAttemptedTier || !visitingFirstAttemptedTier) && (ret = this.s.allocReturnCode(chunks)) >= 0L) {
                if (prevPos >= 0L) {
                    if (visitingFirstAttemptedTier) {
                        this.s.free(prevPos, prevChunks);
                    } else if (this.s.tier < firstAttemptedTier) {
                        int currentTier = this.s.tier;
                        long currentTierIndex = this.s.tierIndex;
                        long currentTierBaseAddr = this.s.tierBaseAddr;
                        this.s.initSegmentTier(firstAttemptedTier, firstAttemptedTierIndex, firstAttemptedTierBaseAddr);
                        this.s.free(prevPos, prevChunks);
                        this.s.initSegmentTier(currentTier, currentTierIndex, currentTierBaseAddr);
                    }
                }
                return ret;
            }
            if (visitingFirstAttemptedTier && prevPos >= 0L) {
                this.s.free(prevPos, prevChunks);
            }
            this.s.nextTier();
        }
    }

    private class CleanupAction
    implements Consumer<ReplicableEntry> {
        int removedCompletely;
        long posToSkip;
        IterationContext<?, ?, ?> iterationContext;

        private CleanupAction() {
        }

        @Override
        public void accept(ReplicableEntry e) {
            VanillaChronicleMap map = ReplicatedQueryAlloc.this.mh.m();
            if (!(e instanceof MapAbsentEntry) || this.iterationContext.pos() == this.posToSkip) {
                return;
            }
            long currentTime = TimeProvider.currentTime();
            if (e.originTimestamp() > currentTime) {
                return;
            }
            long deleteTimeout = TimeProvider.systemTimeIntervalBetween(e.originTimestamp(), currentTime, ((ReplicatedChronicleMap)map).cleanupTimeoutUnit);
            if (deleteTimeout <= ((ReplicatedChronicleMap)map).cleanupTimeout || e.isChanged()) {
                return;
            }
            e.doRemoveCompletely();
            ++this.removedCompletely;
        }
    }
}

