/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.openhft.chronicle.core.Jvm;

public final class CanonicalRandomAccessFiles {
    private static final ConcurrentHashMap<File, RafReference> canonicalRafs = new ConcurrentHashMap();

    public static RandomAccessFile acquire(File file) throws FileNotFoundException {
        return CanonicalRandomAccessFiles.canonicalRafs.compute((File)file, (BiFunction<File, RafReference, RafReference>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$acquire$0(java.io.File net.openhft.chronicle.hash.impl.util.CanonicalRandomAccessFiles$RafReference ), (Ljava/io/File;Lnet/openhft/chronicle/hash/impl/util/CanonicalRandomAccessFiles$RafReference;)Lnet/openhft/chronicle/hash/impl/util/CanonicalRandomAccessFiles$RafReference;)()).raf;
    }

    public static void release(File file) throws IOException {
        canonicalRafs.computeIfPresent(file, (f, ref) -> {
            if (--ref.refCount == 0) {
                try {
                    ref.raf.close();
                }
                catch (IOException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                return null;
            }
            return ref;
        });
    }

    private CanonicalRandomAccessFiles() {
    }

    private static /* synthetic */ RafReference lambda$acquire$0(File f, RafReference ref) {
        if (ref == null) {
            try {
                return new RafReference(new RandomAccessFile(f, "rw"));
            }
            catch (FileNotFoundException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }
        ++ref.refCount;
        return ref;
    }

    private static class RafReference {
        RandomAccessFile raf;
        int refCount;

        RafReference(RandomAccessFile raf) {
            this.raf = raf;
            this.refCount = 1;
        }
    }
}

