/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.impl.ChronicleHashResourceReleaser;
import net.openhft.chronicle.hash.impl.MemoryResource;
import net.openhft.chronicle.hash.impl.PersistedChronicleHashResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryChronicleHashResourceReleaser
extends ChronicleHashResourceReleaser {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedChronicleHashResourceReleaser.class);

    @Override
    public synchronized void run() {
        if (this.memoryResources == null) {
            return;
        }
        try {
            Throwable thrown = this.doRelease();
            if (thrown != null) {
                try {
                    LOG.error("Error on releasing memory of a Chronicle Map:", thrown);
                }
                catch (Throwable t) {
                    thrown.addSuppressed(t);
                    thrown.printStackTrace();
                }
            }
        }
        finally {
            this.memoryResources = null;
        }
    }

    @Override
    Throwable doRelease() {
        Throwable thrown = null;
        for (MemoryResource allocation : this.memoryResources) {
            try {
                OS.memory().freeMemory(allocation.address, allocation.size);
            }
            catch (Throwable t) {
                if (thrown == null) {
                    thrown = t;
                    continue;
                }
                thrown.addSuppressed(t);
            }
        }
        return thrown;
    }
}

