/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.hash.impl.MemoryResource;
import net.openhft.chronicle.hash.impl.util.Throwables;

public abstract class ChronicleHashResourceReleaser
implements Runnable {
    List<MemoryResource> memoryResources = new ArrayList<MemoryResource>(1);

    public final synchronized void addMemoryResource(long address, long size) {
        if (this.memoryResources == null) {
            throw new IllegalStateException("Already released");
        }
        this.memoryResources.add(new MemoryResource(address, size));
    }

    public final synchronized long totalMemory() {
        if (this.memoryResources == null) {
            return 0L;
        }
        long totalMemory = 0L;
        for (MemoryResource memoryResource : this.memoryResources) {
            totalMemory += memoryResource.size;
        }
        return totalMemory;
    }

    abstract Throwable doRelease();

    public final synchronized void releaseManually() {
        if (this.memoryResources == null) {
            return;
        }
        Throwable thrown = null;
        try {
            thrown = this.doRelease();
        }
        finally {
            this.memoryResources = null;
        }
        if (thrown != null) {
            throw Throwables.propagate(thrown);
        }
    }
}

