/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.locks.AcquisitionStrategies;
import net.openhft.chronicle.algo.locks.AcquisitionStrategy;
import net.openhft.chronicle.algo.locks.LockingStrategy;
import net.openhft.chronicle.algo.locks.TryAcquireOperation;
import net.openhft.chronicle.algo.locks.TryAcquireOperations;
import net.openhft.chronicle.algo.locks.VanillaReadWriteUpdateWithWaitsLockingStrategy;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilderPrivateAPI;
import net.openhft.chronicle.hash.ChronicleHashClosedException;
import net.openhft.chronicle.hash.ChronicleHashRecoveryFailedException;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.DummyReferenceCounted;
import net.openhft.chronicle.hash.impl.HashSplitting;
import net.openhft.chronicle.hash.impl.IntCompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.LongCompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.impl.util.BuildVersion;
import net.openhft.chronicle.hash.impl.util.CanonicalRandomAccessFiles;
import net.openhft.chronicle.hash.impl.util.jna.PosixMsync;
import net.openhft.chronicle.hash.impl.util.jna.WindowsMsync;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.impl.SerializationBuilder;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;

public abstract class VanillaChronicleHash<K, C extends HashEntry<K>, SC extends HashSegmentContext<K, ?>, ECQ extends ExternalHashQueryContext<K>>
implements ChronicleHash<K, C, SC, ECQ>,
Marshallable {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaChronicleHash.class);
    public static final long TIER_COUNTERS_AREA_SIZE = 64L;
    public static final long RESERVED_GLOBAL_MUTABLE_STATE_BYTES = 1024L;
    private String dataFileVersion = BuildVersion.version();
    public transient boolean createdOrInMemory = true;
    public Class<K> keyClass;
    public SizeMarshaller keySizeMarshaller;
    public SizedReader<K> keyReader;
    public DataAccess<K> keyDataAccess;
    public boolean checksumEntries;
    public int actualSegments;
    public HashSplitting hashSplitting;
    public long chunkSize;
    public int maxChunksPerEntry;
    public long actualChunksPerSegmentTier;
    int segmentHeaderSize;
    public int tierHashLookupValueBits;
    public int tierHashLookupKeyBits;
    public int tierHashLookupSlotSize;
    public long tierHashLookupCapacity;
    public long maxEntriesPerHashLookup;
    long tierHashLookupInnerSize;
    public long tierHashLookupOuterSize;
    public long tierFreeListInnerSize;
    public long tierFreeListOuterSize;
    long tierEntrySpaceInnerSize;
    public int tierEntrySpaceInnerOffset;
    long tierEntrySpaceOuterSize;
    public long tierSize;
    long maxExtraTiers;
    long tierBulkSizeInBytes;
    long tierBulkInnerOffsetToTiers;
    public long tiersInBulk;
    protected int log2TiersInBulk;
    private transient File file;
    private transient RandomAccessFile raf;
    private transient Cleaner rafCleaner;
    protected transient BytesStore bs;
    public transient List<TierBulkData> tierBulkOffsets;
    public transient long headerSize;
    public transient long segmentHeadersOffset;
    transient long segmentsOffset;
    public transient CompactOffHeapLinearHashTable hashLookup;
    protected volatile transient boolean closed;
    private transient Object closeLock;
    private transient VanillaGlobalMutableState globalMutableState;
    private transient ArrayList<WeakReference<ChainingInterface>> allContexts;
    static final LockingStrategy globalMutableStateLockingStrategy = VanillaReadWriteUpdateWithWaitsLockingStrategy.instance();
    static final TryAcquireOperation<LockingStrategy> globalMutableStateLockTryAcquireOperation = TryAcquireOperations.lock();
    static final AcquisitionStrategy<LockingStrategy, RuntimeException> globalMutableStateLockAcquisitionStrategy = AcquisitionStrategies.spinLoopOrFail((long)2L, (TimeUnit)TimeUnit.SECONDS);
    private static final long GLOBAL_MUTABLE_STATE_LOCK_OFFSET = 0L;
    private static final long GLOBAL_MUTABLE_STATE_VALUE_OFFSET = 8L;
    private static final Collection<WeakReference<ChainingInterface>> pseudoCollectionForExpunge = new AbstractCollection<WeakReference<ChainingInterface>>(){

        @Override
        public boolean contains(Object o) {
            ChainingInterface context = (ChainingInterface)((WeakReference)o).get();
            return context == null || !context.owner().isAlive();
        }

        @Override
        public Iterator<WeakReference<ChainingInterface>> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    };

    public VanillaChronicleHash(ChronicleMapBuilder<K, ?> builder) {
        ChronicleHashBuilderPrivateAPI privateAPI = (ChronicleHashBuilderPrivateAPI)builder.privateAPI();
        SerializationBuilder keyBuilder = privateAPI.keyBuilder();
        this.keyClass = keyBuilder.tClass;
        this.keySizeMarshaller = keyBuilder.sizeMarshaller();
        this.keyReader = keyBuilder.reader();
        this.keyDataAccess = keyBuilder.dataAccess();
        this.actualSegments = privateAPI.actualSegments();
        this.hashSplitting = HashSplitting.forSegments(this.actualSegments);
        this.chunkSize = privateAPI.chunkSize();
        this.maxChunksPerEntry = privateAPI.maxChunksPerEntry();
        this.actualChunksPerSegmentTier = privateAPI.actualChunksPerSegmentTier();
        this.segmentHeaderSize = privateAPI.segmentHeaderSize();
        this.tierHashLookupValueBits = CompactOffHeapLinearHashTable.valueBits(this.actualChunksPerSegmentTier);
        this.tierHashLookupKeyBits = CompactOffHeapLinearHashTable.keyBits(privateAPI.entriesPerSegment(), this.tierHashLookupValueBits);
        this.tierHashLookupSlotSize = CompactOffHeapLinearHashTable.entrySize(this.tierHashLookupKeyBits, this.tierHashLookupValueBits);
        if (!privateAPI.aligned64BitMemoryOperationsAtomic() && this.tierHashLookupSlotSize > 4) {
            throw new IllegalStateException("aligned64BitMemoryOperationsAtomic() == false, but hash lookup slot is " + this.tierHashLookupSlotSize);
        }
        this.tierHashLookupCapacity = privateAPI.tierHashLookupCapacity();
        this.maxEntriesPerHashLookup = (long)((double)this.tierHashLookupCapacity * 0.8);
        this.tierHashLookupInnerSize = this.tierHashLookupCapacity * (long)this.tierHashLookupSlotSize;
        this.tierHashLookupOuterSize = MemoryUnit.CACHE_LINES.align(this.tierHashLookupInnerSize, MemoryUnit.BYTES);
        this.tierFreeListInnerSize = MemoryUnit.LONGS.align(MemoryUnit.BYTES.alignAndConvert(this.actualChunksPerSegmentTier, MemoryUnit.BITS), MemoryUnit.BYTES);
        this.tierFreeListOuterSize = MemoryUnit.CACHE_LINES.align(this.tierFreeListInnerSize, MemoryUnit.BYTES);
        this.tierEntrySpaceInnerSize = this.chunkSize * this.actualChunksPerSegmentTier;
        this.tierEntrySpaceInnerOffset = privateAPI.segmentEntrySpaceInnerOffset();
        this.tierEntrySpaceOuterSize = MemoryUnit.CACHE_LINES.align((long)this.tierEntrySpaceInnerOffset + this.tierEntrySpaceInnerSize, MemoryUnit.BYTES);
        this.tierSize = this.tierSize();
        this.maxExtraTiers = privateAPI.maxExtraTiers();
        this.tiersInBulk = this.computeNumberOfTiersInBulk();
        this.log2TiersInBulk = Maths.intLog2((long)this.tiersInBulk);
        this.tierBulkInnerOffsetToTiers = this.computeTierBulkInnerOffsetToTiers(this.tiersInBulk);
        this.tierBulkSizeInBytes = this.computeTierBulkBytesSize(this.tiersInBulk);
        this.checksumEntries = privateAPI.checksumEntries();
    }

    public void readMarshallable(@NotNull WireIn wire) {
        this.readMarshallableFields(wire);
        this.initTransients();
    }

    protected void readMarshallableFields(@NotNull WireIn wireIn) {
        this.createdOrInMemory = false;
        this.dataFileVersion = wireIn.read(() -> "dataFileVersion").text();
        this.keyClass = wireIn.read(() -> "keyClass").typeLiteral();
        this.keySizeMarshaller = (SizeMarshaller)wireIn.read(() -> "keySizeMarshaller").typedMarshallable();
        this.keyReader = (SizedReader)wireIn.read(() -> "keyReader").typedMarshallable();
        this.keyDataAccess = (DataAccess)wireIn.read(() -> "keyDataAccess").typedMarshallable();
        this.checksumEntries = wireIn.read(() -> "checksumEntries").bool();
        this.actualSegments = wireIn.read(() -> "actualSegments").int32();
        this.hashSplitting = (HashSplitting)wireIn.read(() -> "hashSplitting").typedMarshallable();
        this.chunkSize = wireIn.read(() -> "chunkSize").int64();
        this.maxChunksPerEntry = wireIn.read(() -> "maxChunksPerEntry").int32();
        this.actualChunksPerSegmentTier = wireIn.read(() -> "actualChunksPerSegmentTier").int64();
        this.segmentHeaderSize = wireIn.read(() -> "segmentHeaderSize").int32();
        this.tierHashLookupValueBits = wireIn.read(() -> "tierHashLookupValueBits").int32();
        this.tierHashLookupKeyBits = wireIn.read(() -> "tierHashLookupKeyBits").int32();
        this.tierHashLookupSlotSize = wireIn.read(() -> "tierHashLookupSlotSize").int32();
        this.tierHashLookupCapacity = wireIn.read(() -> "tierHashLookupCapacity").int64();
        this.maxEntriesPerHashLookup = wireIn.read(() -> "maxEntriesPerHashLookup").int64();
        this.tierHashLookupInnerSize = wireIn.read(() -> "tierHashLookupInnerSize").int64();
        this.tierHashLookupOuterSize = wireIn.read(() -> "tierHashLookupOuterSize").int64();
        this.tierFreeListInnerSize = wireIn.read(() -> "tierFreeListInnerSize").int64();
        this.tierFreeListOuterSize = wireIn.read(() -> "tierFreeListOuterSize").int64();
        this.tierEntrySpaceInnerSize = wireIn.read(() -> "tierEntrySpaceInnerSize").int64();
        this.tierEntrySpaceInnerOffset = wireIn.read(() -> "tierEntrySpaceInnerOffset").int32();
        this.tierEntrySpaceOuterSize = wireIn.read(() -> "tierEntrySpaceOuterSize").int64();
        this.tierSize = wireIn.read(() -> "tierSize").int64();
        this.maxExtraTiers = wireIn.read(() -> "maxExtraTiers").int64();
        this.tierBulkSizeInBytes = wireIn.read(() -> "tierBulkSizeInBytes").int64();
        this.tierBulkInnerOffsetToTiers = wireIn.read(() -> "tierBulkInnerOffsetToTiers").int64();
        this.tiersInBulk = wireIn.read(() -> "tiersInBulk").int64();
        this.log2TiersInBulk = wireIn.read(() -> "log2TiersInBulk").int32();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "dataFileVersion").text(this.dataFileVersion);
        wireOut.write(() -> "keyClass").typeLiteral(this.keyClass);
        wireOut.write(() -> "keySizeMarshaller").typedMarshallable((WriteMarshallable)this.keySizeMarshaller);
        wireOut.write(() -> "keyReader").typedMarshallable(this.keyReader);
        wireOut.write(() -> "keyDataAccess").typedMarshallable(this.keyDataAccess);
        wireOut.write(() -> "checksumEntries").bool(Boolean.valueOf(this.checksumEntries));
        wireOut.write(() -> "actualSegments").int32(this.actualSegments);
        wireOut.write(() -> "hashSplitting").typedMarshallable((WriteMarshallable)this.hashSplitting);
        wireOut.write(() -> "chunkSize").int64(this.chunkSize);
        wireOut.write(() -> "maxChunksPerEntry").int32(this.maxChunksPerEntry);
        wireOut.write(() -> "actualChunksPerSegmentTier").int64(this.actualChunksPerSegmentTier);
        wireOut.write(() -> "segmentHeaderSize").int32(this.segmentHeaderSize);
        wireOut.write(() -> "tierHashLookupValueBits").int32(this.tierHashLookupValueBits);
        wireOut.write(() -> "tierHashLookupKeyBits").int32(this.tierHashLookupKeyBits);
        wireOut.write(() -> "tierHashLookupSlotSize").int32(this.tierHashLookupSlotSize);
        wireOut.write(() -> "tierHashLookupCapacity").int64(this.tierHashLookupCapacity);
        wireOut.write(() -> "maxEntriesPerHashLookup").int64(this.maxEntriesPerHashLookup);
        wireOut.write(() -> "tierHashLookupInnerSize").int64(this.tierHashLookupInnerSize);
        wireOut.write(() -> "tierHashLookupOuterSize").int64(this.tierHashLookupOuterSize);
        wireOut.write(() -> "tierFreeListInnerSize").int64(this.tierFreeListInnerSize);
        wireOut.write(() -> "tierFreeListOuterSize").int64(this.tierFreeListOuterSize);
        wireOut.write(() -> "tierEntrySpaceInnerSize").int64(this.tierEntrySpaceInnerSize);
        wireOut.write(() -> "tierEntrySpaceInnerOffset").int32(this.tierEntrySpaceInnerOffset);
        wireOut.write(() -> "tierEntrySpaceOuterSize").int64(this.tierEntrySpaceOuterSize);
        wireOut.write(() -> "tierSize").int64(this.tierSize);
        wireOut.write(() -> "maxExtraTiers").int64(this.maxExtraTiers);
        wireOut.write(() -> "tierBulkSizeInBytes").int64(this.tierBulkSizeInBytes);
        wireOut.write(() -> "tierBulkInnerOffsetToTiers").int64(this.tierBulkInnerOffsetToTiers);
        wireOut.write(() -> "tiersInBulk").int64(this.tiersInBulk);
        wireOut.write(() -> "log2TiersInBulk").int32(this.log2TiersInBulk);
    }

    protected VanillaGlobalMutableState createGlobalMutableState() {
        return (VanillaGlobalMutableState)Values.newNativeReference(VanillaGlobalMutableState.class);
    }

    public VanillaGlobalMutableState globalMutableState() {
        return this.globalMutableState;
    }

    private long tierSize() {
        long segmentSize = this.tierHashLookupOuterSize + 64L + this.tierFreeListOuterSize + this.tierEntrySpaceOuterSize;
        if ((segmentSize & 0x3FL) != 0L) {
            throw new AssertionError();
        }
        return this.breakL1CacheAssociativityContention(segmentSize);
    }

    protected final long breakL1CacheAssociativityContention(long sizeInBytes) {
        int alignmentToBreak = 2048;
        int eachNthSegmentFallIntoTheSameSet = Math.max(1, alignmentToBreak >> Long.numberOfTrailingZeros(sizeInBytes));
        if (eachNthSegmentFallIntoTheSameSet < this.actualSegments) {
            sizeInBytes |= MemoryUnit.CACHE_LINES.toBytes(1L);
        }
        return sizeInBytes;
    }

    private long computeNumberOfTiersInBulk() {
        int tiersInBulk = this.actualSegments / 8;
        tiersInBulk = Maths.nextPower2((int)tiersInBulk, (int)1);
        while (this.computeTierBulkBytesSize(tiersInBulk) < (long)OS.pageSize()) {
            tiersInBulk *= 2;
        }
        return tiersInBulk;
    }

    private long computeTierBulkBytesSize(long tiersInBulk) {
        return this.computeTierBulkInnerOffsetToTiers(tiersInBulk) + tiersInBulk * this.tierSize;
    }

    protected long computeTierBulkInnerOffsetToTiers(long tiersInBulk) {
        return 0L;
    }

    public void initTransients() {
        this.initOwnTransients();
    }

    private void initOwnTransients() {
        this.closed = false;
        this.closeLock = new Object();
        this.globalMutableState = this.createGlobalMutableState();
        this.tierBulkOffsets = new ArrayList<TierBulkData>();
        if (this.tierHashLookupSlotSize == 4) {
            this.hashLookup = new IntCompactOffHeapLinearHashTable(this);
        } else if (this.tierHashLookupSlotSize == 8) {
            this.hashLookup = new LongCompactOffHeapLinearHashTable(this);
        } else {
            throw new AssertionError((Object)("hash lookup slot size could be 4 or 8, " + this.tierHashLookupSlotSize + " observed"));
        }
        this.allContexts = new ArrayList();
    }

    public final void initBeforeMapping(File file, RandomAccessFile raf, long headerEnd, boolean recover) throws IOException {
        this.file = file;
        this.raf = raf;
        this.headerSize = VanillaChronicleHash.roundUpMapHeaderSize(headerEnd);
        if (!this.createdOrInMemory) {
            ByteBuffer globalMutableStateBuffer = ByteBuffer.allocate((int)this.globalMutableState.maxSize());
            FileChannel fileChannel = raf.getChannel();
            while (globalMutableStateBuffer.remaining() > 0) {
                if (fileChannel.read(globalMutableStateBuffer, this.headerSize + 8L + (long)globalMutableStateBuffer.position()) != -1) continue;
                throw VanillaChronicleHash.throwRecoveryOrReturnIOException(file + " truncated", recover);
            }
            globalMutableStateBuffer.flip();
            this.globalMutableState.bytesStore(BytesStore.wrap((ByteBuffer)globalMutableStateBuffer), 0L, this.globalMutableState.maxSize());
        }
    }

    public static IOException throwRecoveryOrReturnIOException(String message, boolean recover) {
        if (recover) {
            throw new ChronicleHashRecoveryFailedException(message);
        }
        return new IOException(message);
    }

    private static long roundUpMapHeaderSize(long headerSize) {
        return MemoryUnit.CACHE_LINES.align(headerSize, MemoryUnit.BYTES);
    }

    public final void createMappedStoreAndSegments(BytesStore bytesStore) throws IOException {
        this.initBytesStoreAndHeadersViews(bytesStore);
        this.initOffsetsAndBulks();
    }

    private void initOffsetsAndBulks() {
        this.segmentHeadersOffset = this.segmentHeadersOffset();
        long segmentHeadersSize = this.actualSegments * this.segmentHeaderSize;
        this.segmentsOffset = this.segmentHeadersOffset + segmentHeadersSize;
        if (this.createdOrInMemory) {
            this.zeroOutNewlyMappedChronicleMapBytes();
            this.globalMutableState.setSegmentHeadersOffset(this.segmentHeadersOffset);
            this.globalMutableState.setDataStoreSize(this.sizeInBytesWithoutTiers());
        } else {
            this.initBulks();
        }
    }

    private void initBulks() {
        if (this.globalMutableState.getAllocatedExtraTierBulks() > 0) {
            this.appendBulkData(0, this.globalMutableState.getAllocatedExtraTierBulks() - 1, this.bs, this.sizeInBytesWithoutTiers());
        }
    }

    private void initBytesStoreAndHeadersViews(BytesStore bytesStore) {
        if (bytesStore.start() != 0L) {
            throw new AssertionError((Object)("bytes store " + bytesStore + " starts from " + bytesStore.start() + ", 0 expected"));
        }
        this.bs = bytesStore;
        this.globalMutableState.bytesStore(this.bs, this.headerSize + 8L, this.globalMutableState.maxSize());
        this.onHeaderCreated();
    }

    public void registerRafReleaser() {
        this.rafCleaner = Cleaner.create((Object)this, (Runnable)new RafReleaser(this.file));
    }

    public final void createMappedStoreAndSegments() throws IOException {
        this.createMappedStoreAndSegments((BytesStore)this.map(this.dataStoreSize(), 0L));
    }

    public final void basicRecover() throws IOException {
        long segmentHeadersOffset = this.globalMutableState().getSegmentHeadersOffset();
        if (segmentHeadersOffset <= 0L || segmentHeadersOffset % 4096L != 0L || segmentHeadersOffset > MemoryUnit.GIGABYTES.toBytes(1L)) {
            segmentHeadersOffset = this.computeSegmentHeadersOffset();
        }
        long sizeInBytesWithoutTiers = this.computeSizeInBytesWithoutTiers(segmentHeadersOffset);
        long dataStoreSize = this.globalMutableState().getDataStoreSize();
        int allocatedExtraTierBulks = this.globalMutableState().getAllocatedExtraTierBulks();
        if (dataStoreSize < sizeInBytesWithoutTiers || (dataStoreSize - sizeInBytesWithoutTiers) % this.tierBulkSizeInBytes != 0L) {
            dataStoreSize = sizeInBytesWithoutTiers + (long)allocatedExtraTierBulks * this.tierBulkSizeInBytes;
        } else {
            allocatedExtraTierBulks = (int)((dataStoreSize - sizeInBytesWithoutTiers) / this.tierBulkSizeInBytes);
        }
        this.initBytesStoreAndHeadersViews((BytesStore)this.map(dataStoreSize, 0L));
        this.resetGlobalMutableStateLock();
        this.recoverAllocatedExtraTierBulks(allocatedExtraTierBulks);
        this.recoverSegmentHeadersOffset(segmentHeadersOffset);
        this.recoverDataStoreSize(dataStoreSize);
        this.initOffsetsAndBulks();
    }

    private void resetGlobalMutableStateLock() {
        long lockAddr = this.globalMutableStateAddress() + 0L;
        LockingStrategy lockingStrategy = globalMutableStateLockingStrategy;
        long lockState = lockingStrategy.getState((ReadAccess)Access.nativeAccess(), null, lockAddr);
        if (lockState != lockingStrategy.resetState()) {
            LOG.error("global mutable state lock of map at {} is not clear: {}", (Object)this.file, (Object)lockingStrategy.toString(lockState));
            lockingStrategy.reset(Access.nativeAccess(), null, lockAddr);
        }
    }

    private void recoverAllocatedExtraTierBulks(int allocatedExtraTierBulks) {
        if (this.globalMutableState.getAllocatedExtraTierBulks() != allocatedExtraTierBulks) {
            LOG.error("allocated extra tier bulks counter corrupted, or the map file {} is truncated. stored: {}, should be: {}", new Object[]{this.file, this.globalMutableState.getAllocatedExtraTierBulks(), allocatedExtraTierBulks});
            this.globalMutableState.setAllocatedExtraTierBulks(allocatedExtraTierBulks);
        }
    }

    private void recoverSegmentHeadersOffset(long segmentHeadersOffset) {
        if (this.globalMutableState.getSegmentHeadersOffset() != segmentHeadersOffset) {
            LOG.error("segment headers offset of map at {} corrupted. stored: {}, should be: {}", new Object[]{this.file, this.globalMutableState.getSegmentHeadersOffset(), segmentHeadersOffset});
            this.globalMutableState.setSegmentHeadersOffset(segmentHeadersOffset);
        }
    }

    private void recoverDataStoreSize(long dataStoreSize) {
        if (this.globalMutableState.getDataStoreSize() != dataStoreSize) {
            LOG.error("data store size of map at {} corrupted. stored: {}, should be: {}", new Object[]{this.file, this.globalMutableState.getDataStoreSize(), dataStoreSize});
            this.globalMutableState.setDataStoreSize(dataStoreSize);
        }
    }

    private boolean persisted() {
        return this.file != null;
    }

    protected void zeroOutNewlyMappedChronicleMapBytes() {
        this.zeroOutGlobalMutableState();
        this.zeroOutSegmentHeaders();
        this.zeroOutFirstSegmentTiers();
    }

    private void zeroOutGlobalMutableState() {
        this.bs.zeroOut(this.headerSize, this.headerSize + this.globalMutableStateTotalUsedSize());
    }

    protected long globalMutableStateTotalUsedSize() {
        return 8L + this.globalMutableState().maxSize();
    }

    private void zeroOutSegmentHeaders() {
        this.bs.zeroOut(this.segmentHeadersOffset, this.segmentsOffset);
    }

    private void zeroOutFirstSegmentTiers() {
        for (int segmentIndex = 0; segmentIndex < this.segments(); ++segmentIndex) {
            long segmentOffset = this.segmentOffset(segmentIndex);
            this.zeroOutNewlyMappedTier(this.bs, segmentOffset);
        }
    }

    private void zeroOutNewlyMappedTier(BytesStore bytesStore, long tierOffset) {
        bytesStore.zeroOut(tierOffset, tierOffset + this.tierSize - this.tierEntrySpaceOuterSize);
    }

    public void onHeaderCreated() {
    }

    public String persistedDataVersion() {
        return this.dataFileVersion;
    }

    private long segmentHeadersOffset() {
        if (this.createdOrInMemory) {
            return this.computeSegmentHeadersOffset();
        }
        return this.globalMutableState.getSegmentHeadersOffset();
    }

    private long computeSegmentHeadersOffset() {
        long reserved = 1024L - this.globalMutableStateTotalUsedSize();
        return OS.pageAlign((long)(this.mapHeaderInnerSize() + reserved));
    }

    public long mapHeaderInnerSize() {
        return this.headerSize + this.globalMutableStateTotalUsedSize();
    }

    @Override
    public File file() {
        return this.file;
    }

    public final long sizeInBytesWithoutTiers() {
        return this.computeSizeInBytesWithoutTiers(this.segmentHeadersOffset());
    }

    private long computeSizeInBytesWithoutTiers(long segmentHeadersOffset) {
        return segmentHeadersOffset + (long)this.actualSegments * ((long)this.segmentHeaderSize + this.tierSize);
    }

    public final long dataStoreSize() {
        long sizeInBytesWithoutTiers = this.sizeInBytesWithoutTiers();
        int allocatedExtraTierBulks = !this.createdOrInMemory ? this.globalMutableState.getAllocatedExtraTierBulks() : 0;
        return sizeInBytesWithoutTiers + (long)allocatedExtraTierBulks * this.tierBulkSizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            Iterator<TierBulkData> iterator = this.allContexts;
            synchronized (iterator) {
                this.closed = true;
            }
            for (WeakReference weakReference : this.allContexts) {
                ChainingInterface context = (ChainingInterface)weakReference.get();
                if (context == null || !context.owner().isAlive()) continue;
                context.closeContext();
            }
            this.bs.release();
            assert (this.bs.refCount() == 0L);
            for (TierBulkData tierBulkData : this.tierBulkOffsets) {
                if (tierBulkData.bytesStore == this.bs) continue;
                tierBulkData.bytesStore.release();
                assert (tierBulkData.bytesStore.refCount() == 0L);
            }
            if (this.rafCleaner != null) {
                this.rafCleaner.clean();
            }
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    public final void checkKey(Object key) {
        if (!this.keyClass.isInstance(key)) {
            throw new ClassCastException("Key must be a " + this.keyClass.getName() + " but was a " + key.getClass());
        }
    }

    public final long segmentHeaderAddress(int segmentIndex) {
        return this.bsAddress() + this.segmentHeadersOffset + (long)segmentIndex * (long)this.segmentHeaderSize;
    }

    public long bsAddress() {
        return this.bs.address(0L);
    }

    public final long segmentBaseAddr(int segmentIndex) {
        return this.bsAddress() + this.segmentOffset(segmentIndex);
    }

    private long segmentOffset(long segmentIndex) {
        return this.segmentsOffset + segmentIndex * this.tierSize;
    }

    public final int inChunks(long sizeInBytes) {
        if (sizeInBytes <= this.chunkSize) {
            return 1;
        }
        if (--sizeInBytes <= Integer.MAX_VALUE) {
            return (int)sizeInBytes / (int)this.chunkSize + 1;
        }
        return (int)(sizeInBytes / this.chunkSize) + 1;
    }

    public final int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    @Override
    public int segments() {
        return this.actualSegments;
    }

    private long globalMutableStateAddress() {
        return this.bsAddress() + this.headerSize;
    }

    public void globalMutableStateLock() {
        globalMutableStateLockAcquisitionStrategy.acquire(globalMutableStateLockTryAcquireOperation, globalMutableStateLockingStrategy, Access.nativeAccess(), null, this.globalMutableStateAddress() + 0L);
    }

    public void globalMutableStateUnlock() {
        globalMutableStateLockingStrategy.unlock(Access.nativeAccess(), null, this.globalMutableStateAddress() + 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateTier() {
        this.globalMutableStateLock();
        try {
            long tiersInUse = this.globalMutableState.getExtraTiersInUse();
            if (tiersInUse >= this.maxExtraTiers) {
                throw new IllegalStateException("Attempt to allocate #" + (tiersInUse + 1L) + " extra segment tier, " + this.maxExtraTiers + " is maximum.\n" + "Possible reasons include:\n" + " - you have forgotten to configure (or configured wrong) " + "builder.entries() number\n" + " - same regarding other sizing Chronicle Hash configurations, most " + "likely maxBloatFactor(), averageKeySize(), or averageValueSize()\n" + " - keys, inserted into the ChronicleHash, are distributed suspiciously " + "bad. This might be a DOS attack");
            }
            long firstFreeTierIndex = this.globalMutableState.getFirstFreeTierIndex();
            if (firstFreeTierIndex < 0L) {
                throw new RuntimeException("unexpected firstFreeTierIndex value " + firstFreeTierIndex);
            }
            if (firstFreeTierIndex == 0L) {
                try {
                    this.allocateTierBulk();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                firstFreeTierIndex = this.globalMutableState.getFirstFreeTierIndex();
                if (firstFreeTierIndex <= 0L) {
                    throw new RuntimeException("unexpected firstFreeTierIndex value " + firstFreeTierIndex);
                }
            }
            this.globalMutableState.setExtraTiersInUse(tiersInUse + 1L);
            BytesStore allocatedTierBytes = this.tierBytesStore(firstFreeTierIndex);
            long allocatedTierOffset = this.tierBytesOffset(firstFreeTierIndex);
            long tierBaseAddr = allocatedTierBytes.address(0L) + allocatedTierOffset;
            long tierCountersAreaAddr = tierBaseAddr + this.tierHashLookupOuterSize;
            long nextFreeTierIndex = TierCountersArea.nextTierIndex(tierCountersAreaAddr);
            this.globalMutableState.setFirstFreeTierIndex(nextFreeTierIndex);
            long l = firstFreeTierIndex;
            return l;
        }
        finally {
            this.globalMutableStateUnlock();
        }
    }

    private void allocateTierBulk() throws IOException {
        int allocatedExtraTierBulks = this.globalMutableState.getAllocatedExtraTierBulks();
        this.mapTierBulks(allocatedExtraTierBulks);
        long firstTierIndex = this.extraTierIndexToTierIndex((long)allocatedExtraTierBulks * this.tiersInBulk);
        BytesStore tierBytesStore = this.tierBytesStore(firstTierIndex);
        long firstTierOffset = this.tierBytesOffset(firstTierIndex);
        if (this.tierBulkInnerOffsetToTiers > 0L) {
            tierBytesStore.zeroOut(firstTierOffset - this.tierBulkInnerOffsetToTiers, firstTierOffset);
        }
        long lastTierIndex = firstTierIndex + this.tiersInBulk - 1L;
        this.linkAndZeroOutFreeTiers(firstTierIndex, lastTierIndex);
        if (this.persisted()) {
            long address = tierBytesStore.address(firstTierOffset - this.tierBulkInnerOffsetToTiers);
            long endAddress = tierBytesStore.address(this.tierBytesOffset(lastTierIndex)) + this.tierSize;
            long length = endAddress - address;
            this.msync(address, length);
        }
        this.globalMutableState.setAllocatedExtraTierBulks(allocatedExtraTierBulks + 1);
        this.globalMutableState.setFirstFreeTierIndex(firstTierIndex);
        this.globalMutableState.addDataStoreSize(this.tierBulkSizeInBytes);
    }

    public void msync() throws IOException {
        this.msync(this.bsAddress(), this.bs.capacity());
    }

    private void msync(long address, long length) throws IOException {
        if (OS.pageAlign((long)address) != address) {
            long oldAddress = address;
            address = OS.pageAlign((long)address) - (long)OS.pageSize();
            length += oldAddress - address;
        }
        if (OS.isWindows()) {
            WindowsMsync.msync(this.raf, address, length);
        } else {
            PosixMsync.msync(address, length);
        }
    }

    public void linkAndZeroOutFreeTiers(long firstTierIndex, long lastTierIndex) {
        for (long tierIndex = firstTierIndex; tierIndex <= lastTierIndex; ++tierIndex) {
            long tierOffset = this.tierBytesOffset(tierIndex);
            BytesStore tierBytesStore = this.tierBytesStore(tierIndex);
            this.zeroOutNewlyMappedTier(tierBytesStore, tierOffset);
            if (tierIndex >= lastTierIndex) continue;
            long tierCountersAreaOffset = tierOffset + this.tierHashLookupOuterSize;
            TierCountersArea.nextTierIndex(tierBytesStore.address(0L) + tierCountersAreaOffset, tierIndex + 1L);
        }
    }

    public long extraTierIndexToTierIndex(long extraTierIndex) {
        return (long)this.actualSegments + extraTierIndex + 1L;
    }

    public long tierIndexToBaseAddr(long tierIndex) {
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.segmentBaseAddr((int)tierIndexMinusOne);
        }
        return this.extraTierIndexToBaseAddr(tierIndexMinusOne);
    }

    public BytesStore tierBytesStore(long tierIndex) {
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.bs;
        }
        return this.tierBulkData((long)tierIndexMinusOne).bytesStore;
    }

    public long tierBytesOffset(long tierIndex) {
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.segmentOffset(tierIndexMinusOne);
        }
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        return this.tierBulkOffsets.get((int)bulkIndex).offset + this.tierBulkInnerOffsetToTiers + (extraTierIndex & this.tiersInBulk - 1L) * this.tierSize;
    }

    private TierBulkData tierBulkData(long tierIndexMinusOne) {
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        return this.tierBulkOffsets.get(bulkIndex);
    }

    private long extraTierIndexToBaseAddr(long tierIndexMinusOne) {
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        TierBulkData tierBulkData = this.tierBulkOffsets.get(bulkIndex);
        long tierIndexOffsetWithinBulk = extraTierIndex & this.tiersInBulk - 1L;
        return this.tierAddr(tierBulkData, tierIndexOffsetWithinBulk);
    }

    protected long tierAddr(TierBulkData tierBulkData, long tierIndexOffsetWithinBulk) {
        return tierBulkData.bytesStore.address(0L) + tierBulkData.offset + this.tierBulkInnerOffsetToTiers + tierIndexOffsetWithinBulk * this.tierSize;
    }

    private void mapTierBulks(int upToBulkIndex) {
        if (this.persisted()) {
            try {
                this.mapTierBulksMapped(upToBulkIndex);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.allocateTierBulks(upToBulkIndex);
        }
    }

    private void mapTierBulksMapped(int upToBulkIndex) throws IOException {
        long firstBulkToMapOffsetWithinMapping;
        long mappingOffsetInFile;
        int firstBulkToMapIndex = this.tierBulkOffsets.size();
        int bulksToMap = upToBulkIndex + 1 - firstBulkToMapIndex;
        long mapSize = (long)bulksToMap * this.tierBulkSizeInBytes;
        long firstBulkToMapOffset = this.bulkOffset(firstBulkToMapIndex);
        if (OS.mapAlign((long)firstBulkToMapOffset) == firstBulkToMapOffset) {
            mappingOffsetInFile = firstBulkToMapOffset;
            firstBulkToMapOffsetWithinMapping = 0L;
        } else {
            mappingOffsetInFile = OS.mapAlign((long)firstBulkToMapOffset) - OS.mapAlignment();
            firstBulkToMapOffsetWithinMapping = firstBulkToMapOffset - mappingOffsetInFile;
            mapSize += firstBulkToMapOffsetWithinMapping;
        }
        NativeBytesStore extraStore = this.map(mapSize, mappingOffsetInFile);
        this.appendBulkData(firstBulkToMapIndex, upToBulkIndex, (BytesStore)extraStore, firstBulkToMapOffsetWithinMapping);
    }

    private NativeBytesStore map(long mapSize, long mappingOffsetInFile) throws IOException {
        mapSize = OS.pageAlign((long)mapSize);
        long minFileSize = mappingOffsetInFile + mapSize;
        FileChannel fileChannel = this.raf.getChannel();
        if (fileChannel.size() < minFileSize) {
            this.raf.setLength(minFileSize);
        }
        long address = OS.map((FileChannel)fileChannel, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)mappingOffsetInFile, (long)mapSize);
        OS.Unmapper unmapper = new OS.Unmapper(address, mapSize, (ReferenceCounted)DummyReferenceCounted.DUMMY_REFERENCE_COUNTED);
        return new NativeBytesStore(address, mapSize, (Runnable)unmapper, false);
    }

    private long bulkOffset(int bulkIndex) {
        return this.sizeInBytesWithoutTiers() + (long)bulkIndex * this.tierBulkSizeInBytes;
    }

    private void allocateTierBulks(int upToBulkIndex) {
        int firstBulkToMapIndex = this.tierBulkOffsets.size();
        int bulksToMap = upToBulkIndex + 1 - firstBulkToMapIndex;
        long mapSize = (long)bulksToMap * this.tierBulkSizeInBytes;
        NativeBytesStore extraStore = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity((long)mapSize);
        this.appendBulkData(firstBulkToMapIndex, upToBulkIndex, (BytesStore)extraStore, 0L);
    }

    private void appendBulkData(int firstBulkToMapIndex, int upToBulkIndex, BytesStore extraStore, long offsetWithinMapping) {
        TierBulkData firstMappedBulkData = new TierBulkData(extraStore, offsetWithinMapping);
        this.tierBulkOffsets.add(firstMappedBulkData);
        for (int bulkIndex = firstBulkToMapIndex + 1; bulkIndex <= upToBulkIndex; ++bulkIndex) {
            this.tierBulkOffsets.add(new TierBulkData(firstMappedBulkData, offsetWithinMapping += this.tierBulkSizeInBytes));
        }
    }

    private void checkOpen() {
        if (this.closed) {
            throw new ChronicleHashClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContext(ChainingInterface context) {
        ArrayList<WeakReference<ChainingInterface>> arrayList = this.allContexts;
        synchronized (arrayList) {
            this.checkOpen();
            this.allContexts.removeAll(pseudoCollectionForExpunge);
            this.allContexts.add(new WeakReference<ChainingInterface>(context));
        }
    }

    public List<WeakReference<ChainingInterface>> allContexts() {
        return Collections.unmodifiableList(this.allContexts);
    }

    private static class RafReleaser
    implements Runnable {
        final File file;

        private RafReleaser(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                CanonicalRandomAccessFiles.release(this.file);
            }
            catch (IOException e) {
                LOG.error("error on releasing RAF for file {}: {}", (Object)this.file, (Object)e);
            }
        }
    }

    public static class TierBulkData {
        public final BytesStore bytesStore;
        public final long offset;

        public TierBulkData(BytesStore bytesStore, long offset) {
            this.bytesStore = bytesStore;
            this.offset = offset;
        }

        public TierBulkData(TierBulkData data, long offset) {
            this.bytesStore = data.bytesStore;
            this.offset = offset;
        }
    }
}

