/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.hash.serialization.impl.InstanceCreatingMarshaller;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizedMarshallableDataAccess<T>
extends InstanceCreatingMarshaller<T>
implements DataAccess<T>,
Data<T> {
    private SizedReader<T> sizedReader;
    private SizedWriter<? super T> sizedWriter;
    private transient boolean bytesInit;
    private transient Bytes bytes;
    private transient long size;
    private transient VanillaBytes targetBytes;
    private transient T instance;

    public SizedMarshallableDataAccess(Class<T> tClass, SizedReader<T> sizedReader, SizedWriter<? super T> sizedWriter) {
        super(tClass);
        this.sizedWriter = sizedWriter;
        this.sizedReader = sizedReader;
        this.initTransients();
    }

    SizedReader<T> sizedReader() {
        return this.sizedReader;
    }

    SizedWriter<? super T> sizedWriter() {
        return this.sizedWriter;
    }

    private void initTransients() {
        this.bytes = Bytes.allocateElasticDirect((long)1L);
        this.targetBytes = VanillaBytes.vanillaBytes();
    }

    @Override
    public RandomDataInput bytes() {
        if (!this.bytesInit) {
            this.bytes.clear();
            this.sizedWriter.write(this.bytes, this.size, this.instance);
            this.bytesInit = true;
        }
        return this.bytes.bytesStore();
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void writeTo(RandomDataOutput target, long targetOffset) {
        if (this.bytesInit || !(target instanceof BytesStore)) {
            target.write(targetOffset, this.bytes(), this.offset(), this.size);
        } else {
            this.targetBytes.bytesStore((BytesStore)target, targetOffset, this.size);
            this.targetBytes.writePosition(targetOffset);
            this.sizedWriter.write((Bytes)this.targetBytes, this.size, this.instance);
            this.targetBytes.bytesStore((BytesStore)NoBytesStore.NO_BYTES_STORE, 0L, 0L);
        }
    }

    @Override
    public T get() {
        return this.instance;
    }

    @Override
    public T getUsing(@Nullable T using) {
        if (using == null) {
            using = this.createInstance();
        }
        T result = this.sizedReader.read(this.bytes, this.size(), using);
        this.bytes.readPosition(0L);
        return result;
    }

    public int hashCode() {
        return this.dataHashCode();
    }

    public boolean equals(Object obj) {
        return this.dataEquals(obj);
    }

    public String toString() {
        return this.get().toString();
    }

    @Override
    public Data<T> getData(@NotNull T instance) {
        this.instance = instance;
        this.size = this.sizedWriter.size(instance);
        this.bytesInit = false;
        return this;
    }

    @Override
    public void uninit() {
        this.instance = null;
    }

    @Override
    public DataAccess<T> copy() {
        return new SizedMarshallableDataAccess<T>(this.tClass(), StatefulCopyable.copyIfNeeded(this.sizedReader), StatefulCopyable.copyIfNeeded(this.sizedWriter));
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        super.readMarshallable(wireIn);
        this.sizedReader = (SizedReader)wireIn.read(() -> "sizedReader").typedMarshallable();
        this.sizedWriter = (SizedWriter)wireIn.read(() -> "sizedWriter").typedMarshallable();
        this.initTransients();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
        super.writeMarshallable(wireOut);
        wireOut.write(() -> "sizedReader").typedMarshallable(this.sizedReader);
        wireOut.write(() -> "sizedWriter").typedMarshallable(this.sizedWriter);
    }
}

