/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.hash;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.sg.Stage;
import net.openhft.sg.Staged;

@Staged
public abstract class Chaining
extends ChainingInterface {
    public final List<ChainingInterface> contextChain;
    public final int indexInContextChain;
    public final ChainingInterface rootContextInThisThread;
    @Stage(value="Used")
    public boolean used;
    @Stage(value="Used")
    private boolean firstContextLockedInThisThread;

    public Chaining() {
        this.contextChain = new ArrayList<ChainingInterface>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.rootContextInThisThread = this;
    }

    public Chaining(ChainingInterface rootContextInThisThread) {
        this.contextChain = rootContextInThisThread.getContextChain();
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.rootContextInThisThread = rootContextInThisThread;
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return this.contextChain;
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    @Override
    public boolean usedInit() {
        return this.used;
    }

    @Override
    public void initUsed(boolean used) {
        assert (used);
        this.firstContextLockedInThisThread = this.rootContextInThisThread.lockContextLocally();
        this.used = true;
    }

    void closeUsed() {
        this.used = false;
        if (this.firstContextLockedInThisThread) {
            this.rootContextInThisThread.unlockContextLocally();
        }
    }

    @Override
    public <T extends ChainingInterface> T getContext(Class<? extends T> contextClass, Function<ChainingInterface, T> createChaining) {
        ChainingInterface context2;
        for (ChainingInterface context2 : this.contextChain) {
            if (context2.getClass() != contextClass || context2.usedInit()) continue;
            context2.initUsed(true);
            return (T)context2;
        }
        int maxNestedContexts = 1024;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context2 = (ChainingInterface)createChaining.apply(this);
        context2.initUsed(true);
        return (T)context2;
    }
}

