/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.entry;

import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.stage.entry.AllocatedChunks;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.data.bytes.EntryValueBytesData;
import net.openhft.lang.io.Bytes;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public abstract class MapEntryStages<K, V>
extends HashEntryStages<K>
implements MapEntry<K, V> {
    @StageRef
    public VanillaChronicleMapHolder<?, ?, ?, ?, ?, ?, ?> mh;
    @StageRef
    public AllocatedChunks allocatedChunks;
    @StageRef
    KeySearch<K> ks;
    public long valueSizeOffset = -1L;
    @Stage(value="ValueSize")
    public long valueSize = -1L;
    @Stage(value="ValueSize")
    public long valueOffset;
    @StageRef
    public EntryValueBytesData<V> entryValue;

    long countValueSizeOffset() {
        return this.keyEnd();
    }

    void initValueSizeOffset() {
        this.valueSizeOffset = this.countValueSizeOffset();
    }

    @Stage(value="ValueSize")
    private void countValueOffset() {
        this.mh.m().alignment.alignPositionAddr((Bytes)this.s.segmentBytes);
        this.valueOffset = this.s.segmentBytes.position();
    }

    void initValueSize(long valueSize) {
        this.valueSize = valueSize;
        this.s.segmentBytes.position(this.valueSizeOffset);
        this.mh.m().valueSizeMarshaller.writeSize((Bytes)this.s.segmentBytes, valueSize);
        this.countValueOffset();
    }

    void initValueSize() {
        this.s.segmentBytes.position(this.valueSizeOffset);
        this.valueSize = this.mh.m().readValueSize((Bytes)this.s.segmentBytes);
        this.countValueOffset();
    }

    void initValueSize_EqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset + (oldValueOffset - oldValueSizeOffset);
    }

    public void initValue(Data<?> value) {
        this.s.segmentBytes.position(this.valueSizeOffset);
        this.initValueSize(value.size());
        this.writeValue(value);
    }

    public void writeValue(Data<?> value) {
        value.writeTo((RandomDataOutput)this.s.segmentBS, this.valueOffset);
    }

    public void initValue_WithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert (oldValueSize == value.size());
        this.initValueSize_EqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        this.writeValue(value);
    }

    @Override
    protected long entryEnd() {
        return this.valueOffset + this.valueSize;
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entryValue;
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        throw new AssertionError((Object)"putValueDeletedEntry() might be called only from non-Replicated Map query context");
    }

    public void writeValueAndPutPos(Data<V> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.hlp.putValueVolatile(this.pos);
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset + (long)this.mh.m().valueSizeMarshaller.sizeEncodingSize(newValue.size()) - this.keySizeOffset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.s.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize;
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset;
            VanillaChronicleMap<?, ?, ?, ?, ?, ?, ?> m = this.mh.m();
            int newSizeInChunks = m.inChunks(newEntrySize = (newValueOffset = m.alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue)) + newValue.size() - entryStartOffset);
            if (newSizeInChunks > this.entrySizeInChunks) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.s.freeList.isRangeClear(this.pos + (long)this.entrySizeInChunks, this.pos + (long)newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
                this.s.freeList.setRange(this.pos + (long)this.entrySizeInChunks, this.pos + (long)newSizeInChunks);
            } else if (newSizeInChunks < this.entrySizeInChunks) {
                this.s.freeList.clearRange(this.pos + (long)newSizeInChunks, this.pos + (long)this.entrySizeInChunks);
            }
        }
        this.s.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
            return;
        }
        this.writeValue(newValue);
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.s.innerWriteLock.lock();
        this.s.free(this.pos, this.entrySizeInChunks);
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hlp.hashLookupPos;
        long oldHashLookupAddr = this.s.segmentBaseAddr;
        boolean tierHasChanged = this.allocatedChunks.initEntryAndKeyCopying(entrySize, this.valueSizeOffset - this.keySizeOffset);
        if (tierHasChanged && !this.ks.searchStateAbsent()) {
            throw new AssertionError();
        }
        this.initValue(newValue);
        this.freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.hh.h().hashLookup;
        long oldEntry = hl.readEntry(oldHashLookupAddr, oldHashLookupPos);
        hl.checkValueForPut(this.pos);
        hl.writeEntryVolatile(this.s.segmentBaseAddr, this.hlp.hashLookupPos, oldEntry, hl.key(oldEntry), this.pos);
        if (tierHasChanged) {
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        }
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (this.mh.m().constantlySizedEntry) {
            return this.mh.m().alignment.alignAddr(sizeOfEverythingBeforeValue + valueSize);
        }
        if (this.mh.m().couldNotDetermineAlignmentBeforeAllocation) {
            return sizeOfEverythingBeforeValue + (long)this.mh.m().worstAlignment + valueSize;
        }
        return this.mh.m().alignment.alignAddr(sizeOfEverythingBeforeValue) + valueSize;
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)this.mh.m().keySizeMarshaller.sizeEncodingSize(keySize) + keySize + (long)this.mh.m().valueSizeMarshaller.sizeEncodingSize(valueSize);
    }

    public final void freeExtraAllocatedChunks() {
        if (!this.mh.m().constantlySizedEntry && this.mh.m().couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks < this.allocatedChunks.allocatedChunks) {
            this.s.free(this.pos + (long)this.entrySizeInChunks, this.allocatedChunks.allocatedChunks - this.entrySizeInChunks);
        } else {
            this.initEntrySizeInChunks(this.allocatedChunks.allocatedChunks);
        }
    }
}

