/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.hash.serialization.internal.SerializationBuilder;
import net.openhft.chronicle.map.AbstractChronicleMap;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapEntryOperations;
import net.openhft.chronicle.map.MapMethods;
import net.openhft.chronicle.map.MapQueryContext;
import net.openhft.chronicle.map.MapSegmentContext;
import net.openhft.chronicle.map.impl.CompiledMapIterationContext;
import net.openhft.chronicle.map.impl.CompiledMapQueryContext;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.NullReturnValue;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.ret.InstanceReturnValue;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaChronicleMap<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R>
extends VanillaChronicleHash<K, KI, MKI, MapEntry<K, V>, MapSegmentContext<K, V, ?>, ExternalMapQueryContext<K, V, ?>>
implements AbstractChronicleMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaChronicleMap.class);
    private static final long serialVersionUID = 3L;
    final Class<V> vClass;
    final Class nativeValueClass;
    public final SizeMarshaller valueSizeMarshaller;
    public final BytesReader<V> originalValueReader;
    public final VI originalValueInterop;
    public final MVI originalMetaValueInterop;
    public final MetaProvider<V, VI, MVI> metaValueInteropProvider;
    public final ConstantValueProvider<V> constantValueProvider;
    public final boolean constantlySizedEntry;
    public transient Provider<BytesReader<V>> valueReaderProvider;
    public transient Provider<VI> valueInteropProvider;
    public final Alignment alignment;
    public final int worstAlignment;
    public final boolean couldNotDetermineAlignmentBeforeAllocation;
    transient boolean putReturnsNull;
    transient boolean removeReturnsNull;
    transient Set<Map.Entry<K, V>> entrySet;
    public transient MapEntryOperations<K, V, R> entryOperations;
    public transient MapMethods<K, V, R> methods;
    public transient DefaultValueProvider<K, V> defaultValueProvider;
    transient ThreadLocal<ChainingInterface> cxt;

    public VanillaChronicleMap(ChronicleMapBuilder<K, V> builder) throws IOException {
        super(builder);
        SerializationBuilder valueBuilder = builder.valueBuilder;
        this.vClass = valueBuilder.eClass;
        if (this.vClass.getName().endsWith("$$Native")) {
            this.nativeValueClass = this.vClass;
        } else if (this.vClass.isInterface()) {
            Class nativeValueClass = null;
            try {
                nativeValueClass = DataValueClasses.directClassFor(this.vClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.nativeValueClass = nativeValueClass;
        } else {
            this.nativeValueClass = null;
        }
        this.valueSizeMarshaller = valueBuilder.sizeMarshaller();
        this.originalValueReader = valueBuilder.reader();
        this.originalValueInterop = valueBuilder.interop();
        this.originalMetaValueInterop = valueBuilder.metaInterop();
        this.metaValueInteropProvider = valueBuilder.metaInteropProvider();
        this.constantValueProvider = builder.constantValueProvider();
        this.constantlySizedEntry = builder.constantlySizedEntries();
        this.alignment = builder.valueAlignment();
        this.worstAlignment = builder.worstAlignment();
        int alignment = this.alignment.alignment();
        this.couldNotDetermineAlignmentBeforeAllocation = ChronicleMapBuilder.greatestCommonDivisor((int)this.chunkSize, alignment) != alignment;
        this.initTransientsFromBuilder(builder);
        this.initTransients();
    }

    void initTransientsFromBuilder(ChronicleMapBuilder<K, V> builder) {
        this.putReturnsNull = builder.putReturnsNull();
        this.removeReturnsNull = builder.removeReturnsNull();
        this.entryOperations = builder.entryOperations;
        this.methods = builder.methods;
        this.defaultValueProvider = builder.defaultValueProvider;
    }

    @Override
    public void initTransients() {
        super.initTransients();
        this.initOwnTransients();
    }

    private void initOwnTransients() {
        this.valueReaderProvider = Provider.of(this.originalValueReader.getClass());
        this.valueInteropProvider = Provider.of(this.originalValueInterop.getClass());
        if (this.constantValueProvider != null && this.constantValueProvider.wasDeserialized()) {
            ThreadLocalCopies copies = this.valueReaderProvider.getCopies(null);
            BytesReader valueReader = (BytesReader)this.valueReaderProvider.get(copies, this.originalValueReader);
            this.constantValueProvider.initTransients(valueReader);
        }
        this.cxt = new ThreadLocal();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initOwnTransients();
    }

    public final V checkValue(Object value) {
        if (!this.vClass.isInstance(value)) {
            throw new ClassCastException("Value must be a " + this.vClass.getName() + " but was a " + value.getClass());
        }
        return (V)value;
    }

    @Override
    public V newValueInstance() {
        if (this.vClass == CharSequence.class || this.vClass == StringBuilder.class) {
            return (V)new StringBuilder();
        }
        return VanillaChronicleMap.newInstance(this.vClass, false);
    }

    @Override
    public K newKeyInstance() {
        return (K)VanillaChronicleMap.newInstance(this.kClass, true);
    }

    @Override
    public Class<K> keyClass() {
        return this.kClass;
    }

    @Override
    public Class<V> valueClass() {
        return this.vClass;
    }

    static <T> T newInstance(Class<T> aClass, boolean isKey) {
        try {
            return (T)(isKey ? DataValueClasses.newInstance(aClass) : DataValueClasses.newDirectInstance(aClass));
        }
        catch (Exception e) {
            if (e.getCause() instanceof IllegalStateException) {
                throw e;
            }
            if (aClass.isInterface()) {
                throw new IllegalStateException("It not possible to create a instance from interface=" + aClass.getSimpleName() + " we recommend you create an " + "instance in the usual way.", e);
            }
            try {
                return aClass.newInstance();
            }
            catch (Exception e1) {
                throw new IllegalStateException("It has not been possible to create a instance of class=" + aClass.getSimpleName() + ", Note : its more efficient if your chronicle map is configured with " + "interface key " + "and value types rather than classes, as this method is able to use " + "interfaces to generate off heap proxies that point straight at your " + "data. " + "In this case you have used a class and chronicle is unable to create an " + "instance of this class has it does not have a default constructor. " + "If your class is mutable, we " + "recommend you create and instance of your class=" + aClass.getSimpleName() + " in the usual way, rather than using this method.", e);
            }
        }
    }

    @Override
    @NotNull
    public final Closeable acquireContext(K key, V usingValue) {
        ExternalHashQueryContext q = this.queryContext((Object)key);
        try {
            q.writeLock().lock();
            VanillaChronicleMap.checkAcquiredUsing(this.acquireUsingBody((QueryContextInterface<K, V, R>)q, usingValue), usingValue);
            return q.acquireHandle();
        }
        catch (Throwable e) {
            try {
                q.close();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }

    private static <V> void checkAcquiredUsing(V acquired, V using) {
        if (acquired != using) {
            throw new IllegalArgumentException("acquire*() MUST reuse the given value. Given value " + using + " cannot be reused to read " + acquired);
        }
    }

    @Override
    @NotNull
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = this.newEntrySet());
    }

    @Override
    public int hashCode() {
        return this.mapHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.mapEquals(obj);
    }

    public String toString() {
        return this.mapToString();
    }

    @Override
    public void clear() {
        this.forEachEntry((? super E c) -> c.context().remove(c));
    }

    public final long readValueSize(Bytes entry) {
        long valueSize = this.valueSizeMarshaller.readSize(entry);
        this.alignment.alignPositionAddr(entry);
        return valueSize;
    }

    private ChainingInterface q() {
        CompiledMapQueryContext queryContext = this.cxt.get();
        if (queryContext == null) {
            queryContext = new CompiledMapQueryContext(this);
            this.cxt.set(queryContext);
        }
        return queryContext;
    }

    public QueryContextInterface<K, V, R> mapContext() {
        return this.q().getContext(CompiledMapQueryContext.class, ci -> new CompiledMapQueryContext((ChainingInterface)ci, this));
    }

    private ChainingInterface i() {
        CompiledMapIterationContext iterContext = this.cxt.get();
        if (iterContext == null) {
            iterContext = new CompiledMapIterationContext(this);
            this.cxt.set(iterContext);
        }
        return iterContext;
    }

    public IterationContext<K, V, ?> iterationContext() {
        return this.i().getContext(CompiledMapIterationContext.class, ci -> new CompiledMapIterationContext((ChainingInterface)ci, this));
    }

    @Override
    @NotNull
    public QueryContextInterface<K, V, R> queryContext(Object key) {
        this.checkKey(key);
        QueryContextInterface<K, V, R> q = this.mapContext();
        q.inputKeyInstanceValue().initKey(key);
        q.initInputKey(q.inputKeyInstanceValue());
        return q;
    }

    @Override
    @NotNull
    public QueryContextInterface<K, V, R> queryContext(Data<K> key) {
        QueryContextInterface<K, V, R> q = this.mapContext();
        q.initInputKey(key);
        return q;
    }

    @Override
    public MapSegmentContext<K, V, ?> segmentContext(int segmentIndex) {
        IterationContext<K, V, ?> c = this.iterationContext();
        c.initSegmentIndex(segmentIndex);
        return c;
    }

    @Override
    public V get(Object key) {
        try (ExternalHashQueryContext q = this.queryContext(key);){
            this.methods.get(q, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V getUsing(K key, V usingValue) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            q.usingReturnValue().initUsingReturnValue(usingValue);
            this.methods.get(q, q.usingReturnValue());
            Object v = q.usingReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V acquireUsing(K key, V usingValue) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            V v = this.acquireUsingBody((QueryContextInterface<K, V, R>)q, usingValue);
            return v;
        }
    }

    private V acquireUsingBody(QueryContextInterface<K, V, R> q, V usingValue) {
        q.usingReturnValue().initUsingReturnValue(usingValue);
        this.methods.acquireUsing(q, q.usingReturnValue());
        return q.usingReturnValue().returnValue();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            q.inputValueInstanceValue().initValue(value);
            this.methods.putIfAbsent(q, q.inputValueInstanceValue(), q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        V v = this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext(key);){
            q.inputValueInstanceValue().initValue(v);
            boolean bl = this.methods.remove(q, q.inputValueInstanceValue());
            return bl;
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkValue(oldValue);
        this.checkValue(newValue);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            q.inputValueInstanceValue().initValue(oldValue);
            boolean bl = this.methods.replace(q, q.inputValueInstanceValue(), q.wrapValueAsData(newValue));
            return bl;
        }
    }

    @Override
    public V replace(K key, V value) {
        this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            q.inputValueInstanceValue().initValue(value);
            this.methods.replace(q, q.inputValueInstanceValue(), q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try (ExternalHashQueryContext q = this.queryContext(key);){
            boolean bl = this.methods.containsKey((MapQueryContext<K, V, R>)((Object)q));
            return bl;
        }
    }

    @Override
    public V put(K key, V value) {
        this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            q.inputValueInstanceValue().initValue(value);
            InstanceReturnValue returnValue = this.putReturnsNull ? NullReturnValue.get() : q.defaultReturnValue();
            this.methods.put(q, q.inputValueInstanceValue(), returnValue);
            Object v = returnValue.returnValue();
            return v;
        }
    }

    @Override
    public V remove(Object key) {
        try (ExternalHashQueryContext q = this.queryContext(key);){
            InstanceReturnValue returnValue = this.removeReturnsNull ? NullReturnValue.get() : q.defaultReturnValue();
            this.methods.remove(q, returnValue);
            Object v = returnValue.returnValue();
            return v;
        }
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            q.inputValueInstanceValue().initValue(value);
            this.methods.merge((MapQueryContext<K, ? extends V, R>)((Object)q), q.inputValueInstanceValue(), (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.compute((MapQueryContext<? super K, ? extends V, R>)((Object)q), (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.computeIfAbsent((MapQueryContext<? super K, ? extends V, R>)((Object)q), mappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.computeIfPresent((MapQueryContext<? super K, ? extends V, R>)((Object)q), (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }
}

