/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.UdpTransportConfig;
import net.openhft.chronicle.map.BufferResizer;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.UdpReplicator;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

final class Replicators {
    static final String ONLY_UDP_WARN_MESSAGE = "MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should usethe UdpReplicator if you have a large number of nodes, and you wishto receive the data before it becomes available on TCP/IP. Since datadelivery is not guaranteed, it is recommended that you only usethe UDP Replicator in conjunction with a TCP Replicator";

    private Replicators() {
    }

    static Replicator tcp(final AbstractReplication replication) {
        return new Replicator(){

            @Override
            protected Closeable applyTo(@NotNull ChronicleMapBuilder builder, @NotNull Replica replica, @NotNull Replica.EntryExternalizable entryExternalizable, ReplicatedChronicleMap replicatedMap) throws IOException {
                TcpTransportAndNetworkConfig tcpConfig = replication.tcpTransportAndNetwork();
                return new TcpReplicator(replica, entryExternalizable, tcpConfig, replication.remoteNodeValidator(), replication.name(), replication.connectionListener());
            }
        };
    }

    static Replicator udp(final UdpTransportConfig replicationConfig) {
        return new Replicator(){

            @Override
            protected Closeable applyTo(@NotNull ChronicleMapBuilder builder, @NotNull Replica map, @NotNull Replica.EntryExternalizable entryExternalizable, ReplicatedChronicleMap replicatedMap) throws IOException {
                return new UdpReplicator(map, entryExternalizable, replicationConfig);
            }
        };
    }

    static class OutBuffer
    implements BufferResizer {
        @NotNull
        private ByteBufferBytes in;
        @NotNull
        private ByteBuffer out;

        @NotNull
        public ByteBufferBytes in() {
            return this.in;
        }

        @NotNull
        public ByteBuffer out() {
            return this.out;
        }

        OutBuffer(int tcpBufferSize) {
            this.out = ByteBuffer.allocateDirect(tcpBufferSize);
            this.in = new ByteBufferBytes(this.out);
        }

        @Override
        public Bytes resizeBuffer(int newCapacity) {
            int i;
            if (newCapacity < this.out.capacity()) {
                throw new IllegalStateException("it not possible to resize the buffer smaller");
            }
            assert (newCapacity < Integer.MAX_VALUE);
            ByteBuffer result = ByteBuffer.allocate(newCapacity).order(ByteOrder.nativeOrder());
            long bytesPosition = this.in.position();
            this.in = new ByteBufferBytes(result.slice());
            this.out.position(0);
            this.out.limit((int)bytesPosition);
            int numberOfLongs = (int)bytesPosition / 8;
            for (i = 0; i < numberOfLongs; ++i) {
                this.in.writeLong(this.out.getLong());
            }
            i = numberOfLongs * 8;
            while ((long)i < bytesPosition) {
                this.in.writeByte((int)this.out.get());
                ++i;
            }
            this.out = result;
            assert ((long)this.out.capacity() == this.in.capacity());
            assert (this.out.capacity() == newCapacity);
            assert ((long)this.out.capacity() == this.in.capacity());
            assert (this.in.limit() == this.in.capacity());
            return this.in;
        }
    }
}

