/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Serializable;
import java.nio.ByteBuffer;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesWriter;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;

public final class ConstantValueProvider<V>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient V value;
    private final int size;
    private final byte[] serializedValueBytes;

    <W> ConstantValueProvider(V value, MetaBytesWriter<V, W> metaValueWriter, W valueWriter) {
        this.value = value;
        this.size = (int)metaValueWriter.size(valueWriter, value);
        this.serializedValueBytes = new byte[this.size];
        ByteBufferBytes bytes = new ByteBufferBytes(ByteBuffer.wrap(this.serializedValueBytes));
        metaValueWriter.write(valueWriter, (Bytes)bytes, value);
    }

    boolean wasDeserialized() {
        return this.value == null;
    }

    void initTransients(BytesReader<V> reader) {
        this.value = reader.read((Bytes)new ByteBufferBytes(ByteBuffer.wrap(this.serializedValueBytes)), this.size);
    }

    public V defaultValue() {
        return this.value;
    }
}

