/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.locks.AcquisitionStrategies;
import net.openhft.chronicle.algo.locks.AcquisitionStrategy;
import net.openhft.chronicle.algo.locks.LockingStrategy;
import net.openhft.chronicle.algo.locks.TryAcquireOperation;
import net.openhft.chronicle.algo.locks.TryAcquireOperations;
import net.openhft.chronicle.algo.locks.VanillaReadWriteUpdateWithWaitsLockingStrategy;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilderPrivateAPI;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.HashSplitting;
import net.openhft.chronicle.hash.impl.IntCompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.LongCompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.util.BuildVersion;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.hash.serialization.internal.SerializationBuilder;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.MappedStore;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.threadlocal.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VanillaChronicleHash<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, C extends HashEntry<K>, SC extends HashSegmentContext<K, ?>, ECQ extends ExternalHashQueryContext<K>>
implements ChronicleHash<K, C, SC, ECQ>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaChronicleHash.class);
    private static final long serialVersionUID = 0L;
    public static final long TIER_COUNTERS_AREA_SIZE = 64L;
    public static final long RESERVED_GLOBAL_MUTABLE_STATE_BYTES = 1024L;
    public final String dataFileVersion = BuildVersion.version();
    public transient boolean createdOrInMemory = true;
    public final Class<K> kClass;
    public final SizeMarshaller keySizeMarshaller;
    public final BytesReader<K> originalKeyReader;
    public final KI originalKeyInterop;
    public final MKI originalMetaKeyInterop;
    public final MetaProvider<K, KI, MKI> metaKeyInteropProvider;
    public transient Provider<BytesReader<K>> keyReaderProvider;
    public transient Provider<KI> keyInteropProvider;
    public final int actualSegments;
    public final HashSplitting hashSplitting;
    public final long entriesPerSegment;
    public final long chunkSize;
    public final int maxChunksPerEntry;
    public final long actualChunksPerSegment;
    final int segmentHeaderSize;
    public final int segmentHashLookupValueBits;
    public final int segmentHashLookupKeyBits;
    public final int segmentHashLookupEntrySize;
    public final long segmentHashLookupCapacity;
    final long segmentHashLookupInnerSize;
    public final long segmentHashLookupOuterSize;
    public final long segmentFreeListInnerSize;
    public final long segmentFreeListOuterSize;
    final long segmentEntrySpaceInnerSize;
    public final int segmentEntrySpaceInnerOffset;
    final long segmentEntrySpaceOuterSize;
    public final long segmentSize;
    final long maxExtraTiers;
    final long tierBulkSizeInBytes;
    final long tierBulkInnerOffsetToTiers;
    protected final long tiersInBulk;
    protected final int log2TiersInBulk;
    public final boolean checksumEntries;
    protected transient net.openhft.lang.io.BytesStore ms;
    protected transient Bytes bytes;
    public transient List<TierBulkData> tierBulkOffsets;
    public transient long headerSize;
    transient long segmentHeadersOffset;
    transient long segmentsOffset;
    public transient CompactOffHeapLinearHashTable hashLookup;
    protected transient boolean closed = false;
    private transient VanillaGlobalMutableState globalMutableState;
    static final LockingStrategy globalMutableStateLockingStrategy = VanillaReadWriteUpdateWithWaitsLockingStrategy.instance();
    static final TryAcquireOperation<LockingStrategy> globalMutableStateLockTryAcquireOperation = TryAcquireOperations.lock();
    static final AcquisitionStrategy<LockingStrategy, RuntimeException> globalMutableStateLockAcquisitionStrategy = AcquisitionStrategies.spinLoopOrFail((long)2L, (TimeUnit)TimeUnit.SECONDS);
    private static final long GLOBAL_MUTABLE_STATE_LOCK_OFFSET = 0L;
    private static final long GLOBAL_MUTABLE_STATE_VALUE_OFFSET = 8L;

    public VanillaChronicleHash(ChronicleMapBuilder<K, ?> builder) {
        ChronicleHashBuilderPrivateAPI<K> privateAPI = builder.privateAPI();
        SerializationBuilder<K> keyBuilder = privateAPI.keyBuilder();
        this.kClass = keyBuilder.eClass;
        this.keySizeMarshaller = keyBuilder.sizeMarshaller();
        this.originalKeyReader = keyBuilder.reader();
        this.originalKeyInterop = keyBuilder.interop();
        this.originalMetaKeyInterop = keyBuilder.metaInterop();
        this.metaKeyInteropProvider = keyBuilder.metaInteropProvider();
        this.actualSegments = privateAPI.actualSegments();
        this.hashSplitting = HashSplitting.Splitting.forSegments(this.actualSegments);
        this.entriesPerSegment = privateAPI.entriesPerSegment();
        this.chunkSize = privateAPI.chunkSize();
        this.maxChunksPerEntry = privateAPI.maxChunksPerEntry();
        this.actualChunksPerSegment = privateAPI.actualChunksPerSegment();
        this.segmentHeaderSize = privateAPI.segmentHeaderSize();
        this.segmentHashLookupValueBits = CompactOffHeapLinearHashTable.valueBits(this.actualChunksPerSegment);
        this.segmentHashLookupKeyBits = CompactOffHeapLinearHashTable.keyBits(this.entriesPerSegment, this.segmentHashLookupValueBits);
        this.segmentHashLookupEntrySize = CompactOffHeapLinearHashTable.entrySize(this.segmentHashLookupKeyBits, this.segmentHashLookupValueBits);
        if (!privateAPI.aligned64BitMemoryOperationsAtomic() && this.segmentHashLookupEntrySize > 4) {
            throw new IllegalStateException("aligned64BitMemoryOperationsAtomic() == false, but hash lookup slot is " + this.segmentHashLookupEntrySize);
        }
        this.segmentHashLookupCapacity = CompactOffHeapLinearHashTable.capacityFor(this.entriesPerSegment);
        this.segmentHashLookupInnerSize = this.segmentHashLookupCapacity * (long)this.segmentHashLookupEntrySize;
        this.segmentHashLookupOuterSize = MemoryUnit.CACHE_LINES.align(this.segmentHashLookupInnerSize, MemoryUnit.BYTES);
        this.segmentFreeListInnerSize = MemoryUnit.LONGS.align(MemoryUnit.BYTES.alignAndConvert(this.actualChunksPerSegment, MemoryUnit.BITS), MemoryUnit.BYTES);
        this.segmentFreeListOuterSize = MemoryUnit.CACHE_LINES.align(this.segmentFreeListInnerSize, MemoryUnit.BYTES);
        this.segmentEntrySpaceInnerSize = this.chunkSize * this.actualChunksPerSegment;
        this.segmentEntrySpaceInnerOffset = privateAPI.segmentEntrySpaceInnerOffset();
        this.segmentEntrySpaceOuterSize = MemoryUnit.CACHE_LINES.align((long)this.segmentEntrySpaceInnerOffset + this.segmentEntrySpaceInnerSize, MemoryUnit.BYTES);
        this.segmentSize = this.segmentSize();
        this.maxExtraTiers = privateAPI.maxExtraTiers();
        this.tiersInBulk = this.computeNumberOfTiersInBulk();
        this.log2TiersInBulk = Maths.intLog2((long)this.tiersInBulk);
        this.tierBulkInnerOffsetToTiers = this.computeTierBulkInnerOffsetToTiers(this.tiersInBulk);
        this.tierBulkSizeInBytes = this.computeTierBulkBytesSize(this.tiersInBulk);
        this.checksumEntries = privateAPI.checksumEntries();
    }

    protected VanillaGlobalMutableState createGlobalMutableState() {
        return (VanillaGlobalMutableState)DataValueClasses.newDirectReference(VanillaGlobalMutableState.class);
    }

    protected VanillaGlobalMutableState globalMutableState() {
        return this.globalMutableState;
    }

    private long segmentSize() {
        long ss = this.segmentHashLookupOuterSize + 64L + this.segmentFreeListOuterSize + this.segmentEntrySpaceOuterSize;
        if ((ss & 0x3FL) != 0L) {
            throw new AssertionError();
        }
        return this.breakL1CacheAssociativityContention(ss);
    }

    private long breakL1CacheAssociativityContention(long segmentSize) {
        int alignmentToBreak = 2048;
        int eachNthSegmentFallIntoTheSameSet = Math.max(1, alignmentToBreak >> Long.numberOfTrailingZeros(segmentSize));
        if (eachNthSegmentFallIntoTheSameSet < this.actualSegments) {
            segmentSize |= MemoryUnit.CACHE_LINES.toBytes(1L);
        }
        return segmentSize;
    }

    private long computeNumberOfTiersInBulk() {
        int tiersInBulk = this.actualSegments / 8;
        tiersInBulk = Maths.nextPower2((int)tiersInBulk, (int)1);
        while (this.segmentSize * (long)tiersInBulk < (long)OS.pageSize()) {
            tiersInBulk *= 2;
        }
        return tiersInBulk;
    }

    private long computeTierBulkBytesSize(long tiersInBulk) {
        return this.computeTierBulkInnerOffsetToTiers(tiersInBulk) + tiersInBulk * this.segmentSize;
    }

    protected long computeTierBulkInnerOffsetToTiers(long tiersInBulk) {
        return 0L;
    }

    public void initTransients() {
        this.initOwnTransients();
    }

    private void initOwnTransients() {
        this.globalMutableState = this.createGlobalMutableState();
        this.tierBulkOffsets = new ArrayList<TierBulkData>();
        this.keyReaderProvider = Provider.of(this.originalKeyReader.getClass());
        this.keyInteropProvider = Provider.of(this.originalKeyInterop.getClass());
        if (this.segmentHashLookupEntrySize == 4) {
            this.hashLookup = new IntCompactOffHeapLinearHashTable(this);
        } else if (this.segmentHashLookupEntrySize == 8) {
            this.hashLookup = new LongCompactOffHeapLinearHashTable(this);
        } else {
            throw new AssertionError((Object)("hash lookup slot size could be 4 or 8, " + this.segmentHashLookupEntrySize + " observed"));
        }
    }

    public final void initBeforeMapping(FileChannel ch) throws IOException {
        this.headerSize = VanillaChronicleHash.roundUpMapHeaderSize(ch.position());
        if (!this.createdOrInMemory) {
            ch.position(this.headerSize + 8L);
            ByteBuffer globalMutableStateBuffer = ByteBuffer.allocate(this.globalMutableState.maxSize());
            ch.read(globalMutableStateBuffer);
            globalMutableStateBuffer.flip();
            this.globalMutableState.bytes((Bytes)new ByteBufferBytes(globalMutableStateBuffer), 0L);
        }
    }

    private static long roundUpMapHeaderSize(long headerSize) {
        long roundUp = headerSize + 127L & 0xFFFFFFFFFFFFFF80L;
        if (roundUp - headerSize < 64L) {
            roundUp += 128L;
        }
        return roundUp;
    }

    public final void createMappedStoreAndSegments(net.openhft.lang.io.BytesStore bytesStore) throws IOException {
        this.ms = bytesStore;
        this.bytes = this.ms.bytes();
        this.globalMutableState.bytes(this.bytes, this.headerSize + 8L);
        this.onHeaderCreated();
        this.segmentHeadersOffset = this.segmentHeadersOffset();
        long segmentHeadersSize = this.actualSegments * this.segmentHeaderSize;
        this.segmentsOffset = this.segmentHeadersOffset + segmentHeadersSize;
        if (this.createdOrInMemory) {
            this.zeroOutNewlyMappedChronicleMapBytes();
            this.globalMutableState.setSegmentHeadersOffset(this.segmentHeadersOffset);
        } else if (this.globalMutableState.getAllocatedExtraTierBulks() > 0) {
            this.appendBulkData(0, this.globalMutableState.getAllocatedExtraTierBulks() - 1, this.ms, this.sizeInBytesWithoutTiers());
        }
    }

    public final void createMappedStoreAndSegments(File file) throws IOException {
        long mapSize = this.createdOrInMemory ? this.sizeInBytesWithoutTiers() : this.expectedFileSize();
        this.createMappedStoreAndSegments((net.openhft.lang.io.BytesStore)new MappedStore(file, FileChannel.MapMode.READ_WRITE, mapSize, BytesMarshallableSerializer.create()));
    }

    private boolean persisted() {
        return this.ms instanceof MappedStore;
    }

    protected void zeroOutNewlyMappedChronicleMapBytes() {
        this.zeroOutGlobalMutableState();
        this.zeroOutSegmentHeaders();
        this.zeroOutFirstSegmentTiers();
    }

    private void zeroOutGlobalMutableState() {
        long end = this.headerSize + this.globalMutableStateTotalUsedSize();
        this.bytes.zeroOut(this.headerSize, end);
    }

    protected long globalMutableStateTotalUsedSize() {
        return 8L + (long)this.globalMutableState().maxSize();
    }

    private void zeroOutSegmentHeaders() {
        this.bytes.zeroOut(this.segmentHeadersOffset, this.segmentsOffset);
    }

    private void zeroOutFirstSegmentTiers() {
        for (int segmentIndex = 0; segmentIndex < this.segments(); ++segmentIndex) {
            long segmentOffset = this.msBytesSegmentOffset(segmentIndex);
            this.zeroOutNewlyMappedTier(this.bytes, segmentOffset);
        }
    }

    private void zeroOutNewlyMappedTier(Bytes bytes, long segmentOffset) {
        long zeroOutEnd = segmentOffset + this.segmentSize - this.segmentEntrySpaceOuterSize;
        bytes.zeroOut(segmentOffset, zeroOutEnd);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initOwnTransients();
    }

    public void onHeaderCreated() {
    }

    public String persistedDataVersion() {
        return this.dataFileVersion;
    }

    public String applicationVersion() {
        return BuildVersion.version();
    }

    private long segmentHeadersOffset() {
        if (this.createdOrInMemory) {
            long reserved = 1024L - this.globalMutableStateTotalUsedSize();
            return OS.pageAlign((long)(this.mapHeaderInnerSize() + reserved));
        }
        return this.globalMutableState.getSegmentHeadersOffset();
    }

    public long mapHeaderInnerSize() {
        return this.headerSize + this.globalMutableStateTotalUsedSize();
    }

    @Override
    public File file() {
        return this.ms.file();
    }

    public final long sizeInBytesWithoutTiers() {
        return this.segmentHeadersOffset() + (long)this.actualSegments * ((long)this.segmentHeaderSize + this.segmentSize);
    }

    public final long expectedFileSize() {
        long sizeInBytesWithoutTiers = this.sizeInBytesWithoutTiers();
        int allocatedExtraTierBulks = this.globalMutableState.getAllocatedExtraTierBulks();
        return sizeInBytesWithoutTiers + (long)allocatedExtraTierBulks * this.tierBulkSizeInBytes;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.ms == null) {
            return;
        }
        this.bytes.release();
        this.bytes = null;
        this.ms.free();
        this.ms = null;
        this.closed = true;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    public final void checkKey(Object key) {
        if (!this.kClass.isInstance(key)) {
            throw new ClassCastException("Key must be a " + this.kClass.getName() + " but was a " + key.getClass());
        }
    }

    public final long[] segmentSizes() {
        long[] sizes = new long[this.actualSegments];
        for (int i = 0; i < this.actualSegments; ++i) {
            sizes[i] = BigSegmentHeader.INSTANCE.size(this.segmentHeaderAddress(i));
        }
        return sizes;
    }

    public final long segmentHeaderAddress(int segmentIndex) {
        return this.ms.address() + this.segmentHeadersOffset + (long)segmentIndex * (long)this.segmentHeaderSize;
    }

    public final long segmentBaseAddr(int segmentIndex) {
        return this.ms.address() + this.msBytesSegmentOffset(segmentIndex);
    }

    private long msBytesSegmentOffset(long segmentIndex) {
        return this.segmentsOffset + segmentIndex * this.segmentSize;
    }

    public final int inChunks(long sizeInBytes) {
        if (sizeInBytes <= this.chunkSize) {
            return 1;
        }
        if (--sizeInBytes <= Integer.MAX_VALUE) {
            return (int)sizeInBytes / (int)this.chunkSize + 1;
        }
        return (int)(sizeInBytes / this.chunkSize) + 1;
    }

    @Override
    public final long longSize() {
        long result = 0L;
        for (int i = 0; i < this.actualSegments; ++i) {
            long segmentHeaderAddress = this.segmentHeaderAddress(i);
            result += BigSegmentHeader.INSTANCE.size(segmentHeaderAddress) - BigSegmentHeader.INSTANCE.deleted(segmentHeaderAddress);
        }
        return result;
    }

    public final int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    @Override
    public int segments() {
        return this.actualSegments;
    }

    private long globalMutableStateAddress() {
        return this.bytes.address() + this.headerSize;
    }

    public void globalMutableStateLock() {
        globalMutableStateLockAcquisitionStrategy.acquire(globalMutableStateLockTryAcquireOperation, globalMutableStateLockingStrategy, Access.nativeAccess(), null, this.globalMutableStateAddress() + 0L);
    }

    public void globalMutableStateUnlock() {
        globalMutableStateLockingStrategy.unlock(Access.nativeAccess(), null, this.globalMutableStateAddress() + 0L);
    }

    public long allocateTier(int forSegmentIndex, int tier) {
        LOG.debug("Allocate tier for segment # {}, tier {}", (Object)forSegmentIndex, (Object)tier);
        this.globalMutableStateLock();
        try {
            long tiersInUse = this.globalMutableState.getExtraTiersInUse();
            if (tiersInUse == this.maxExtraTiers) {
                throw new IllegalStateException("Attempt to allocate " + (this.maxExtraTiers + 1L) + "th extra segment tier, " + this.maxExtraTiers + " is maximum.\n" + "Possible reasons include:\n" + " - you have forgotten to configure (or configured wrong) " + "builder.entries() number\n" + " - same regarding other sizing Chronicle Hash configurations, most " + "likely maxBloatFactor(), averageKeySize(), or averageValueSize()\n" + " - keys, inserted into the ChronicleHash, are distributed suspiciously " + "bad. This might be a DOS attack");
            }
            while (true) {
                long firstFreeTierIndex;
                if ((firstFreeTierIndex = this.globalMutableState.getFirstFreeTierIndex()) > 0L) {
                    this.globalMutableState.setExtraTiersInUse(tiersInUse + 1L);
                    Bytes allocatedTierBytes = this.tierBytes(firstFreeTierIndex);
                    long allocatedTierOffset = this.tierBytesOffset(firstFreeTierIndex);
                    long tierBaseAddr = allocatedTierBytes.address() + allocatedTierOffset;
                    long tierCountersAreaAddr = tierBaseAddr + this.segmentHashLookupOuterSize;
                    long nextFreeTierIndex = TierCountersArea.nextTierIndex(tierCountersAreaAddr);
                    TierCountersArea.nextTierIndex(tierCountersAreaAddr, 0L);
                    TierCountersArea.segmentIndex(tierCountersAreaAddr, forSegmentIndex);
                    TierCountersArea.tier(tierCountersAreaAddr, tier);
                    this.globalMutableState.setFirstFreeTierIndex(nextFreeTierIndex);
                    long l = firstFreeTierIndex;
                    return l;
                }
                this.allocateTierBulk();
            }
        }
        finally {
            this.globalMutableStateUnlock();
        }
    }

    private void allocateTierBulk() {
        int allocatedExtraTierBulks = this.globalMutableState.getAllocatedExtraTierBulks();
        this.mapTierBulks(allocatedExtraTierBulks);
        long firstTierIndex = (long)this.actualSegments + 1L + (long)allocatedExtraTierBulks * this.tiersInBulk;
        Bytes bytes = this.tierBytes(firstTierIndex);
        long firstTierOffset = this.tierBytesOffset(firstTierIndex);
        if (this.tierBulkInnerOffsetToTiers > 0L) {
            bytes.zeroOut(firstTierOffset - this.tierBulkInnerOffsetToTiers, firstTierOffset);
        }
        long lastTierIndex = firstTierIndex + this.tiersInBulk - 1L;
        for (long tierIndex = firstTierIndex; tierIndex <= lastTierIndex; ++tierIndex) {
            long tierOffset = this.tierBytesOffset(tierIndex);
            this.zeroOutNewlyMappedTier(bytes, tierOffset);
            if (tierIndex >= lastTierIndex) continue;
            long tierCountersAreaOffset = tierOffset + this.segmentHashLookupOuterSize;
            TierCountersArea.nextTierIndex(bytes.address() + tierCountersAreaOffset, tierIndex + 1L);
        }
        this.globalMutableState.setAllocatedExtraTierBulks(allocatedExtraTierBulks + 1);
        this.globalMutableState.setFirstFreeTierIndex(firstTierIndex);
    }

    public long tierIndexToBaseAddr(long tierIndex) {
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.segmentBaseAddr((int)tierIndexMinusOne);
        }
        return this.extraTierIndexToBaseAddr(tierIndexMinusOne);
    }

    public Bytes tierBytes(long tierIndex) {
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.bytes;
        }
        return this.tierBulkData((long)tierIndexMinusOne).langBytes;
    }

    public long tierBytesOffset(long tierIndex) {
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.msBytesSegmentOffset(tierIndexMinusOne);
        }
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        return this.tierBulkOffsets.get((int)bulkIndex).offset + this.tierBulkInnerOffsetToTiers + (extraTierIndex & this.tiersInBulk - 1L) * this.segmentSize;
    }

    private TierBulkData tierBulkData(long tierIndexMinusOne) {
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        return this.tierBulkOffsets.get(bulkIndex);
    }

    private long extraTierIndexToBaseAddr(long tierIndexMinusOne) {
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        TierBulkData tierBulkData = this.tierBulkOffsets.get(bulkIndex);
        long tierIndexOffsetWithinBulk = extraTierIndex & this.tiersInBulk - 1L;
        return this.tierAddr(tierBulkData, tierIndexOffsetWithinBulk);
    }

    protected long tierAddr(TierBulkData tierBulkData, long tierIndexOffsetWithinBulk) {
        return tierBulkData.langBytes.address() + tierBulkData.offset + this.tierBulkInnerOffsetToTiers + tierIndexOffsetWithinBulk * this.segmentSize;
    }

    private void mapTierBulks(int upToBulkIndex) {
        if (this.persisted()) {
            try {
                this.mapTierBulksMapped(upToBulkIndex);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.allocateTierBulks(upToBulkIndex);
        }
    }

    private void mapTierBulksMapped(int upToBulkIndex) throws IOException {
        long firstBulkToMapOffsetWithinMapping;
        long mappingOffsetInFile;
        int firstBulkToMapIndex = this.tierBulkOffsets.size();
        int bulksToMap = upToBulkIndex + 1 - firstBulkToMapIndex;
        long mapSize = (long)bulksToMap * this.tierBulkSizeInBytes;
        long firstBulkToMapOffset = this.bulkOffset(firstBulkToMapIndex);
        if (OS.mapAlign((long)firstBulkToMapOffset) == firstBulkToMapOffset) {
            mappingOffsetInFile = firstBulkToMapOffset;
            firstBulkToMapOffsetWithinMapping = 0L;
        } else {
            mappingOffsetInFile = OS.mapAlign((long)firstBulkToMapOffset) - OS.mapAlignment();
            firstBulkToMapOffsetWithinMapping = firstBulkToMapOffset - mappingOffsetInFile;
            mapSize += firstBulkToMapOffsetWithinMapping;
        }
        MappedStore extraStore = new MappedStore(this.file(), FileChannel.MapMode.READ_WRITE, mappingOffsetInFile, mapSize, this.ms.objectSerializer());
        this.appendBulkData(firstBulkToMapIndex, upToBulkIndex, (net.openhft.lang.io.BytesStore)extraStore, firstBulkToMapOffsetWithinMapping);
    }

    private long bulkOffset(int bulkIndex) {
        return this.sizeInBytesWithoutTiers() + (long)bulkIndex * this.tierBulkSizeInBytes;
    }

    private void allocateTierBulks(int upToBulkIndex) {
        int firstBulkToMapIndex = this.tierBulkOffsets.size();
        int bulksToMap = upToBulkIndex + 1 - firstBulkToMapIndex;
        long mapSize = (long)bulksToMap * this.tierBulkSizeInBytes;
        DirectStore extraStore = new DirectStore(this.ms.objectSerializer(), mapSize, false);
        this.appendBulkData(firstBulkToMapIndex, upToBulkIndex, (net.openhft.lang.io.BytesStore)extraStore, 0L);
    }

    private void appendBulkData(int firstBulkToMapIndex, int upToBulkIndex, net.openhft.lang.io.BytesStore extraStore, long offsetWithinMapping) {
        TierBulkData firstMappedBulkData = new TierBulkData(extraStore, offsetWithinMapping);
        this.tierBulkOffsets.add(firstMappedBulkData);
        for (int bulkIndex = firstBulkToMapIndex + 1; bulkIndex <= upToBulkIndex; ++bulkIndex) {
            this.tierBulkOffsets.add(new TierBulkData(firstMappedBulkData, offsetWithinMapping += this.tierBulkSizeInBytes));
        }
    }

    public static class TierBulkData {
        public final net.openhft.lang.io.BytesStore langBytesStore;
        public final Bytes langBytes;
        public final BytesStore chBytesBytesStore;
        public final long offset;

        public TierBulkData(net.openhft.lang.io.BytesStore langBytesStore, long offset) {
            this.langBytesStore = langBytesStore;
            this.langBytes = langBytesStore.bytes();
            this.chBytesBytesStore = new NativeBytesStore(this.langBytes.address(), this.langBytes.capacity(), null, false);
            this.offset = offset;
        }

        public TierBulkData(TierBulkData data, long offset) {
            this.langBytesStore = data.langBytesStore;
            this.langBytes = data.langBytes;
            this.chBytesBytesStore = data.chBytesBytesStore;
            this.offset = offset;
        }
    }
}

