/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.CopyingInstanceData;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.PublicMultiStoreBytes;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.Alloc;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.Crc32;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.IterationContextInterface;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledMapIterationContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R>
implements AutoCloseable,
ChecksumEntry,
HashEntry<K>,
HashSegmentContext<K, MapEntry<K, V>>,
SegmentLock,
Alloc,
KeyHashCode,
LocksInterface,
ChainingInterface,
MapContext<K, V, R>,
MapEntry<K, V>,
IterationContextInterface<K, V, R>,
VanillaChronicleMapHolder<K, KI, MKI, V, VI, MVI, R> {
    final Thread owner;
    public final int indexInContextChain;
    public final ReadLock innerReadLock;
    public static final Logger LOG = LoggerFactory.getLogger(CompiledMapIterationContext.class);
    public final WriteLock innerWriteLock;
    public final UpdateLock innerUpdateLock;
    public final ThreadLocalCopies copies;
    final EntryKeyBytesData entryKey;
    public final List<ChainingInterface> contextChain;
    public final EntryValueBytesData entryValue;
    final WrappedValueInstanceData wrappedValueInstanceValue;
    public final ReusableBitSet freeList;
    final HashKeyCrc32PayloadChecksumStrategy hashKeyCrc32PayloadChecksumStrategy;
    public final PointerBytesStore segmentBS;
    public final PublicMultiStoreBytes segmentBytes;
    private final VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m;
    public final VI valueInterop;
    public final ChecksumStrategy checksumStrategy;
    public final BytesReader<V> valueReader;
    public final KI keyInterop;
    public final BytesReader<K> keyReader;
    long searchKey = 0L;
    public long searchStartPos;
    public int allocatedChunks = 0;
    public long keyOffset = -1L;
    public long keySize = -1L;
    public long valueSizeOffset = -1L;
    public long hashLookupEntry = 0L;
    public int segmentIndex = -1;
    long segmentHeaderAddress;
    SegmentHeader segmentHeader = null;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    public boolean concurrentSameThreadContexts;
    LocksInterface nextNode;
    LocalLockState localLockState;
    public LocksInterface rootContextOnThisSegment = null;
    public int segmentTier = -1;
    public long tierIndex;
    public long segmentBaseAddr;
    long keyHash = 0L;
    public long hashLookupPos = -1L;
    long entrySpaceOffset = 0L;
    public long valueSize = -1L;
    public long valueOffset;
    boolean used;
    public boolean entryRemovedOnThisIteration = false;
    public Data<K> inputKey = null;
    public long pos = -1L;
    public long keySizeOffset = -1L;
    public int entrySizeInChunks = 0;
    protected SearchState searchState = null;

    public boolean readZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.readZero();
    }

    public boolean updateZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.updateZero();
    }

    public boolean writeZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.writeZero();
    }

    public int decrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementUpdate();
    }

    public int decrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementWrite();
    }

    public String debugContextsAndLocksGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.debugContextsAndLocks();
    }

    @Override
    public void close() {
        this.closePos();
        this.wrappedValueInstanceValue.closeNext();
        this.closeInputKey();
        this.closeEntryRemovedOnThisIteration();
        this.closeUsed();
        this.closeSegmentIndex();
        this.closeHashLookupEntry();
        this.wrappedValueInstanceValue.closeValue();
        this.closeKeySize();
        this.closeKeyOffset();
        this.closeAllocatedChunks();
        this.closeHashLookupSearchHlDependants();
        this.closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants();
        this.closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeValueBytesInteropValueMetaInteropDependants();
        this.closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants();
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void incrementReadGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementRead();
    }

    public void incrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementUpdate();
    }

    public void incrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementWrite();
    }

    public void readUnlockAndDecrementCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.readUnlockAndDecrementCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    void keyFound() {
        this.searchState = SearchState.PRESENT;
    }

    public CompiledMapIterationContext(ChainingInterface c, VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        this.contextChain = c.getContextChain();
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.m = m;
        this.entryValue = new EntryValueBytesData();
        this.hashKeyCrc32PayloadChecksumStrategy = new HashKeyCrc32PayloadChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashKeyCrc32PayloadChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerReadLock = new ReadLock();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
        this.owner = Thread.currentThread();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = (BytesReader)this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.innerWriteLock = new WriteLock();
        this.segmentBytes = new PublicMultiStoreBytes();
        this.segmentBS = new PointerBytesStore();
        this.entryKey = new EntryKeyBytesData();
        this.innerUpdateLock = new UpdateLock();
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegment, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
    }

    public CompiledMapIterationContext(VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        this.contextChain = new ArrayList<ChainingInterface>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.m = m;
        this.entryValue = new EntryValueBytesData();
        this.hashKeyCrc32PayloadChecksumStrategy = new HashKeyCrc32PayloadChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashKeyCrc32PayloadChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerReadLock = new ReadLock();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
        this.owner = Thread.currentThread();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = (BytesReader)this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.innerWriteLock = new WriteLock();
        this.segmentBytes = new PublicMultiStoreBytes();
        this.segmentBS = new PointerBytesStore();
        this.entryKey = new EntryKeyBytesData();
        this.innerUpdateLock = new UpdateLock();
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegment, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
    }

    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = (LocksInterface)this.contextAtIndexInChain(index);
        if (c.segmentHeaderInit() && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.locksInit()) {
            LocksInterface root;
            this.rootContextOnThisSegment = root = c.rootContextOnThisSegment();
            root.setConcurrentSameThreadContexts(true);
            this.concurrentSameThreadContexts = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            this.linkToSegmentContextsChain();
            return true;
        }
        return false;
    }

    @Override
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Override
    public int changeAndGetTotalReadLockCount(int change) {
        return this.totalReadLockCount += change;
    }

    @Override
    public int changeAndGetTotalUpdateLockCount(int change) {
        return this.totalUpdateLockCount += change;
    }

    @Override
    public int changeAndGetTotalWriteLockCount(int change) {
        return this.totalWriteLockCount += change;
    }

    public int decrementRead() {
        return this.rootContextOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    public int decrementUpdate() {
        return this.rootContextOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    public int decrementWrite() {
        return this.rootContextOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
        if (!this.h().isOpen()) {
            throw new IllegalStateException("Access to Chronicle Hash after close()");
        }
    }

    private void _SegmentStages_checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        Data<K> key;
        if (innermostContextOnThisSegment.getClass() == this.getClass() && Objects.equals(key = ((CompiledMapIterationContext)innermostContextOnThisSegment).inputKey(), this.inputKey())) {
            throw new IllegalStateException("Nested same-thread contexts cannot access the same key " + key);
        }
    }

    private void _SegmentStages_nextTier() {
        VanillaChronicleHash h = this.h();
        long nextTierIndex = this.nextTierIndex();
        if (nextTierIndex == 0L) {
            nextTierIndex = h.allocateTier(this.segmentIndex(), this.segmentTier() + 1);
            this.nextTierIndex(nextTierIndex);
            long currentTierIndex = this.tierIndex();
            this.initSegmentTier(this.segmentTier() + 1, nextTierIndex);
            this.prevTierIndex(currentTierIndex);
        } else {
            this.initSegmentTier(this.segmentTier() + 1, nextTierIndex);
        }
    }

    public void incrementModCount() {
        this.contextModCount = this.rootContextOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    public void incrementRead() {
        this.rootContextOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    public void incrementUpdate() {
        this.rootContextOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    public void incrementWrite() {
        this.rootContextOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    public void readUnlockAndDecrementCount() {
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                int newTotalReadLockCount = this.decrementRead();
                if (newTotalReadLockCount == 0) {
                    if (this.updateZero() && this.writeZero()) {
                        this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                    }
                } else assert (newTotalReadLockCount > 0) : "read underflow";
                return;
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = this.decrementUpdate();
                if (newTotalUpdateLockCount == 0) {
                    if (this.writeZero()) {
                        if (this.readZero()) {
                            this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                        } else {
                            this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                        }
                    }
                } else assert (newTotalUpdateLockCount > 0) : "update underflow";
                return;
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = this.decrementWrite();
                if (newTotalWriteLockCount == 0) {
                    if (!this.updateZero()) {
                        this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                        break;
                    }
                    if (!this.readZero()) {
                        this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                        break;
                    }
                    this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
                    break;
                }
                assert (newTotalWriteLockCount > 0) : "write underflow";
                break;
            }
        }
    }

    @Override
    public void setConcurrentSameThreadContexts(boolean concurrentSameThreadContexts) {
        this.concurrentSameThreadContexts = concurrentSameThreadContexts;
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        this.localLockState = newState;
    }

    @Override
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    public Thread owner() {
        return this.owner;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        this.readUnlockAndDecrementCount();
    }

    private void closeRootLocks() {
        this.verifyInnermostContext();
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void countValueOffset() {
        this.m().alignment.alignPositionAddr((Bytes)this.segmentBytes());
        this.valueOffset = this.segmentBytes().position();
    }

    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = this.rootContextOnThisSegment;
        while (true) {
            this.checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if (innermostContextOnThisSegment.nextNode() == null) break;
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    private void unlinkFromSegmentContextsChain() {
        LocksInterface prevContext = this.rootContextOnThisSegment;
        while (true) {
            assert (prevContext.nextNode() != null);
            if (prevContext.nextNode() == this) break;
            prevContext = prevContext.nextNode();
        }
        this.verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    private void verifyInnermostContext() {
        if (this.nextNode != null) {
            throw new IllegalStateException("Attempt to close contexts not structurally");
        }
    }

    public String debugContextsAndLocks() {
        String message = "";
        message = message + "Contexts locked on this segment:\n";
        for (LocksInterface cxt = this.rootContextOnThisSegment; cxt != null; cxt = cxt.nextNode()) {
            message = message + cxt.debugLocksState() + "\n";
        }
        message = message + "Current thread contexts:\n";
        int size = this.contextChain.size();
        for (int i = 0; i < size; ++i) {
            LocksInterface cxt = (LocksInterface)this.contextAtIndexInChain(i);
            message = message + cxt.debugLocksState() + "\n";
        }
        return message;
    }

    public boolean readZero() {
        return this.rootContextOnThisSegment.totalReadLockCount() == 0;
    }

    public boolean updateZero() {
        return this.rootContextOnThisSegment.totalUpdateLockCount() == 0;
    }

    public boolean writeZero() {
        return this.rootContextOnThisSegment.totalWriteLockCount() == 0;
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public Logger LOG() {
        return LOG;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public ThreadLocalCopies copies() {
        return this.copies;
    }

    public List<ChainingInterface> contextChain() {
        return this.contextChain;
    }

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    public WrappedValueInstanceData wrappedValueInstanceValue() {
        return this.wrappedValueInstanceValue;
    }

    public HashKeyCrc32PayloadChecksumStrategy hashKeyCrc32PayloadChecksumStrategy() {
        return this.hashKeyCrc32PayloadChecksumStrategy;
    }

    public VI valueInterop() {
        return this.valueInterop;
    }

    public ChecksumStrategy checksumStrategy() {
        return this.checksumStrategy;
    }

    public BytesReader<V> valueReader() {
        return this.valueReader;
    }

    public KI keyInterop() {
        return this.keyInterop;
    }

    public BytesReader<K> keyReader() {
        return this.keyReader;
    }

    @Override
    public boolean checkSum() {
        return this.checksumStrategy.checkSum();
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeLocks();
    }

    public MVI valueMetaInterop(V value) {
        return (MVI)((MetaBytesInterop)this.m().metaValueInteropProvider.get(this.copies, this.m().originalMetaValueInterop, this.valueInterop, value, false));
    }

    public void closeValueBytesInteropValueMetaInteropDependants() {
        this.wrappedValueInstanceValue.closeBuffer();
    }

    @Override
    public <T extends ChainingInterface> T getContext(Class<? extends T> contextClass, Function<ChainingInterface, T> createChaining) {
        ChainingInterface context2;
        for (ChainingInterface context2 : this.contextChain) {
            if (context2.getClass() != contextClass || context2.usedInit()) continue;
            context2.initUsed(true);
            return (T)context2;
        }
        int maxNestedContexts = 1024;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context2 = (ChainingInterface)createChaining.apply(this);
        context2.initUsed(true);
        return (T)context2;
    }

    @Override
    @NotNull
    public MapContext<K, V, ?> context() {
        return this;
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
    }

    public void closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants() {
        this.closeLocks();
    }

    public void checkEntryNotRemovedOnThisIteration() {
        if (this.entryRemovedOnThisIterationInit()) {
            throw new IllegalStateException("Entry was already removed on this iteration");
        }
    }

    public void closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.checkEntryNotRemovedOnThisIteration();
    }

    public void closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public Data<V> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return this.m().defaultValueProvider.defaultValue(absentEntry);
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.replaceValue(entry, newValue);
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.remove(entry);
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    public Data<V> wrapValueAsData(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceData wrapped = this.wrappedValueInstanceValue;
        wrapped = wrapped.getUnusedWrappedValueGuarded();
        wrapped.initValue(value);
        return wrapped;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.insert(absentEntry, value);
    }

    @Override
    public VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m() {
        return this.m;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    public MKI keyMetaInterop(K key) {
        return (MKI)((MetaBytesInterop)this.h().metaKeyInteropProvider.get(this.copies, this.h().originalMetaKeyInterop, this.keyInterop, key, false));
    }

    public void incrementSegmentEntriesIfNeeded() {
    }

    public CompactOffHeapLinearHashTable hl() {
        return this.h().hashLookup;
    }

    public void closeHashLookupSearchHlDependants() {
        this.closeSearchKey();
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public boolean searchKeyInit() {
        return this.searchKey != 0L;
    }

    public void initSearchKey(long searchKey) {
        this.searchKey = searchKey;
        this.searchStartPos = this.hl().hlPos(searchKey);
        this.closeSearchKeyDependants();
    }

    public long searchKey() {
        assert (this.searchKeyInit()) : "SearchKey should be init";
        return this.searchKey;
    }

    public long searchStartPos() {
        assert (this.searchKeyInit()) : "SearchKey should be init";
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!this.searchKeyInit()) {
            return;
        }
        this.closeSearchKeyDependants();
        this.searchKey = 0L;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeHashLookupSearchNextPosDependants();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)(this.m().metaDataBytes + this.m().keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)this.m().valueSizeMarshaller.sizeEncodingSize(valueSize);
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (this.m().constantlySizedEntry) {
            return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue + valueSize);
        }
        if (this.m().couldNotDetermineAlignmentBeforeAllocation) {
            return sizeOfEverythingBeforeValue + (long)this.m().worstAlignment + valueSize;
        }
        return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue) + valueSize;
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    public boolean entryIsPresent() {
        return true;
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        throw new AssertionError((Object)"putValueDeletedEntry() might be called only from non-Replicated Map query context");
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return this.contextChain;
    }

    @Override
    public void updateChecksum() {
        this.checksumStrategy.updateChecksum();
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!this.allocatedChunksInit()) {
            return;
        }
        this.allocatedChunks = 0;
    }

    public boolean keyOffsetInit() {
        return this.keyOffset != -1L;
    }

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
        this.closeKeyOffsetDependants();
    }

    public long keyOffset() {
        assert (this.keyOffsetInit()) : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!this.keyOffsetInit()) {
            return;
        }
        this.closeKeyOffsetDependants();
        this.keyOffset = -1L;
    }

    public void closeKeyOffsetDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
    }

    public boolean keySizeInit() {
        return this.keySize != -1L;
    }

    public void initKeySize(long keySize) {
        this.keySize = keySize;
        this.closeKeySizeDependants();
    }

    public long keySize() {
        assert (this.keySizeInit()) : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!this.keySizeInit()) {
            return;
        }
        this.closeKeySizeDependants();
        this.keySize = -1L;
    }

    public void closeKeySizeDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeMapEntryStagesKeyEndDependants() {
        this.closeMapEntryStagesCountValueSizeOffsetDependants();
        this.closeMapEntryStagesEntryEndDependants();
    }

    long countValueSizeOffset() {
        return this.keyEnd();
    }

    public void closeMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public boolean valueSizeOffsetInit() {
        return this.valueSizeOffset != -1L;
    }

    void initValueSizeOffset() {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.closeValueSizeOffsetDependants();
    }

    public long valueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            this.initValueSizeOffset();
        }
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            return;
        }
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1L;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValueSize();
    }

    public boolean hashLookupEntryInit() {
        return this.hashLookupEntry != 0L;
    }

    public void initHashLookupEntry(long entry) {
        this.hashLookupEntry = entry;
    }

    public long hashLookupEntry() {
        assert (this.hashLookupEntryInit()) : "HashLookupEntry should be init";
        return this.hashLookupEntry;
    }

    void closeHashLookupEntry() {
        if (!this.hashLookupEntryInit()) {
            return;
        }
        this.hashLookupEntry = 0L;
    }

    public boolean segmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    @Override
    public void initSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeSegmentIndexDependants();
    }

    @Override
    public int segmentIndex() {
        assert (this.segmentIndexInit()) : "SegmentIndex should be init";
        return this.segmentIndex;
    }

    public void closeSegmentIndex() {
        if (!this.segmentIndexInit()) {
            return;
        }
        this.closeSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentHeader();
        this.closeSegmentTier();
    }

    @Override
    public boolean segmentHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegmentHeader() {
        this.segmentHeaderAddress = this.h().segmentHeaderAddress(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegmentHeaderDependants();
    }

    @Override
    public long segmentHeaderAddress() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegmentHeader() {
        if (!this.segmentHeaderInit()) {
            return;
        }
        this.closeSegmentHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegmentHeaderDependants() {
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
    }

    public long deleted() {
        return this.segmentHeader().deleted(this.segmentHeaderAddress());
    }

    public void deleted(long deleted) {
        this.segmentHeader().deleted(this.segmentHeaderAddress(), deleted);
    }

    public long entries() {
        return this.segmentHeader().size(this.segmentHeaderAddress());
    }

    @Override
    public long size() {
        return this.entries() - this.deleted();
    }

    public void entries(long size) {
        this.segmentHeader().size(this.segmentHeaderAddress(), size);
    }

    @Override
    public boolean locksInit() {
        return this.rootContextOnThisSegment != null;
    }

    void initLocks() {
        int i;
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        this.rootContextOnThisSegment = this;
        this.concurrentSameThreadContexts = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
        this.closeLocksDependants();
    }

    public boolean concurrentSameThreadContexts() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.concurrentSameThreadContexts;
    }

    @Override
    public int latestSameThreadSegmentModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.latestSameThreadSegmentModCount;
    }

    @Override
    public int totalReadLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalReadLockCount;
    }

    @Override
    public int totalUpdateLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalUpdateLockCount;
    }

    @Override
    public int totalWriteLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalWriteLockCount;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    @Override
    public LocksInterface nextNode() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nextNode;
    }

    @Override
    public LocksInterface rootContextOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        if (this.rootContextOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.localLockState = null;
        this.rootContextOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
    }

    @Override
    public String debugLocksState() {
        String s = this + ": ";
        if (!this.usedInit()) {
            s = s + "unused";
            return s;
        }
        s = s + "used, ";
        if (!this.segmentIndexInit()) {
            s = s + "segment uninitialized";
            return s;
        }
        s = s + "segment " + this.segmentIndex() + ", ";
        if (!this.locksInit()) {
            s = s + "locks uninitialized";
            return s;
        }
        s = s + "local state: " + (Object)((Object)this.localLockState()) + ", ";
        s = s + "read lock count: " + this.rootContextOnThisSegment().totalReadLockCount() + ", ";
        s = s + "update lock count: " + this.rootContextOnThisSegment().totalUpdateLockCount() + ", ";
        s = s + "write lock count: " + this.rootContextOnThisSegment().totalWriteLockCount();
        return s;
    }

    public boolean segmentTierInit() {
        return this.segmentTier >= 0;
    }

    public void initSegmentTier() {
        this.tierIndex = this.segmentIndex() + 1;
        this.segmentBaseAddr = this.h().segmentBaseAddr(this.segmentIndex());
        this.segmentTier = 0;
        this.closeSegmentTierDependants();
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        this.segmentTier = tier;
        this.tierIndex = tierIndex;
        this.segmentBaseAddr = tierBaseAddr;
        this.closeSegmentTierDependants();
    }

    public void initSegmentTier_WithBaseAddr(int tier, long tierBaseAddr, long tierIndex) {
        this.segmentTier = tier;
        this.tierIndex = tierIndex;
        this.segmentBaseAddr = tierBaseAddr;
        this.closeSegmentTierDependants();
    }

    private void initSegmentTier(int tier, long tierIndex) {
        this.segmentTier = tier;
        this.tierIndex = tierIndex;
        assert (tierIndex > 0L);
        this.segmentBaseAddr = this.h().tierIndexToBaseAddr(tierIndex);
        this.closeSegmentTierDependants();
    }

    public int segmentTier() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.segmentTier;
    }

    public long segmentBaseAddr() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.segmentBaseAddr;
    }

    public long tierIndex() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierIndex;
    }

    public void closeSegmentTier() {
        if (!this.segmentTierInit()) {
            return;
        }
        this.closeSegmentTierDependants();
        this.segmentTier = -1;
    }

    public void closeSegmentTierDependants() {
        this.closeKeyHash();
        this.closeHashLookupPos();
        this.closeSegment();
        this.closeHashLookupSearchAddrDependants();
    }

    public boolean keyHashInit() {
        return this.keyHash != 0L;
    }

    void initKeyHash() {
        long addr = this.segmentBaseAddr() + this.keyOffset();
        long len = this.keySize();
        this.keyHash = LongHashFunction.city_1_1().hashMemory(addr, len);
    }

    public long keyHash() {
        if (!this.keyHashInit()) {
            this.initKeyHash();
        }
        return this.keyHash;
    }

    public void closeKeyHash() {
        if (!this.keyHashInit()) {
            return;
        }
        this.keyHash = 0L;
    }

    @Override
    public long keyHashCode() {
        return this.keyHash();
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos != -1L;
    }

    public void initHashLookupPos() {
        assert (this.segmentTier() >= 0);
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        this.closeHashLookupPosDependants();
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
        this.closeHashLookupPosDependants();
    }

    public long hashLookupPos() {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1L;
    }

    public void closeHashLookupPosDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public void putValueVolatile(long newValue) {
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        hashLookup.checkValueForPut(newValue);
        hashLookup.putValueVolatile(this.segmentBaseAddr(), this.hashLookupPos(), newValue);
    }

    public void found() {
        this.setHashLookupPosGuarded(this.hl().stepBack(this.hashLookupPos()));
    }

    public void closeHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash h = this.h();
        PublicMultiStoreBytes segmentBytes = this.segmentBytes;
        segmentBytes.setBytesOffset(h.tierBytes(this.tierIndex()), h.tierBytesOffset(this.tierIndex()));
        long segmentBaseAddr = this.segmentBaseAddr();
        this.segmentBS.set(segmentBaseAddr, h.segmentSize);
        long freeListOffset = h.segmentHashLookupOuterSize + 64L;
        this.freeList.setOffset(segmentBaseAddr + freeListOffset);
        this.entrySpaceOffset = freeListOffset + h.segmentFreeListOuterSize + (long)h.segmentEntrySpaceInnerOffset;
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public ReusableBitSet freeList() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.freeList;
    }

    public PointerBytesStore segmentBS() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBS;
    }

    public PublicMultiStoreBytes segmentBytes() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytes;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeValueSize();
        this.closeKeySearchKeyEqualsDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.closeEntryOffset();
        this.closeMapEntryStagesReadExistingEntryDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public boolean valueSizeInit() {
        return this.valueSize != -1L;
    }

    void initValueSize() {
        this.segmentBytes().position(this.valueSizeOffset());
        this.valueSize = this.m().readValueSize((Bytes)this.segmentBytes());
        this.countValueOffset();
        this.closeValueSizeDependants();
    }

    void initValueSize(long valueSize) {
        this.valueSize = valueSize;
        this.segmentBytes().position(this.valueSizeOffset());
        this.m().valueSizeMarshaller.writeSize((Bytes)this.segmentBytes(), valueSize);
        this.countValueOffset();
        this.closeValueSizeDependants();
    }

    void initValueSize_EqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset() + (oldValueOffset - oldValueSizeOffset);
        this.closeValueSizeDependants();
    }

    public long valueOffset() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueSize;
    }

    public void closeValueSize() {
        if (!this.valueSizeInit()) {
            return;
        }
        this.closeValueSizeDependants();
        this.valueSize = -1L;
    }

    public void closeValueSizeDependants() {
        this.closeMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    protected long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeMapEntryStagesEntryEndDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
    }

    public void writeValue(Data<?> value) {
        value.writeTo((RandomDataOutput)this.segmentBS(), this.valueOffset());
    }

    public void initValue_WithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert (oldValueSize == value.size());
        this.initValueSize_EqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        this.writeValue(value);
    }

    public void initValue(Data<?> value) {
        this.segmentBytes().position(this.valueSizeOffset());
        this.initValueSize(value.size());
        this.writeValue(value);
    }

    private long addr() {
        return this.segmentBaseAddr();
    }

    public void closeHashLookupSearchAddrDependants() {
        this.closeHashLookupSearchNextPosDependants();
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hashLookupPos();
            do {
                entry = this.hl().readEntry(this.addr(), pos);
                if (this.hl().empty(entry)) {
                    this.setHashLookupPosGuarded(pos);
                    return -1L;
                }
                pos = this.hl().step(pos);
                if (pos == this.searchStartPos()) break block2;
            } while (this.hl().key(entry) != this.searchKey());
            this.setHashLookupPosGuarded(pos);
            return this.hl().value(entry);
        }
        throw new IllegalStateException("MultiMap is full, that most likely means you misconfigured entrySize/chunkSize, and entries tend to take less chunks than expected");
    }

    public void closeHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        return this.hl().key(entry) == this.searchKey() && this.hl().value(entry) == value;
    }

    public void remove() {
        this.setHashLookupPosGuarded(this.hl().remove(this.addr(), this.hashLookupPos()));
    }

    public long tierCountersAreaAddr() {
        return this.segmentBaseAddr() + this.h().segmentHashLookupOuterSize;
    }

    public long nextPosToSearchFromTiered() {
        return TierCountersArea.nextPosToSearchFromTiered(this.tierCountersAreaAddr());
    }

    long nextPosToSearchFrom() {
        if (this.segmentTier() == 0) {
            return this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress());
        }
        return this.nextPosToSearchFromTiered();
    }

    public void nextPosToSearchFromTiered(long nextPosToSearchFrom) {
        TierCountersArea.nextPosToSearchFromTiered(this.tierCountersAreaAddr(), nextPosToSearchFrom);
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        if (this.segmentTier() == 0) {
            this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress(), nextPosToSearchFrom);
        } else {
            this.nextPosToSearchFromTiered(nextPosToSearchFrom);
        }
    }

    public void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + (long)chunks;
        if (nextPosToSearchFrom >= this.h().actualChunksPerSegment) {
            nextPosToSearchFrom = 0L;
        }
        this.nextPosToSearchFrom(nextPosToSearchFrom);
    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " entry size chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long ret = this.freeList().setNextNContinuousClearBits(this.nextPosToSearchFrom(), chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
            if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                this.freeList().clearRange(ret, h.actualChunksPerSegment);
            }
            if ((ret = this.freeList().setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                    this.freeList().clearRange(ret, h.actualChunksPerSegment);
                }
                return -1L;
            }
            this.updateNextPosToSearchFrom(ret, chunks);
        } else if (chunks == 1 || this.freeList().isSet(this.nextPosToSearchFrom())) {
            this.updateNextPosToSearchFrom(ret, chunks);
        }
        return ret;
    }

    public void free(long fromPos, int chunks) {
        this.freeList().clearRange(fromPos, fromPos + (long)chunks);
        if (fromPos < this.nextPosToSearchFrom()) {
            this.nextPosToSearchFrom(fromPos);
        }
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(this.tierCountersAreaAddr());
    }

    public void prevTier() {
        if (this.segmentTier() == 0) {
            throw new IllegalStateException("first tier doesn't have previous");
        }
        this.initSegmentTier(this.segmentTier() - 1, this.prevTierIndex());
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(this.tierCountersAreaAddr(), prevTierIndex);
    }

    public long nextTierIndex() {
        return TierCountersArea.nextTierIndex(this.tierCountersAreaAddr());
    }

    public boolean hasNextTier() {
        return this.nextTierIndex() != 0L;
    }

    public void nextTierIndex(long nextTierIndex) {
        TierCountersArea.nextTierIndex(this.tierCountersAreaAddr(), nextTierIndex);
    }

    public void goToFirstTier() {
        while (this.segmentTier() != 0) {
            this.prevTier();
        }
    }

    public void nextTier() {
        this._SegmentStages_nextTier();
        if (this.hashLookupEntryInit()) {
            this.initSearchKey(this.h().hashLookup.key(this.hashLookupEntry()));
        }
    }

    public void goToLastTier() {
        while (this.hasNextTier()) {
            this.nextTier();
        }
    }

    @Override
    public long alloc(int chunks) {
        long ret;
        while ((ret = this.allocReturnCode(chunks)) < 0L) {
            this.nextTier();
        }
        return ret;
    }

    @Override
    public boolean usedInit() {
        return this.used;
    }

    @Override
    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
    }

    boolean entryRemovedOnThisIterationInit() {
        return this.entryRemovedOnThisIteration;
    }

    protected void initEntryRemovedOnThisIteration(boolean entryRemovedOnThisIteration) {
        this.entryRemovedOnThisIteration = entryRemovedOnThisIteration;
    }

    public void closeEntryRemovedOnThisIteration() {
        if (!this.entryRemovedOnThisIterationInit()) {
            return;
        }
        this.entryRemovedOnThisIteration = false;
    }

    boolean inputKeyInit() {
        return this.inputKey != null;
    }

    public void initInputKey(Data<K> inputKey) {
        this.inputKey = inputKey;
        this.closeInputKeyDependants();
    }

    public Data<K> inputKey() {
        assert (this.inputKeyInit()) : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!this.inputKeyInit()) {
            return;
        }
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeKeySearchKeyEqualsDependants();
    }

    boolean keyEquals() {
        return this.inputKey().size() == this.keySize() && BytesUtil.bytesEqual((RandomDataInput)this.segmentBS(), (long)this.keyOffset(), (RandomDataInput)this.inputKey().bytes(), (long)this.inputKey().offset(), (long)this.keySize());
    }

    public void closeKeySearchKeyEqualsDependants() {
        this.closeKeySearch();
    }

    public boolean posInit() {
        return this.pos != -1L;
    }

    public void initPos(long pos) {
        this.pos = pos;
        this.closePosDependants();
    }

    @Override
    public long pos() {
        assert (this.posInit()) : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!this.posInit()) {
            return;
        }
        this.closePosDependants();
        this.pos = -1L;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
    }

    public boolean entryOffsetInit() {
        return this.keySizeOffset != -1L;
    }

    public void initEntryOffset() {
        this.keySizeOffset = this.entrySpaceOffset() + this.pos() * this.h().chunkSize;
        this.segmentBytes().limit(this.segmentBytes().capacity());
        this.closeEntryOffsetDependants();
    }

    public long keySizeOffset() {
        if (!this.entryOffsetInit()) {
            this.initEntryOffset();
        }
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!this.entryOffsetInit()) {
            return;
        }
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1L;
    }

    public void closeEntryOffsetDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
        this.closeMapEntryStagesReadExistingEntryDependants();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        this.segmentBytes().position(this.keySizeOffset());
        this.h().keySizeMarshaller.writeSize((Bytes)this.segmentBytes(), this.keySize());
        this.initKeyOffset(this.segmentBytes().position());
        key.writeTo((RandomDataOutput)this.segmentBS(), this.keyOffset());
    }

    long entrySize() {
        return this.checksumStrategy.extraEntryBytes() + this.entryEnd() - this.keySizeOffset();
    }

    public void closeMapEntryStagesEntrySizeDependants() {
        this.closeEntrySizeInChunks();
    }

    public boolean entrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            this.initEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeEntrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            return;
        }
        this.entrySizeInChunks = 0;
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset() + (oldKeyAddr - oldKeySizeAddr));
        Access.copy((ReadAccess)Access.nativeAccess(), null, (long)oldKeySizeAddr, (WriteAccess)Access.checkedBytesStoreAccess(), (Object)this.segmentBS(), (long)this.keySizeOffset(), (long)bytesToCopy);
    }

    public boolean initEntryAndKeyCopying(long entrySize, long bytesToCopy) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.incrementSegmentEntriesIfNeeded();
        long oldSegmentTierBaseAddr = this.segmentBaseAddr();
        long oldKeySizeAddr = oldSegmentTierBaseAddr + this.keySizeOffset();
        long oldKeyAddr = oldSegmentTierBaseAddr + this.keyOffset();
        int tierBeforeAllocation = this.segmentTier();
        long pos = this.alloc(this.allocatedChunks());
        this.copyExistingEntry(pos, bytesToCopy, oldKeyAddr, oldKeySizeAddr);
        return this.segmentTier() != tierBeforeAllocation;
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset() + (long)this.m().valueSizeMarshaller.sizeEncodingSize(newValue.size()) - this.keySizeOffset();
    }

    public void readExistingEntry(long pos) {
        this.initPos(pos);
        this.segmentBytes().position(this.keySizeOffset());
        this.initKeySize(this.h().keySizeMarshaller.readSize((Bytes)this.segmentBytes()));
        this.initKeyOffset(this.segmentBytes().position());
    }

    public void closeMapEntryStagesReadExistingEntryDependants() {
        this.closeKeySearch();
    }

    boolean keySearchInit() {
        return this.searchState != null;
    }

    public void initKeySearch() {
        long pos;
        while ((pos = this.nextPos()) >= 0L) {
            if (!this.inputKeyInit()) continue;
            this.readExistingEntry(pos);
            if (!this.keyEquals()) continue;
            this.found();
            this.keyFound();
            return;
        }
        this.searchState = SearchState.ABSENT;
    }

    public SearchState searchState() {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        return this.searchState;
    }

    void closeKeySearch() {
        if (!this.keySearchInit()) {
            return;
        }
        this.searchState = null;
    }

    public boolean searchStateDeleted() {
        return this.searchState() == SearchState.DELETED && !this.concurrentSameThreadContexts() && this.innerUpdateLock.isHeldByCurrentThread();
    }

    public boolean searchStatePresent() {
        return this.searchState() == SearchState.PRESENT;
    }

    public boolean searchStateAbsent() {
        return !this.searchStatePresent() && !this.searchStateDeleted();
    }

    public void putNewVolatile(long value) {
        assert (!this.searchStatePresent());
        this.hl().checkValueForPut(value);
        long currentEntry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        this.hl().writeEntryVolatile(this.addr(), this.hashLookupPos(), currentEntry, this.searchKey(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long forEachTierWhile(Predicate<? super MapEntry<K, V>> action, long size, int currentTier, long currentTierBaseAddr, long tierIndex) {
        long currentHashLookupPos;
        boolean interrupted = false;
        long startPos = 0L;
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startPos))) {
            startPos = hashLookup.step(startPos);
        }
        this.initHashLookupPos(startPos);
        do {
            currentHashLookupPos = hashLookup.step(this.hashLookupPos());
            this.setHashLookupPosGuarded(currentHashLookupPos);
            long entry = hashLookup.readEntry(currentTierBaseAddr, currentHashLookupPos);
            this.initHashLookupEntry(entry);
            if (hashLookup.empty(entry)) continue;
            this.readExistingEntry(hashLookup.value(entry));
            if (!this.entryIsPresent()) continue;
            this.initEntryRemovedOnThisIteration(false);
            try {
                if (!action.test(this)) {
                    interrupted = true;
                    break;
                }
                if (--size != 0L) continue;
                break;
            }
            finally {
                if (this.segmentTier() != currentTier) {
                    this.initSegmentTier_WithBaseAddr(currentTier, currentTierBaseAddr, tierIndex);
                    currentHashLookupPos = hashLookup.stepBack(currentHashLookupPos);
                    this.initHashLookupPos(currentHashLookupPos);
                }
            }
        } while (currentHashLookupPos != startPos);
        return interrupted ? size ^ 0xFFFFFFFFFFFFFFFFL : size;
    }

    @Override
    public boolean forEachSegmentEntryWhile(Predicate<? super MapEntry<K, V>> action) {
        this.innerUpdateLock.lock();
        try {
            long size = this.size();
            if (size == 0L) {
                boolean bl = true;
                return bl;
            }
            this.goToLastTier();
            while (true) {
                long currentTierIndex;
                long currentTierBaseAddr;
                int currentTier;
                if ((size = this.forEachTierWhile(action, size, currentTier = this.segmentTier(), currentTierBaseAddr = this.segmentBaseAddr(), currentTierIndex = this.tierIndex())) < 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (size == 0L) {
                    boolean bl = true;
                    return bl;
                }
                if (currentTier == 0) {
                    throw new IllegalStateException("We iterated all tiers without interruption, but according to size counter there should be " + size + " more " + "entries. Size diverged?");
                }
                this.prevTier();
            }
        }
        finally {
            this.closeHashLookupEntry();
            this.innerReadLock.unlock();
            this.initEntryRemovedOnThisIteration(false);
        }
    }

    @Override
    public void forEachSegmentEntry(Consumer<? super MapEntry<K, V>> action) {
        this.forEachSegmentEntryWhile((Predicate<? super MapEntry<K, V>>)((Predicate<MapEntry>)e -> {
            action.accept((Object)e);
            return true;
        }));
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.free(this.pos(), this.entrySizeInChunks());
        this.entries(this.entries() - 1L);
        this.incrementModCountGuarded();
    }

    public void iterationRemove() {
        if (this.h().hashLookup.remove(this.segmentBaseAddr(), this.hashLookupPos()) != this.hashLookupPos()) {
            this.setHashLookupPosGuarded(this.h().hashLookup.stepBack(this.hashLookupPos()));
        }
        this.innerRemoveEntryExceptHashLookupUpdate();
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        try {
            this.iterationRemove();
        }
        finally {
            this.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    public final void freeExtraAllocatedChunks() {
        if (!this.m().constantlySizedEntry && this.m().couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.free(this.pos() + (long)this.entrySizeInChunks(), this.allocatedChunks() - this.entrySizeInChunks());
        } else {
            this.initEntrySizeInChunks(this.allocatedChunks());
        }
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.innerWriteLock.lock();
        this.free(this.pos(), this.entrySizeInChunks());
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hashLookupPos();
        long oldHashLookupAddr = this.segmentBaseAddr();
        boolean tierHasChanged = this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset());
        if (tierHasChanged && !this.searchStateAbsent()) {
            throw new AssertionError();
        }
        this.initValue(newValue);
        this.freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.h().hashLookup;
        long oldEntry = hl.readEntry(oldHashLookupAddr, oldHashLookupPos);
        hl.checkValueForPut(this.pos());
        hl.writeEntryVolatile(this.segmentBaseAddr(), this.hashLookupPos(), oldEntry, hl.key(oldEntry), this.pos());
        if (tierHasChanged) {
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = (newValueOffset = m.alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue)) + newValue.size() - entryStartOffset);
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.freeList().isRangeClear(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
                this.freeList().setRange(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks);
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeList().clearRange(this.pos() + (long)newSizeInChunks, this.pos() + (long)this.entrySizeInChunks());
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
            return;
        }
        this.writeValue(newValue);
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.checkOnEachPublicOperation();
        try {
            this.innerDefaultReplaceValue(newValue);
            this.checksumStrategy.computeAndStoreChecksum();
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    public void writeValueAndPutPos(Data<V> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putValueVolatile(this.pos());
    }

    public static enum SearchState {
        PRESENT,
        DELETED,
        ABSENT;

    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @NotNull
        private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire write lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                            if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledMapIterationContext.this.incrementWriteGuarded();
                                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapIterationContext.this.segmentHeader().tryWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapIterationContext.this.updateZeroGuarded());
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapIterationContext.this.decrementUpdateGuarded();
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                            if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                                CompiledMapIterationContext.this.incrementWriteGuarded();
                                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapIterationContext.this.segmentHeader().tryWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapIterationContext.this.updateZeroGuarded());
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledMapIterationContext.this.decrementUpdateGuarded();
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                            CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledMapIterationContext.this.segmentHeader().writeLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapIterationContext.this.updateZeroGuarded());
                        CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    int newTotalWriteLockCount = CompiledMapIterationContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        CompiledMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalWriteLockCount > 0) : "write underflow";
                    break;
                }
            }
            CompiledMapIterationContext.this.incrementUpdateGuarded();
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapIterationContext.this.localLockState().write;
        }

        @Override
        public void lock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                            CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledMapIterationContext.this.segmentHeader().writeLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapIterationContext.this.updateZeroGuarded());
                        CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }
    }

    public class WrappedValueInstanceData
    extends CopyingInstanceData<V> {
        private V value;
        private boolean marshalled = false;
        private DirectBytes buf;
        private WrappedValueInstanceData next;

        public WrappedValueInstanceData getUnusedWrappedValueGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValue();
        }

        public WrappedValueInstanceData getUnusedWrappedValue() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceData();
            }
            return this.next.getUnusedWrappedValue();
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            CompiledMapIterationContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next != null) {
                this.next.closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        @Override
        public V instance() {
            return this.value();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mvi = CompiledMapIterationContext.this.valueMetaInterop(this.value());
            long size = mvi.size(CompiledMapIterationContext.this.valueInterop, this.value());
            this.buf = this.getBuffer(this.buf, size);
            mvi.write(CompiledMapIterationContext.this.valueInterop, (Bytes)this.buf, this.value());
            this.buf.flip();
            this.marshalled = true;
        }

        public DirectBytes buf() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buf;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public V getUsing(V usingValue) {
            this.buf().position(0L);
            return CompiledMapIterationContext.this.valueReader.read((Bytes)this.buf(), this.buf().limit(), usingValue);
        }

        @Override
        public DirectBytes buffer() {
            return this.buf();
        }

        boolean nextInit() {
            return true;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @NotNull
        private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire update lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        CompiledMapIterationContext.this.segmentHeader().updateLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapIterationContext.this.localLockState().update;
        }

        @Override
        public void unlock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    int newTotalUpdateLockCount = CompiledMapIterationContext.this.decrementUpdateGuarded();
                    if (newTotalUpdateLockCount == 0) {
                        if (!CompiledMapIterationContext.this.writeZeroGuarded()) break;
                        CompiledMapIterationContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalUpdateLockCount > 0) : "update underflow";
                    break;
                }
                case WRITE_LOCKED: {
                    int newTotalWriteLockCount = CompiledMapIterationContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                            CompiledMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                            break;
                        }
                        CompiledMapIterationContext.this.segmentHeader().downgradeWriteToReadLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalWriteLockCount > 0) : "write underflow";
                    break;
                }
            }
            CompiledMapIterationContext.this.incrementReadGuarded();
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        try {
                            CompiledMapIterationContext.this.segmentHeader().updateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                        catch (RuntimeException e) {
                            LOG.error(CompiledMapIterationContext.this.debugContextsAndLocksGuarded());
                            throw e;
                        }
                    }
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledMapIterationContext.this.incrementUpdateGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapIterationContext.this.incrementUpdateGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapIterationContext.this.readZeroGuarded() && CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                    CompiledMapIterationContext.this.segmentHeader().readLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                }
                CompiledMapIterationContext.this.incrementReadGuarded();
                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void lock() {
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapIterationContext.this.readZeroGuarded() && CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                    CompiledMapIterationContext.this.segmentHeader().readLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                }
                CompiledMapIterationContext.this.incrementReadGuarded();
                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        public void closeReadLockLockDependants() {
            CompiledMapIterationContext.this.closeHashLookupPos();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapIterationContext.this.localLockState().read;
        }

        @Override
        public void unlock() {
            CompiledMapIterationContext.this.readUnlockAndDecrementCountGuarded();
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
            CompiledMapIterationContext.this.closeHashLookupPos();
            CompiledMapIterationContext.this.closePos();
        }

        @Override
        public boolean tryLock() {
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledMapIterationContext.this.readZeroGuarded() || !CompiledMapIterationContext.this.updateZeroGuarded() || !CompiledMapIterationContext.this.writeZeroGuarded() || CompiledMapIterationContext.this.segmentHeader().tryReadLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                    CompiledMapIterationContext.this.incrementReadGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledMapIterationContext.this.readZeroGuarded() || !CompiledMapIterationContext.this.updateZeroGuarded() || !CompiledMapIterationContext.this.writeZeroGuarded() || CompiledMapIterationContext.this.segmentHeader().tryReadLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledMapIterationContext.this.incrementReadGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public class HashKeyCrc32PayloadChecksumStrategy
    implements ChecksumStrategy {
        @Override
        public long extraEntryBytes() {
            return 4L;
        }

        private int computeChecksum() {
            long checksum;
            long keyHashCode = CompiledMapIterationContext.this.keyHashCode();
            long keyEnd = CompiledMapIterationContext.this.keyEnd();
            long len = CompiledMapIterationContext.this.entryEnd() - keyEnd;
            if (len > 0L) {
                long addr = CompiledMapIterationContext.this.segmentBaseAddr() + keyEnd;
                int payloadCrc = Crc32.compute(addr, len);
                checksum = ChecksumHashing.hash8To16Bytes(CompiledMapIterationContext.this.keySize(), keyHashCode, payloadCrc);
            } else {
                checksum = ChecksumHashing.hash8To16Bytes(CompiledMapIterationContext.this.keySize(), keyHashCode, keyHashCode);
            }
            return (int)(checksum >>> 32 ^ checksum);
        }

        @Override
        public void computeAndStoreChecksum() {
            int crc = this.computeChecksum();
            CompiledMapIterationContext.this.segmentBS().writeInt(CompiledMapIterationContext.this.entryEnd(), crc);
        }

        @Override
        public void updateChecksum() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            this.computeAndStoreChecksum();
        }

        @Override
        public boolean innerCheckSum() {
            int crc;
            int oldChecksum = CompiledMapIterationContext.this.segmentBS().readInt(CompiledMapIterationContext.this.entryEnd());
            return oldChecksum == (crc = this.computeChecksum());
        }

        @Override
        public boolean checkSum() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerCheckSum();
        }
    }

    public class EntryValueBytesData
    extends AbstractData<V> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead = false;

        @Override
        public long offset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            CompiledMapIterationContext.this.segmentBytes().position(CompiledMapIterationContext.this.valueOffset());
            return CompiledMapIterationContext.this.valueReader.read((Bytes)CompiledMapIterationContext.this.segmentBytes(), this.size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingValue);
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.segmentBS();
        }
    }

    public class EntryKeyBytesData
    extends AbstractData<K> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        @Override
        public long offset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keyOffset();
        }

        @Override
        public long size() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.segmentBS();
        }

        private K innerGetUsing(K usingKey) {
            CompiledMapIterationContext.this.segmentBytes().position(CompiledMapIterationContext.this.keyOffset());
            return CompiledMapIterationContext.this.keyReader.read((Bytes)CompiledMapIterationContext.this.segmentBytes(), this.size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                return;
            }
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public K getUsing(K usingKey) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingKey);
        }
    }
}

