/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.LogHolder;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public class UpdateLock
implements InterProcessLock {
    @StageRef
    LogHolder logHolder;
    @StageRef
    SegmentStages s;

    @Override
    public boolean isHeldByCurrentThread() {
        return this.s.localLockState.update;
    }

    @Override
    public void lock() {
        switch (this.s.localLockState) {
            case UNLOCKED: {
                if (this.s.updateZero() && this.s.writeZero()) {
                    if (!this.s.readZero()) {
                        throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                    }
                    try {
                        this.s.segmentHeader.updateLock(this.s.segmentHeaderAddress);
                    }
                    catch (RuntimeException e) {
                        LogHolder.LOG.error(this.s.debugContextsAndLocks());
                        throw e;
                    }
                }
                this.s.incrementUpdate();
                this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                return;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
        }
    }

    @NotNull
    private IllegalMonitorStateException forbiddenUpgrade() {
        return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
    }

    @NotNull
    private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
        return new IllegalStateException("Cannot acquire update lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        switch (this.s.localLockState) {
            case UNLOCKED: {
                if (this.s.updateZero() && this.s.writeZero()) {
                    if (!this.s.readZero()) {
                        throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                    }
                    this.s.segmentHeader.updateLockInterruptibly(this.s.segmentHeaderAddress);
                }
                this.s.incrementUpdate();
                this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                return;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
        }
    }

    @Override
    public boolean tryLock() {
        switch (this.s.localLockState) {
            case UNLOCKED: {
                if (this.s.updateZero() && this.s.writeZero()) {
                    if (!this.s.readZero()) {
                        throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                    }
                    if (this.s.segmentHeader.tryUpdateLock(this.s.segmentHeaderAddress)) {
                        this.s.incrementUpdate();
                        this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.incrementUpdate();
                this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                return true;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: 
            case WRITE_LOCKED: {
                return true;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
        switch (this.s.localLockState) {
            case UNLOCKED: {
                if (this.s.updateZero() && this.s.writeZero()) {
                    if (!this.s.readZero()) {
                        throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                    }
                    if (this.s.segmentHeader.tryUpdateLock(this.s.segmentHeaderAddress, time, unit)) {
                        this.s.incrementUpdate();
                        this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.incrementUpdate();
                this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                return true;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: 
            case WRITE_LOCKED: {
                return true;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void unlock() {
        switch (this.s.localLockState) {
            case UNLOCKED: 
            case READ_LOCKED: {
                return;
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = this.s.decrementUpdate();
                if (newTotalUpdateLockCount == 0) {
                    if (!this.s.writeZero()) break;
                    this.s.segmentHeader.downgradeUpdateToReadLock(this.s.segmentHeaderAddress);
                    break;
                }
                assert (newTotalUpdateLockCount > 0) : "update underflow";
                break;
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = this.s.decrementWrite();
                if (newTotalWriteLockCount == 0) {
                    if (!this.s.updateZero()) {
                        this.s.segmentHeader.downgradeWriteToUpdateLock(this.s.segmentHeaderAddress);
                        break;
                    }
                    this.s.segmentHeader.downgradeWriteToReadLock(this.s.segmentHeaderAddress);
                    break;
                }
                assert (newTotalWriteLockCount > 0) : "write underflow";
                break;
            }
        }
        this.s.incrementRead();
        this.s.setLocalLockState(LocalLockState.READ_LOCKED);
    }
}

