/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CopyingInstanceData;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.hashlookup.EntryConsumer;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.locks.InterProcessReadWriteUpdateLock;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.IterationContextInterface;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;

public class CompiledMapIterationContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R>
implements AutoCloseable,
HashEntry<K>,
InterProcessReadWriteUpdateLock,
MapContext<K, V, R>,
MapEntry<K, V>,
IterationContextInterface<K, V>,
VanillaChronicleMapHolder<K, KI, MKI, V, VI, MVI, R> {
    final Thread owner;
    public final int indexInContextChain;
    public final Bytes entryBytes;
    public static final int MAX_SEGMENT_CHUNKS = 0x40000000;
    public static final int MAX_SEGMENT_ENTRIES = 0x20000000;
    public static final long UNSET_KEY = 0L;
    public static final long UNSET_ENTRY = 0L;
    public final ReadLock innerReadLock;
    public final WriteLock innerWriteLock;
    public final List<CompiledMapIterationContext> contextChain;
    public final UpdateLock innerUpdateLock;
    public final ThreadLocalCopies copies;
    final EntryKeyBytesData entryKey;
    public final EntryValueBytesData entryValue;
    final WrappedValueInstanceData wrappedValueInstanceValue;
    public final DeprecatedMapKeyContextOnIteration deprecatedMapKeyContextOnIteration;
    private final VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m;
    public final VI valueInterop;
    public final BytesStore entryBS;
    public final BytesReader<V> valueReader;
    public final KI keyInterop;
    public final BytesReader<K> keyReader;
    public long keyOffset = -1L;
    public long hashLookupPos = -1L;
    public int allocatedChunks = 0;
    public long pos = -1L;
    public long keySize = -1L;
    public long valueSizeOffset = -1L;
    public long valueSize = -1L;
    public long valueOffset;
    boolean used;
    public boolean entryRemovedOnThisIteration = false;
    public int segmentIndex = -1;
    long entrySpaceOffset = 0L;
    MultiStoreBytes freeListBytes = new MultiStoreBytes();
    public SingleThreadedDirectBitSet freeList = new SingleThreadedDirectBitSet();
    public long keySizeOffset = -1L;
    public int entrySizeInChunks = 0;
    int hashLookupEntrySize;
    int keyBits;
    long address = -1L;
    long capacityMask;
    long capacityMask2;
    long keyMask;
    long valueMask;
    long entryMask;
    long segmentHeaderAddress;
    SegmentHeader segmentHeader = null;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    CompiledMapIterationContext nextNode;
    public boolean concurrentSameThreadContexts;
    LocalLockState localLockState;
    public CompiledMapIterationContext rootContextOnThisSegment = null;

    @Override
    public void close() {
        this.closeTheSegmentIndex();
        this.wrappedValueInstanceValue.closeValue();
        this.closeEntryRemovedOnThisIteration();
        this.wrappedValueInstanceValue.closeNext();
        this.closeUsed();
        this.closeKeySize();
        this.closePos();
        this.closeAllocatedChunks();
        this.closeHashLookupPos();
        this.closeKeyOffset();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants();
        this.closeValueBytesInteropValueMetaInteropDependants();
        this.closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants();
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        assert (this.hashLookupPosInit()) : "HashLookupPos should be init";
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    public CompiledMapIterationContext(VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        this.contextChain = new ArrayList<CompiledMapIterationContext>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.m = m;
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = (BytesReader)this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.entryKey = new EntryKeyBytesData();
        this.innerUpdateLock = new UpdateLock();
        this.innerReadLock = new ReadLock();
        this.entryValue = new EntryValueBytesData();
        this.innerWriteLock = new WriteLock();
        this.entryBytes = this.h().ms.bytes();
        this.entryBS = new NativeBytesStore(this.entryBytes.address(), this.entryBytes.capacity(), null, false);
        this.owner = Thread.currentThread();
        this.deprecatedMapKeyContextOnIteration = new DeprecatedMapKeyContextOnIteration();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
    }

    public CompiledMapIterationContext(CompiledMapIterationContext c) {
        this.contextChain = c.contextChain;
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.m = c.m;
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = (BytesReader)this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.entryKey = new EntryKeyBytesData();
        this.innerUpdateLock = new UpdateLock();
        this.innerReadLock = new ReadLock();
        this.entryValue = new EntryValueBytesData();
        this.innerWriteLock = new WriteLock();
        this.entryBytes = this.h().ms.bytes();
        this.entryBS = new NativeBytesStore(this.entryBytes.address(), this.entryBytes.capacity(), null, false);
        this.owner = Thread.currentThread();
        this.deprecatedMapKeyContextOnIteration = new DeprecatedMapKeyContextOnIteration();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
    }

    public void incrementModCount() {
        this.contextModCount = ++this.rootContextOnThisSegment.latestSameThreadSegmentModCount;
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        this.localLockState = newState;
    }

    public Thread owner() {
        return this.owner;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        switch (this.localLockState) {
            case UNLOCKED: {
                break;
            }
            case READ_LOCKED: {
                int newTotalReadLockCount = --this.rootContextOnThisSegment.totalReadLockCount;
                if (newTotalReadLockCount == 0) {
                    if (this.rootContextOnThisSegment.totalUpdateLockCount != 0 || this.rootContextOnThisSegment.totalWriteLockCount != 0) break;
                    this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                    break;
                }
                if (newTotalReadLockCount >= 0) break;
                throw new IllegalStateException("read underflow");
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = --this.rootContextOnThisSegment.totalUpdateLockCount;
                if (newTotalUpdateLockCount == 0) {
                    if (this.rootContextOnThisSegment.totalWriteLockCount != 0) break;
                    if (this.rootContextOnThisSegment.totalReadLockCount == 0) {
                        this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                        break;
                    }
                    this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                    break;
                }
                if (newTotalUpdateLockCount >= 0) break;
                throw new IllegalStateException("update underflow");
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = --this.rootContextOnThisSegment.totalWriteLockCount;
                if (newTotalWriteLockCount != 0) break;
                if (this.rootContextOnThisSegment.totalUpdateLockCount > 0) {
                    this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                    break;
                }
                if (this.rootContextOnThisSegment.totalReadLockCount > 0) {
                    this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                    break;
                }
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void closeRootLocks() {
        assert (this.nextNode == null);
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void innerInitSegmentHashLookup(long address, long capacity, int entrySize, int keyBits, int valueBits) {
        this.address = address;
        this.capacityMask = capacity - 1L;
        this.hashLookupEntrySize = entrySize;
        this.capacityMask2 = this.capacityMask * (long)entrySize;
        this.keyBits = keyBits;
        this.keyMask = CompiledMapIterationContext.mask(keyBits);
        this.valueMask = CompiledMapIterationContext.mask(valueBits);
        this.entryMask = CompiledMapIterationContext.mask(keyBits + valueBits);
    }

    private void unlinkFromSegmentContextsChain() {
        CompiledMapIterationContext prevContext = this.rootContextOnThisSegment;
        while (true) {
            assert (prevContext.nextNode != null);
            if (prevContext.nextNode == this) break;
            prevContext = prevContext.nextNode;
        }
        assert (this.nextNode == null);
        prevContext.nextNode = null;
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    private CompiledMapIterationContext _Chaining_createChaining() {
        return new CompiledMapIterationContext<K, KI, MKI, V, VI, MVI, R>(this);
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public static int entrySize(int keyBits, int valueBits) {
        return (int)MemoryUnit.BYTES.alignAndConvert((long)(keyBits + valueBits), MemoryUnit.BITS);
    }

    public static int keyBits(long entriesPerSegment, int valueBits) {
        int minKeyBits = 64 - Long.numberOfLeadingZeros(entriesPerSegment - 1L);
        int actualEntryBits = (int)MemoryUnit.BYTES.align((long)((minKeyBits += 3) + valueBits), MemoryUnit.BITS);
        return actualEntryBits - valueBits;
    }

    public static int valueBits(long actualChunksPerSegment) {
        return 64 - Long.numberOfLeadingZeros(actualChunksPerSegment - 1L);
    }

    public Bytes entryBytes() {
        return this.entryBytes;
    }

    public static long capacityFor(long entriesPerSegment) {
        if (entriesPerSegment < 0L) {
            throw new IllegalArgumentException("entriesPerSegment should be positive");
        }
        long capacity = Maths.nextPower2((long)entriesPerSegment, (long)64L);
        if ((double)entriesPerSegment / (double)capacity > 0.6666666666666666) {
            capacity <<= 1;
        }
        return capacity;
    }

    public static long mask(int bits) {
        return (1L << bits) - 1L;
    }

    public int MAX_SEGMENT_ENTRIES() {
        return 0x20000000;
    }

    public int MAX_SEGMENT_CHUNKS() {
        return 0x40000000;
    }

    public long UNSET_ENTRY() {
        return 0L;
    }

    public long UNSET_KEY() {
        return 0L;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public List<CompiledMapIterationContext> contextChain() {
        return this.contextChain;
    }

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public ThreadLocalCopies copies() {
        return this.copies;
    }

    private void countValueOffset() {
        this.m().alignment.alignPositionAddr(this.entryBytes);
        this.valueOffset = this.entryBytes.position();
    }

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    public WrappedValueInstanceData wrappedValueInstanceValue() {
        return this.wrappedValueInstanceValue;
    }

    public DeprecatedMapKeyContextOnIteration deprecatedMapKeyContextOnIteration() {
        return this.deprecatedMapKeyContextOnIteration;
    }

    public VI valueInterop() {
        return this.valueInterop;
    }

    public BytesStore entryBS() {
        return this.entryBS;
    }

    public BytesReader<V> valueReader() {
        return this.valueReader;
    }

    public KI keyInterop() {
        return this.keyInterop;
    }

    public BytesReader<K> keyReader() {
        return this.keyReader;
    }

    public boolean entryIsPresent() {
        return true;
    }

    @Override
    public VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m() {
        return this.m;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    public CompiledMapIterationContext createChaining() {
        return new CompiledMapIterationContext<K, KI, MKI, V, VI, MVI, R>(this);
    }

    public <T> T getContext() {
        for (CompiledMapIterationContext context : this.contextChain) {
            if (context.usedInit()) continue;
            return (T)context;
        }
        int maxNestedContexts = 65536;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        return (T)this.createChaining();
    }

    public void incrementSegmentEntriesIfNeeded() {
    }

    public void checkEntryNotRemovedOnThisIteration() {
        if (this.entryRemovedOnThisIterationInit()) {
            throw new IllegalStateException("Entry was already removed on this iteration");
        }
    }

    public void closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)(this.m().metaDataBytes + this.m().keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)this.m().valueSizeMarshaller.sizeEncodingSize(valueSize);
    }

    @Override
    @NotNull
    public MapContext<K, V, ?> context() {
        return this;
    }

    public MVI valueMetaInterop(V value) {
        return (MVI)((MetaBytesInterop)this.m().metaValueInteropProvider.get(this.copies, this.m().originalMetaValueInterop, this.valueInterop, value));
    }

    public void closeValueBytesInteropValueMetaInteropDependants() {
        this.wrappedValueInstanceValue.closeBuffer();
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeSegmentStagesTryFindInitLocksOfThisSegmentDependants();
    }

    public MKI keyMetaInterop(K key) {
        return (MKI)((MetaBytesInterop)this.h().metaKeyInteropProvider.get(this.copies, this.h().originalMetaKeyInterop, this.keyInterop, key));
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (this.m().constantlySizedEntry) {
            return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue + valueSize);
        }
        if (this.m().couldNotDetermineAlignmentBeforeAllocation) {
            return sizeOfEverythingBeforeValue + (long)this.m().worstAlignment + valueSize;
        }
        return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue) + valueSize;
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.checkEntryNotRemovedOnThisIteration();
    }

    public void closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.replaceValue(entry, newValue);
    }

    @Override
    public Data<V> wrapValueAsValue(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceData wrapped = this.wrappedValueInstanceValue;
        wrapped = wrapped.getUnusedWrappedValueGuarded();
        wrapped.initValue(value);
        return wrapped;
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public Data<V> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.defaultValue(absentEntry);
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.remove(entry);
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.insert(absentEntry, value);
    }

    public boolean keyOffsetInit() {
        return this.keyOffset >= 0L;
    }

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
        this.closeKeyOffsetDependants();
    }

    public long keyOffset() {
        assert (this.keyOffsetInit()) : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!this.keyOffsetInit()) {
            return;
        }
        this.closeKeyOffsetDependants();
        this.keyOffset = -1L;
    }

    public void closeKeyOffsetDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos >= 0L;
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public long hashLookupPos() {
        assert (this.hashLookupPosInit()) : "HashLookupPos should be init";
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.hashLookupPos = -1L;
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!this.allocatedChunksInit()) {
            return;
        }
        this.allocatedChunks = 0;
    }

    public boolean posInit() {
        return this.pos >= 0L;
    }

    public void initPos(long pos) {
        this.pos = pos;
        this.closePosDependants();
    }

    @Override
    public long pos() {
        assert (this.posInit()) : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!this.posInit()) {
            return;
        }
        this.closePosDependants();
        this.pos = -1L;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
    }

    public boolean keySizeInit() {
        return this.keySize >= 0L;
    }

    public void initKeySize(long keySize) {
        this.keySize = keySize;
        this.closeKeySizeDependants();
    }

    public long keySize() {
        assert (this.keySizeInit()) : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!this.keySizeInit()) {
            return;
        }
        this.closeKeySizeDependants();
        this.keySize = -1L;
    }

    public void closeKeySizeDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeMapEntryStagesKeyEndDependants() {
        this.closeMapEntryStagesCountValueSizeOffsetDependants();
        this.closeMapEntryStagesEntryEndDependants();
    }

    long countValueSizeOffset() {
        return this.keyEnd();
    }

    public void closeMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public boolean valueSizeOffsetInit() {
        return this.valueSizeOffset >= 0L;
    }

    void initValueSizeOffset() {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.closeValueSizeOffsetDependants();
    }

    public long valueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            this.initValueSizeOffset();
        }
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            return;
        }
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1L;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValSize();
    }

    public boolean valSizeInit() {
        return this.valueSize >= 0L;
    }

    void initValSize() {
        this.entryBytes.position(this.valueSizeOffset());
        this.valueSize = this.m().readValueSize(this.entryBytes);
        this.countValueOffset();
        this.closeValSizeDependants();
    }

    void initValSize(long valueSize) {
        this.valueSize = valueSize;
        this.entryBytes.position(this.valueSizeOffset());
        this.m().valueSizeMarshaller.writeSize(this.entryBytes, valueSize);
        this.countValueOffset();
        this.closeValSizeDependants();
    }

    void initValSizeEqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset() + (oldValueOffset - oldValueSizeOffset);
        this.closeValSizeDependants();
    }

    public long valueOffset() {
        if (!this.valSizeInit()) {
            this.initValSize();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valSizeInit()) {
            this.initValSize();
        }
        return this.valueSize;
    }

    public void closeValSize() {
        if (!this.valSizeInit()) {
            return;
        }
        this.closeValSizeDependants();
        this.valueSize = -1L;
    }

    public void closeValSizeDependants() {
        this.closeMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    protected long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeMapEntryStagesEntryEndDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
    }

    public void writeValue(Data<?> value) {
        value.writeTo((RandomDataOutput)this.entryBS, this.valueOffset());
    }

    public void initValue(Data<?> value) {
        this.entryBytes.position(this.valueSizeOffset());
        this.initValSize(value.size());
        this.writeValue(value);
    }

    public void initValueWithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert (oldValueSize == value.size());
        this.initValSizeEqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        this.writeValue(value);
    }

    public boolean usedInit() {
        return this.used;
    }

    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
    }

    boolean entryRemovedOnThisIterationInit() {
        return this.entryRemovedOnThisIteration;
    }

    protected void initEntryRemovedOnThisIteration(boolean entryRemovedOnThisIteration) {
        this.entryRemovedOnThisIteration = entryRemovedOnThisIteration;
    }

    public void closeEntryRemovedOnThisIteration() {
        if (!this.entryRemovedOnThisIterationInit()) {
            return;
        }
        this.entryRemovedOnThisIteration = false;
    }

    public boolean theSegmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    @Override
    public void initTheSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeTheSegmentIndexDependants();
    }

    public int segmentIndex() {
        assert (this.theSegmentIndexInit()) : "TheSegmentIndex should be init";
        return this.segmentIndex;
    }

    public void closeTheSegmentIndex() {
        if (!this.theSegmentIndexInit()) {
            return;
        }
        this.closeTheSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeTheSegmentIndexDependants() {
        this.closeSegment();
        this.closeSegmentHashLookup();
        this.closeSegHeader();
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash h = this.h();
        long hashLookupOffset = h.segmentOffset(this.segmentIndex());
        long freeListOffset = hashLookupOffset + h.segmentHashLookupOuterSize;
        this.freeListBytes.storePositionAndSize(h.ms, freeListOffset, h.segmentFreeListInnerSize);
        this.freeList.reuse((Bytes)this.freeListBytes);
        this.entrySpaceOffset = freeListOffset + h.segmentFreeListOuterSize + (long)h.segmentEntrySpaceInnerOffset;
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public SingleThreadedDirectBitSet freeList() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.freeList;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeEntryOffset();
    }

    public boolean entryOffsetInit() {
        return this.keySizeOffset >= 0L;
    }

    public void initEntryOffset() {
        this.keySizeOffset = this.entrySpaceOffset() + this.pos() * this.h().chunkSize;
        this.entryBytes.limit(this.entryBytes.capacity());
        this.closeEntryOffsetDependants();
    }

    public long keySizeOffset() {
        if (!this.entryOffsetInit()) {
            this.initEntryOffset();
        }
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!this.entryOffsetInit()) {
            return;
        }
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1L;
    }

    public void closeEntryOffsetDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        this.entryBytes.position(this.keySizeOffset());
        this.h().keySizeMarshaller.writeSize(this.entryBytes, this.keySize());
        this.initKeyOffset(this.entryBytes.position());
        key.writeTo((RandomDataOutput)this.entryBS, this.keyOffset());
    }

    long entrySize() {
        return this.entryEnd() - this.keySizeOffset();
    }

    public void closeMapEntryStagesEntrySizeDependants() {
        this.closeTheEntrySizeInChunks();
    }

    public boolean theEntrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initTheEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initTheEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.theEntrySizeInChunksInit()) {
            this.initTheEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeTheEntrySizeInChunks() {
        if (!this.theEntrySizeInChunksInit()) {
            return;
        }
        this.entrySizeInChunks = 0;
    }

    public void copyExistingEntry(long newPos, long bytesToCopy) {
        long oldKeySizeOffset = this.keySizeOffset();
        long oldKeyOffset = this.keyOffset();
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset() + (oldKeyOffset - oldKeySizeOffset));
        this.entryBS.write(this.keySizeOffset(), (RandomDataInput)this.entryBS, oldKeySizeOffset, bytesToCopy);
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset() + (long)this.m().valueSizeMarshaller.sizeEncodingSize(newValue.size()) - this.keySizeOffset();
    }

    public void readExistingEntry(long pos) {
        this.initPos(pos);
        this.entryBytes.position(this.keySizeOffset());
        this.initKeySize(this.h().keySizeMarshaller.readSize(this.entryBytes));
        this.initKeyOffset(this.entryBytes.position());
    }

    public boolean segmentHashLookupInit() {
        return this.address >= 0L;
    }

    public void initSegmentHashLookup() {
        long hashLookupOffset = this.h().segmentOffset(this.segmentIndex());
        this.innerInitSegmentHashLookup(this.h().ms.address() + hashLookupOffset, this.h().segmentHashLookupCapacity, this.h().segmentHashLookupEntrySize, this.h().segmentHashLookupKeyBits, this.h().segmentHashLookupValueBits);
    }

    public void initSegmentHashLookup(long address, long capacity, int entrySize, int keyBits, int valueBits) {
        this.innerInitSegmentHashLookup(address, capacity, entrySize, keyBits, valueBits);
    }

    public int hashLookupEntrySize() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.hashLookupEntrySize;
    }

    public int keyBits() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.keyBits;
    }

    public long address() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.address;
    }

    public long capacityMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.capacityMask;
    }

    public long capacityMask2() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.capacityMask2;
    }

    public long entryMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.entryMask;
    }

    public long keyMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.keyMask;
    }

    public long valueMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.valueMask;
    }

    public void closeSegmentHashLookup() {
        if (!this.segmentHashLookupInit()) {
            return;
        }
        this.address = -1L;
    }

    public long readEntry(long pos) {
        return NativeBytes.UNSAFE.getLong(this.address() + pos);
    }

    public long step(long pos) {
        return (pos += (long)this.hashLookupEntrySize()) <= this.capacityMask2() ? pos : 0L;
    }

    public long stepBack(long pos) {
        return (pos -= (long)this.hashLookupEntrySize()) >= 0L ? pos : this.capacityMask2();
    }

    long indexToPos(long index) {
        return index * (long)this.hashLookupEntrySize();
    }

    public long maskUnsetKey(long key) {
        return (key &= this.keyMask()) != 0L ? key : this.keyMask();
    }

    long entry(long key, long value) {
        return key | value << this.keyBits();
    }

    public void writeEntryVolatile(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLongVolatile(null, this.address() + pos, entry);
    }

    public void clearHashLookup() {
        NativeBytes.UNSAFE.setMemory(this.address(), this.capacityMask2() + (long)this.hashLookupEntrySize(), (byte)0);
    }

    public long key(long entry) {
        return entry & this.keyMask();
    }

    public void writeEntry(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    void writeEntry(long pos, long prevEntry, long anotherEntry) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | anotherEntry & this.entryMask();
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    public long value(long entry) {
        return entry >>> this.keyBits() & this.valueMask();
    }

    public long hlPos(long key) {
        return this.indexToPos(key & this.capacityMask());
    }

    public void checkValueForPut(long value) {
        assert ((value & (this.valueMask() ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "Value out of range, was " + value;
    }

    public void putValueVolatile(long pos, long value) {
        this.checkValueForPut(value);
        long currentEntry = this.readEntry(pos);
        this.writeEntryVolatile(pos, currentEntry, this.key(currentEntry), value);
    }

    void clearEntry(long pos, long prevEntry) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    public boolean empty(long entry) {
        return (entry & this.entryMask()) == 0L;
    }

    public long remove(long posToRemove) {
        long entryToShift;
        long entryToRemove = this.readEntry(posToRemove);
        long posToShift = posToRemove;
        while (!this.empty(entryToShift = this.readEntry(posToShift = this.step(posToShift)))) {
            boolean cond2;
            long insertPos = this.hlPos(this.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.writeEntry(posToRemove, entryToRemove, entryToShift);
            posToRemove = posToShift;
            entryToRemove = entryToShift;
        }
        this.clearEntry(posToRemove, entryToRemove);
        return posToRemove;
    }

    void forEach(EntryConsumer action) {
        for (long pos = 0L; pos <= this.capacityMask2(); pos += (long)this.hashLookupEntrySize()) {
            long entry = this.readEntry(pos);
            if (this.empty(entry)) continue;
            action.accept(this.key(entry), this.value(entry));
        }
    }

    String hashLookupToString() {
        StringBuilder sb = new StringBuilder("{");
        this.forEach((key, value) -> sb.append(key).append('=').append(value).append(','));
        sb.append('}');
        return sb.toString();
    }

    public boolean segHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegHeader() {
        this.segmentHeaderAddress = this.h().ms.address() + this.h().segmentHeaderOffset(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegHeaderDependants();
    }

    public long segmentHeaderAddress() {
        if (!this.segHeaderInit()) {
            this.initSegHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segHeaderInit()) {
            this.initSegHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegHeader() {
        if (!this.segHeaderInit()) {
            return;
        }
        this.closeSegHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegHeaderDependants() {
        this.closeSegmentStagesTryFindInitLocksOfThisSegmentDependants();
        this.closeLocks();
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress(), nextPosToSearchFrom);
    }

    public void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + (long)chunks;
        if (nextPosToSearchFrom >= this.h().actualChunksPerSegment) {
            nextPosToSearchFrom = 0L;
        }
        this.nextPosToSearchFrom(nextPosToSearchFrom);
    }

    long nextPosToSearchFrom() {
        return this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress());
    }

    public long alloc(int chunks) {
        VanillaChronicleHash h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " entry size chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long ret = this.freeList().setNextNContinuousClearBits(this.nextPosToSearchFrom(), chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
            if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                this.freeList().clear(ret, h.actualChunksPerSegment);
            }
            if ((ret = this.freeList().setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                    this.freeList().clear(ret, h.actualChunksPerSegment);
                }
                if (chunks == 1) {
                    throw new IllegalStateException("Segment is full, no free entries found");
                }
                throw new IllegalStateException("Segment is full or has no ranges of " + chunks + " continuous free chunks");
            }
            this.updateNextPosToSearchFrom(ret, chunks);
        } else if (chunks == 1 || this.freeList().isSet(this.nextPosToSearchFrom())) {
            this.updateNextPosToSearchFrom(ret, chunks);
        }
        return ret;
    }

    public void initEntryAndKeyCopying(long entrySize, long bytesToCopy) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.copyExistingEntry(this.alloc(this.allocatedChunks()), bytesToCopy);
        this.incrementSegmentEntriesIfNeeded();
    }

    public void free(long fromPos, int chunks) {
        this.freeList().clear(fromPos, fromPos + (long)chunks);
        if (fromPos < this.nextPosToSearchFrom()) {
            this.nextPosToSearchFrom(fromPos);
        }
    }

    public final void freeExtraAllocatedChunks() {
        if (!this.m().constantlySizedEntry && this.m().couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.free(this.pos() + (long)this.entrySizeInChunks(), this.allocatedChunks() - this.entrySizeInChunks());
        } else {
            this.initTheEntrySizeInChunks(this.allocatedChunks());
        }
    }

    public void writeValueAndPutPos(Data<V> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.free(this.pos(), this.entrySizeInChunks());
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset());
        this.writeValueAndPutPos(newValue);
    }

    boolean tryFindInitLocksOfThisSegment(Object thisContext, int index) {
        CompiledMapIterationContext c = (CompiledMapIterationContext)this.contextAtIndexInChain(index);
        if (c.segmentHeader() != null && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.rootContextOnThisSegment() != null) {
            throw new IllegalStateException("Nested context not implemented yet");
        }
        return false;
    }

    public void closeSegmentStagesTryFindInitLocksOfThisSegmentDependants() {
        this.closeLocks();
    }

    public void deleted(long deleted) {
        this.segmentHeader().deleted(this.segmentHeaderAddress(), deleted);
    }

    public long deleted() {
        return this.segmentHeader().deleted(this.segmentHeaderAddress());
    }

    public void entries(long size) {
        this.segmentHeader().size(this.segmentHeaderAddress(), size);
    }

    public long entries() {
        return this.segmentHeader().size(this.segmentHeaderAddress());
    }

    @Override
    public long size() {
        return this.entries() - this.deleted();
    }

    public boolean locksInit() {
        return this.rootContextOnThisSegment != null;
    }

    void initLocks() {
        int i;
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(this, i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(this, i)) continue;
            return;
        }
        this.rootContextOnThisSegment = this;
        this.concurrentSameThreadContexts = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.nextNode = null;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    public CompiledMapIterationContext rootContextOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        if (this.rootContextOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.localLockState = null;
        this.rootContextOnThisSegment = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forEachRemoving(Predicate<? super MapEntry<K, V>> action) {
        this.innerUpdateLock.lock();
        try {
            long size = this.size();
            if (size == 0L) {
                boolean bl = true;
                return bl;
            }
            boolean interrupted = false;
            long startPos = 0L;
            while (!this.empty(this.readEntry(startPos))) {
                startPos = this.step(startPos);
            }
            this.initHashLookupPos(startPos);
            do {
                this.setHashLookupPosGuarded(this.step(this.hashLookupPos()));
                long entry = this.readEntry(this.hashLookupPos());
                if (this.empty(entry)) continue;
                this.readExistingEntry(this.value(entry));
                if (!this.entryIsPresent()) continue;
                this.initEntryRemovedOnThisIteration(false);
                if (!action.test(this)) {
                    interrupted = true;
                    break;
                }
                if (--size == 0L) break;
            } while (this.hashLookupPos() != startPos);
            boolean bl = !interrupted;
            return bl;
        }
        finally {
            this.innerReadLock.unlock();
            this.initEntryRemovedOnThisIteration(false);
        }
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.free(this.pos(), this.entrySizeInChunks());
        this.entries(this.entries() - 1L);
        this.incrementModCountGuarded();
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.initEntryRemovedOnThisIteration(true);
        this.innerWriteLock.lock();
        try {
            if (this.remove(this.hashLookupPos()) != this.hashLookupPos()) {
                this.setHashLookupPosGuarded(this.stepBack(this.hashLookupPos()));
            }
            this.innerRemoveEntryExceptHashLookupUpdate();
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        int newSizeInChunks;
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        long entryStartOffset = this.keySizeOffset();
        long newSizeOfEverythingBeforeValue = -1L;
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long newValueOffset = this.m().alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue);
            long newEntrySize = newValueOffset + newValue.size() - entryStartOffset;
            newSizeInChunks = this.m().inChunks(newEntrySize);
        } else {
            newSizeInChunks = this.entrySizeInChunks();
        }
        if (this.pos() + (long)newSizeInChunks < this.freeList().size() && this.freeList().allClear(this.pos(), this.pos() + (long)newSizeInChunks)) {
            this.freeList().set(this.pos(), this.pos() + (long)newSizeInChunks);
            this.innerWriteLock.lock();
            this.incrementSegmentEntriesIfNeeded();
            if (newValueSizeIsDifferent) {
                this.initValue(newValue);
            } else {
                this.writeValue(newValue);
            }
        } else {
            if (newValueSizeIsDifferent) {
                assert (newSizeOfEverythingBeforeValue >= 0L);
            } else {
                newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            }
            long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
            if (newValueSizeIsDifferent) {
                this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - entryStartOffset);
                this.initValue(newValue);
            } else {
                long oldValueSizeOffset = this.valueSizeOffset();
                long oldValueSize = this.valueSize();
                long oldValueOffset = this.valueOffset();
                this.initEntryAndKeyCopying(entrySize, this.valueOffset() - entryStartOffset);
                this.initValueWithoutSize(newValue, oldValueSizeOffset, oldValueSize, oldValueOffset);
            }
            this.freeExtraAllocatedChunks();
        }
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = (newValueOffset = m.alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue)) + newValue.size() - entryStartOffset);
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.freeList().allClear(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
                this.freeList().set(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks);
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeList().clear(this.pos() + (long)newSizeInChunks, this.pos() + (long)this.entrySizeInChunks());
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
        } else {
            this.writeValue(newValue);
        }
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.checkOnEachPublicOperation();
        try {
            this.innerDefaultReplaceValue(newValue);
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    public void clearSegment() {
        this.innerWriteLock.lock();
        this.clearHashLookup();
        this.freeList().clear();
        this.nextPosToSearchFrom(0L);
        this.entries(0L);
    }

    public void clear() {
        this.clearSegment();
    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.segmentHeader().tryWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.segmentHeader().tryWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().writeLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapIterationContext.this.localLockState().write;
        }

        @Override
        public void lock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().writeLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }
    }

    public class WrappedValueInstanceData
    extends CopyingInstanceData<V> {
        private WrappedValueInstanceData next;
        private V value;
        private boolean marshalled = false;
        private DirectBytes buf;

        public WrappedValueInstanceData getUnusedWrappedValueGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValue();
        }

        public WrappedValueInstanceData getUnusedWrappedValue() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceData();
            }
            return this.next.getUnusedWrappedValue();
        }

        boolean nextInit() {
            return true;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            CompiledMapIterationContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next != null) {
                this.next.closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        @Override
        public V instance() {
            return this.value();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mvi = CompiledMapIterationContext.this.valueMetaInterop(this.value());
            long size = mvi.size(CompiledMapIterationContext.this.valueInterop, this.value());
            this.buf = this.getBuffer(this.buf, size);
            mvi.write(CompiledMapIterationContext.this.valueInterop, (Bytes)this.buf, this.value());
            this.buf.flip();
            this.marshalled = true;
        }

        public DirectBytes buf() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buf;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public V getUsing(V usingValue) {
            this.buf().position(0L);
            return CompiledMapIterationContext.this.valueReader.read((Bytes)this.buf(), this.buf().limit(), usingValue);
        }

        @Override
        public DirectBytes buffer() {
            return this.buf();
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().updateLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().downgradeWriteToReadLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapIterationContext.this.localLockState().update;
        }

        @Override
        public void lock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().updateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                CompiledMapIterationContext.this.segmentHeader().readLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void lock() {
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                CompiledMapIterationContext.this.segmentHeader().readLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapIterationContext.this.localLockState().read;
        }

        @Override
        public void unlock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    return;
                }
                case READ_LOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().readUnlock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    break;
                }
                case UPDATE_LOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().updateUnlock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledMapIterationContext.this.segmentHeader().writeUnlock(CompiledMapIterationContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
            CompiledMapIterationContext.this.closeHashLookupPos();
            CompiledMapIterationContext.this.closePos();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapIterationContext.this.segmentHeader().tryReadLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock() {
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapIterationContext.this.segmentHeader().tryReadLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public class EntryValueBytesData
    extends AbstractData<V> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead = false;

        @Override
        public RandomDataInput bytes() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.entryBS;
        }

        @Override
        public long offset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            CompiledMapIterationContext.this.entryBytes.position(CompiledMapIterationContext.this.valueOffset());
            return CompiledMapIterationContext.this.valueReader.read(CompiledMapIterationContext.this.entryBytes, this.size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingValue);
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }
    }

    public class EntryKeyBytesData
    extends AbstractData<K> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        @Override
        public RandomDataInput bytes() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.entryBS;
        }

        @Override
        public long offset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keyOffset();
        }

        @Override
        public long size() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        private K innerGetUsing(K usingKey) {
            CompiledMapIterationContext.this.entryBytes.position(CompiledMapIterationContext.this.keyOffset());
            return CompiledMapIterationContext.this.keyReader.read(CompiledMapIterationContext.this.entryBytes, this.size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                return;
            }
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public K getUsing(K usingKey) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingKey);
        }
    }

    public class DeprecatedMapKeyContextOnIteration
    implements MapKeyContext<K, V> {
        @Override
        public void close() {
            throw new UnsupportedOperationException("close() is not supported during iteration");
        }

        @NotNull
        private UnsupportedOperationException unsupportedLocks() {
            return new UnsupportedOperationException("Lock operations are not supported (and not needed!) during iteration");
        }

        @Override
        @NotNull
        public InterProcessLock readLock() {
            throw this.unsupportedLocks();
        }

        @Override
        @NotNull
        public InterProcessLock writeLock() {
            throw this.unsupportedLocks();
        }

        @Override
        @NotNull
        public InterProcessLock updateLock() {
            throw this.unsupportedLocks();
        }

        @Override
        public V get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.value().get();
        }

        @Override
        @NotNull
        public K key() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.key().get();
        }

        @Override
        public boolean containsKey() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return true;
        }

        @Override
        public boolean put(V newValue) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            CompiledMapIterationContext.this.replaceValue(CompiledMapIterationContext.this, CompiledMapIterationContext.this.context().wrapValueAsValue(newValue));
            return true;
        }

        @Override
        @NotNull
        public Bytes entry() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.entryBytes;
        }

        @Override
        public boolean valueEqualTo(V value) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return Data.bytesEquivalent(CompiledMapIterationContext.this.entryValue, CompiledMapIterationContext.this.context().wrapValueAsValue(value));
        }

        @Override
        public boolean remove() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            CompiledMapIterationContext.this.remove(CompiledMapIterationContext.this);
            return true;
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.value().getUsing(usingValue);
        }

        @Override
        public long keyOffset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keyOffset();
        }

        @Override
        public long valueOffset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueOffset();
        }

        @Override
        public long valueSize() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueSize();
        }

        @Override
        public long keySize() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keySize();
        }
    }
}

