/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.bytes.ReadAccess;
import net.openhft.chronicle.hash.AbstractValue;
import net.openhft.chronicle.hash.impl.JavaLangBytesAccessors;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;

public abstract class CopyingInstanceValue<I, T>
extends AbstractValue<I, T> {
    public static DirectBytes getBuffer(DirectBytes b, long capacity) {
        if (b != null) {
            if (b.capacity() >= capacity) {
                return (DirectBytes)b.clear();
            }
            DirectStore store = (DirectStore)b.store();
            store.resize(capacity, false);
            return store.bytes();
        }
        return new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, Math.max(1L, capacity), true).bytes();
    }

    public abstract I instance();

    public abstract DirectBytes buffer();

    @Override
    public ReadAccess<T> access() {
        return (ReadAccess)JavaLangBytesAccessors.uncheckedBytesAccessor((Bytes)this.buffer()).access((Object)this.buffer());
    }

    @Override
    public T handle() {
        return (T)JavaLangBytesAccessors.uncheckedBytesAccessor((Bytes)this.buffer()).handle((Object)this.buffer());
    }

    @Override
    public long offset() {
        return JavaLangBytesAccessors.uncheckedBytesAccessor((Bytes)this.buffer()).offset((Object)this.buffer(), 0L);
    }

    @Override
    public long size() {
        return this.buffer().limit();
    }

    @Override
    public I get() {
        return this.instance();
    }
}

