/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.hash.Value;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapMethodsSupport;
import net.openhft.chronicle.map.MapQueryContext;
import net.openhft.chronicle.map.ReturnValue;

public interface MapMethods<K, V> {
    default public boolean containsKey(MapQueryContext<K, V> q) {
        return q.entry() != null;
    }

    default public void get(MapQueryContext<K, V> q, ReturnValue<? super V> returnValue) {
        MapMethodsSupport.returnCurrentValueIfPresent(q, returnValue);
    }

    default public boolean put(MapQueryContext<K, V> q, Value<V, ?> value, ReturnValue<? super V> returnValue) {
        q.updateLock().lock();
        MapEntry<K, V> entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
            return q.replaceValue(entry, value);
        }
        return q.insert(q.absentEntry(), value);
    }

    default public boolean putIfAbsent(MapQueryContext<K, V> q, Value<V, ?> value, ReturnValue<? super V> returnValue) {
        if (MapMethodsSupport.tryReturnCurrentValueIfPresent(q, returnValue)) {
            return false;
        }
        return q.insert(q.absentEntry(), value);
    }

    default public boolean acquireUsing(MapQueryContext<K, V> q, ReturnValue<? super V> returnValue) {
        if (MapMethodsSupport.tryReturnCurrentValueIfPresent(q, returnValue)) {
            return false;
        }
        Value<V, ?> defaultValue = q.defaultValue(q.absentEntry());
        boolean inserted = q.insert(q.absentEntry(), defaultValue);
        returnValue.returnValue(defaultValue);
        return inserted;
    }

    default public boolean remove(MapQueryContext<K, V> q, ReturnValue<? super V> returnValue) {
        q.updateLock().lock();
        MapEntry<K, V> entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
            return q.remove(entry);
        }
        return false;
    }

    default public boolean remove(MapQueryContext<K, V> q, Value<V, ?> value) {
        q.updateLock().lock();
        MapEntry<K, V> entry = q.entry();
        return entry != null && Value.bytesEquivalent(entry.value(), value) && q.remove(entry);
    }

    default public boolean replace(MapQueryContext<K, V> q, Value<V, ?> value, ReturnValue<? super V> returnValue) {
        q.updateLock().lock();
        MapEntry<K, V> entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
            return q.replaceValue(entry, value);
        }
        return false;
    }

    default public boolean replace(MapQueryContext<K, V> q, Value<V, ?> oldValue, Value<V, ?> newValue) {
        q.updateLock().lock();
        MapEntry<K, V> entry = q.entry();
        return entry != null && Value.bytesEquivalent(entry.value(), oldValue) && q.replaceValue(entry, newValue);
    }

    default public boolean compute(MapQueryContext<K, V> q, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Function<V, Value<V, ?>> newValueObjectToValue, ReturnValue<? super V> returnValue) {
        q.updateLock().lock();
        MapEntry<K, V> entry = q.entry();
        Object oldValue = entry != null ? (Object)entry.value().get() : null;
        V newValue = remappingFunction.apply(q.queriedKey().get(), oldValue);
        if (newValue != null) {
            Value<V, ?> newValueValue = newValueObjectToValue.apply(newValue);
            boolean updated = entry != null ? q.replaceValue(entry, newValueValue) : q.insert(q.absentEntry(), newValueValue);
            returnValue.returnValue(newValueValue);
            return updated;
        }
        if (entry != null) {
            return q.remove(entry);
        }
        return false;
    }

    default public boolean merge(MapQueryContext<K, V> q, Value<V, ?> value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Function<V, Value<V, ?>> newValueObjectToValue, ReturnValue<? super V> returnValue) {
        boolean updated;
        Value<V, ?> newValueValue;
        q.updateLock().lock();
        MapEntry<K, V> entry = q.entry();
        if (entry != null) {
            V oldValue = entry.value().get();
            V newValue = remappingFunction.apply(oldValue, value.get());
            if (newValue == null) {
                return q.remove(entry);
            }
            newValueValue = newValueObjectToValue.apply(newValue);
            updated = q.replaceValue(entry, newValueValue);
        } else {
            newValueValue = value;
            updated = q.insert(q.absentEntry(), newValueValue);
        }
        returnValue.returnValue(newValueValue);
        return updated;
    }
}

