/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.hash.HashContext;
import net.openhft.chronicle.hash.Value;
import net.openhft.chronicle.hash.replication.DefaultEventualConsistencyStrategy;
import net.openhft.chronicle.hash.replication.ReplicatedEntry;
import net.openhft.chronicle.hash.replication.ReplicationContext;
import net.openhft.chronicle.map.MapEntry;
import org.jetbrains.annotations.NotNull;

public interface MapEntryOperations<K, V> {
    public static boolean shouldModify(@NotNull MapEntry<?, ?> entry) {
        HashContext context = entry.context();
        return !(context instanceof ReplicationContext) || DefaultEventualConsistencyStrategy.shouldApplyRemoteModification((ReplicatedEntry)((Object)entry), (ReplicationContext)context);
    }

    default public boolean remove(@NotNull MapEntry<K, V> entry) {
        if (MapEntryOperations.shouldModify(entry)) {
            entry.doRemove();
            return true;
        }
        return false;
    }

    default public boolean replaceValue(@NotNull MapEntry<K, V> entry, Value<V, ?> newValue) {
        if (MapEntryOperations.shouldModify(entry)) {
            entry.doReplaceValue(newValue);
            return true;
        }
        return false;
    }
}

