/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.hashing.Hasher;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.lang.io.Bytes;

public enum CharArrayMarshaller implements BytesInterop<char[]>,
BytesReader<char[]>
{
    INSTANCE;


    @Override
    public boolean startsWith(Bytes bytes, char[] chars) {
        if (bytes.capacity() - bytes.position() < (long)chars.length * 2L) {
            return false;
        }
        long pos = bytes.position();
        for (int i = 0; i < chars.length; ++i) {
            if (bytes.readChar(pos + (long)i * 2L) == chars[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long hash(char[] chars) {
        return Hasher.hash(chars);
    }

    @Override
    public char[] read(Bytes bytes, long size) {
        char[] chars = new char[this.resLen(size)];
        bytes.readFully(chars);
        return chars;
    }

    @Override
    public char[] read(Bytes bytes, long size, char[] toReuse) {
        int resLen = this.resLen(size);
        if (toReuse == null || toReuse.length != resLen) {
            toReuse = new char[resLen];
        }
        bytes.readFully(toReuse);
        return toReuse;
    }

    private int resLen(long size) {
        long resLen = size / 2L;
        if (resLen < 0L || resLen > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("char[] size should be non-negative int, " + resLen + " given. Memory corruption?");
        }
        return (int)resLen;
    }

    @Override
    public long size(char[] chars) {
        return (long)chars.length * 2L;
    }

    @Override
    public void write(Bytes bytes, char[] chars) {
        bytes.write(chars);
    }
}

