/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.BufferUnderflowException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Set;
import net.openhft.chronicle.hash.replication.UdpTransportConfig;
import net.openhft.chronicle.map.AbstractChannelReplicator;
import net.openhft.chronicle.map.EntryReader;
import net.openhft.chronicle.map.EntryWriter;
import net.openhft.chronicle.map.Replica;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UdpChannelReplicator
extends AbstractChannelReplicator
implements Replica.ModificationNotifier,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)UdpChannelReplicator.class.getName());
    private final byte localIdentifier;
    private final InetAddress address;
    private final int port;
    private final NetworkInterface networkInterface;
    private final ServerConnector serverConnector;
    private final String name;
    private EntryWriter writer;
    private EntryReader reader;
    private SelectableChannel writeChannel;
    private volatile boolean shouldEnableOpWrite;

    UdpChannelReplicator(@NotNull UdpTransportConfig replicationConfig, byte localIdentifier) throws IOException {
        super("UdpReplicator-" + localIdentifier, replicationConfig.throttlingConfig());
        this.localIdentifier = localIdentifier;
        this.address = replicationConfig.address();
        this.port = replicationConfig.port();
        this.networkInterface = replicationConfig.networkInterface();
        this.name = replicationConfig.name();
        this.serverConnector = new ServerConnector();
    }

    void setWriter(EntryWriter writer) {
        this.writer = writer;
    }

    void setReader(EntryReader reader) {
        this.reader = reader;
    }

    @Override
    public void close() {
        super.close();
        this.writeChannel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void processEvent() {
        try {
            this.connectClient().register(this.selector, 1);
            this.serverConnector.connectLater();
            while (this.selector.isOpen()) {
                int i;
                this.registerPendingRegistrations();
                int n = this.selector.select(100L);
                if (this.shouldEnableOpWrite) {
                    this.enableWrites();
                }
                this.checkThrottleInterval();
                if (n == 0) continue;
                if (useJavaNIOSelectionKeys) {
                    Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
                    for (SelectionKey key : selectionKeys) {
                        this.processKey(key);
                    }
                    selectionKeys.clear();
                    continue;
                }
                SelectionKey[] keys = this.selectedKeys.flip();
                try {
                    for (i = 0; i < keys.length && keys[i] != null; ++i) {
                        SelectionKey key;
                        key = keys[i];
                        try {
                            this.processKey(key);
                            continue;
                        }
                        catch (BufferUnderflowException e) {
                            if (this.isClosed) continue;
                            LOG.error("", (Throwable)e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    for (int i2 = 0; i2 < keys.length && keys[i2] != null; ++i2) {
                        keys[i2] = null;
                    }
                    throw throwable;
                    return;
                }
                for (i = 0; i < keys.length && keys[i] != null; ++i) {
                    keys[i] = null;
                }
            }
        }
        catch (ConnectException | CancelledKeyException | ClosedChannelException | ClosedSelectorException e) {
            if (!LOG.isDebugEnabled()) return;
            LOG.debug("", (Throwable)e);
            return;
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return;
        }
        catch (Throwable e) {
            LOG.error("", e);
            throw e;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("closing name=" + this.name);
            }
            if (!this.isClosed) {
                this.closeResources();
            }
        }
    }

    private void processKey(SelectionKey key) {
        block9: {
            try {
                DatagramChannel socketChannel;
                if (key.isReadable()) {
                    socketChannel = (DatagramChannel)key.channel();
                    this.reader.readAll(socketChannel);
                }
                if (key.isWritable()) {
                    socketChannel = (DatagramChannel)key.channel();
                    try {
                        int bytesJustWritten = this.writer.writeAll(socketChannel);
                        this.contemplateThrottleWrites(bytesJustWritten);
                    }
                    catch (NotYetConnectedException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", (Throwable)e);
                        }
                        this.serverConnector.connectLater();
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("", (Throwable)e);
                        }
                        this.serverConnector.connectLater();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
                if (this.isClosed) break block9;
                this.closeEarlyAndQuietly(key.channel());
            }
        }
    }

    private DatagramChannel connectClient() throws IOException {
        DatagramChannel client = this.address.isMulticastAddress() ? DatagramChannel.open(this.address.getAddress().length == 4 ? StandardProtocolFamily.INET : StandardProtocolFamily.INET6) : DatagramChannel.open();
        InetSocketAddress hostAddress = new InetSocketAddress(this.port);
        client.configureBlocking(false);
        if (this.address.isMulticastAddress()) {
            client.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            client.bind(hostAddress);
            if (this.networkInterface != null) {
                client.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, this.networkInterface);
                client.join(this.address, this.networkInterface);
            } else {
                client.join(this.address, NetworkInterface.getByInetAddress(hostAddress.getAddress()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connecting via multicast, group=" + this.address);
            }
        } else {
            client.bind(hostAddress);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listening on port " + this.port);
        }
        this.closeables.add(client);
        return client;
    }

    @Override
    public void onChange() {
        this.shouldEnableOpWrite = true;
    }

    private void enableWrites() {
        if (this.writeChannel == null) {
            return;
        }
        try {
            SelectionKey selectionKey = this.writeChannel.keyFor(this.selector);
            if (selectionKey != null) {
                selectionKey.interestOps(selectionKey.interestOps() | 4);
            }
            this.shouldEnableOpWrite = false;
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    void disableWrites() {
        if (this.writeChannel == null) {
            return;
        }
        try {
            SelectionKey selectionKey = this.writeChannel.keyFor(this.selector);
            selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    private class ServerConnector
    extends AbstractChannelReplicator.AbstractConnector {
        private final InetSocketAddress socketAddress;

        private ServerConnector() {
            super("UDP-Connector");
            this.socketAddress = new InetSocketAddress(UdpChannelReplicator.this.address, UdpChannelReplicator.this.port);
        }

        @Override
        SelectableChannel doConnect() throws IOException, InterruptedException {
            final DatagramChannel server = DatagramChannel.open();
            server.configureBlocking(false);
            try {
                server.socket().setBroadcast(true);
                server.connect(this.socketAddress);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("details=" + new AbstractChannelReplicator.Details(this.socketAddress, UdpChannelReplicator.this.localIdentifier), (Throwable)e);
                }
                this.connectLater();
                return null;
            }
            ((DatagramChannel)((DatagramChannel)((DatagramChannel)server.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)false)).setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)true)).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            if (UdpChannelReplicator.this.networkInterface != null) {
                server.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, UdpChannelReplicator.this.networkInterface);
            }
            UdpChannelReplicator.this.addPendingRegistration(new Runnable(){

                @Override
                public void run() {
                    try {
                        server.register(UdpChannelReplicator.this.selector, 4);
                        UdpChannelReplicator.this.writeChannel = server;
                        UdpChannelReplicator.this.throttle(server);
                    }
                    catch (ClosedChannelException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
            });
            return server;
        }
    }
}

