/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.MultiMap;
import net.openhft.chronicle.map.MultiMapFactory;
import net.openhft.chronicle.map.SearchState;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;

class IntIntMultiMap
implements MultiMap {
    static final long MAX_CAPACITY = 0x100000000L;
    private static final long ENTRY_SIZE = 8L;
    private static final int ENTRY_SIZE_SHIFT = 3;
    private static final long UNSET_KEY = 0L;
    private static final long MASK = 0xFFFFFFFFL;
    private static final long HASH_INSTEAD_OF_UNSET_KEY = 0xFFFFFFFFL;
    private static final long UNSET_ENTRY = 0L;
    final DirectBitSet positions;
    private final long capacity;
    private final long capacityMask;
    private final long capacityMask2;
    private final Bytes bytes;

    public IntIntMultiMap(long minCapacity) {
        this.capacity = MultiMapFactory.multiMapCapacity(minCapacity);
        this.capacityMask = this.capacity - 1L;
        this.capacityMask2 = IntIntMultiMap.indexToPos(this.capacityMask);
        this.bytes = DirectStore.allocateLazy((long)IntIntMultiMap.indexToPos(this.capacity)).bytes();
        this.positions = MultiMapFactory.newPositions(this.capacity);
        this.clear();
    }

    public IntIntMultiMap(Bytes multiMapBytes, Bytes multiMapBitSetBytes) {
        this.capacity = multiMapBytes.capacity() / 8L;
        assert (Maths.isPowerOf2((long)this.capacity));
        assert (this.capacity / 2L <= 0x100000000L);
        this.capacityMask = this.capacity - 1L;
        this.capacityMask2 = IntIntMultiMap.indexToPos(this.capacityMask);
        this.bytes = multiMapBytes;
        this.positions = new ATSDirectBitSet(multiMapBitSetBytes);
    }

    public static long sizeInBytes(long minCapacity) {
        return IntIntMultiMap.indexToPos(MultiMapFactory.multiMapCapacity(minCapacity));
    }

    private static long indexToPos(long index) {
        return index << 3;
    }

    private static long maskUnsetKey(long key) {
        return (key &= 0xFFFFFFFFL) != 0L ? key : 0xFFFFFFFFL;
    }

    private void checkValueForPut(long value) {
        assert ((value & 0xFFFFFFFF00000000L) == 0L) : "Value out of range, was " + value;
        assert (this.positions.isClear(value)) : "Shouldn't put existing value";
    }

    private void checkValueForRemove(long value) {
        assert ((value & 0xFFFFFFFF00000000L) == 0L) : "Value out of range, was " + value;
        assert (this.positions.isSet(value)) : "Shouldn't remove absent value";
    }

    private static long key(long entry) {
        return entry >>> 32;
    }

    private static long value(long entry) {
        return entry & 0xFFFFFFFFL;
    }

    private static long entry(long key, long value) {
        return key << 32 | value;
    }

    private long pos(long key) {
        return IntIntMultiMap.indexToPos(key & this.capacityMask);
    }

    private long step(long pos) {
        return pos + 8L & this.capacityMask2;
    }

    private long stepBack(long pos) {
        return pos - 8L & this.capacityMask2;
    }

    @Override
    public void putPosition(long value) {
        this.checkValueForPut(value);
        this.positions.set(value);
    }

    @Override
    public void put(long key, long value) {
        key = IntIntMultiMap.maskUnsetKey(key);
        this.checkValueForPut(value);
        long pos = this.pos(key);
        while (true) {
            long entry;
            if ((entry = this.bytes.readLong(pos)) == 0L) {
                this.bytes.writeLong(pos, IntIntMultiMap.entry(key, value));
                this.positions.set(value);
                return;
            }
            pos = this.step(pos);
        }
    }

    @Override
    public void removePosition(long value) {
        this.checkValueForRemove(value);
        this.positions.clear(value);
    }

    @Override
    public void remove(long key, long value) {
        key = IntIntMultiMap.maskUnsetKey(key);
        this.checkValueForRemove(value);
        long pos = this.pos(key);
        while (true) {
            long entry;
            if (IntIntMultiMap.key(entry = this.bytes.readLong(pos)) == key && IntIntMultiMap.value(entry) == value) break;
            pos = this.step(pos);
        }
        long posToRemove = pos;
        this.positions.clear(value);
        this.removePos(posToRemove);
    }

    @Override
    public void replace(long key, long oldValue, long newValue) {
        key = IntIntMultiMap.maskUnsetKey(key);
        this.checkValueForRemove(oldValue);
        this.checkValueForPut(newValue);
        long pos = this.pos(key);
        while (true) {
            long entry;
            if (IntIntMultiMap.key(entry = this.bytes.readLong(pos)) == key && IntIntMultiMap.value(entry) == oldValue) {
                this.positions.clear(oldValue);
                this.positions.set(newValue);
                this.bytes.writeLong(pos, IntIntMultiMap.entry(key, newValue));
                return;
            }
            pos = this.step(pos);
        }
    }

    private void removePos(long posToRemove) {
        long entryToShift;
        long posToShift = posToRemove;
        while ((entryToShift = this.bytes.readLong(posToShift = this.step(posToShift))) != 0L) {
            boolean cond2;
            long insertPos = this.pos(IntIntMultiMap.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.bytes.writeLong(posToRemove, entryToShift);
            posToRemove = posToShift;
        }
        this.bytes.writeLong(posToRemove, 0L);
    }

    @Override
    public void startSearch(long key, SearchState searchStateToReuse) {
        key = IntIntMultiMap.maskUnsetKey(key);
        searchStateToReuse.searchPos = this.pos(key);
        searchStateToReuse.searchHash = key;
        searchStateToReuse.putAfterFailedSearch = false;
    }

    @Override
    public long nextPos(SearchState searchState) {
        long pos = searchState.searchPos;
        for (long count = this.capacity; count > 0L; --count) {
            long entry = this.bytes.readLong(pos);
            if (entry == 0L) {
                searchState.searchPos = pos;
                return -1L;
            }
            pos = this.step(pos);
            if (IntIntMultiMap.key(entry) != searchState.searchHash) continue;
            searchState.searchPos = pos;
            return IntIntMultiMap.value(entry);
        }
        throw new IllegalStateException();
    }

    @Override
    public void removePrevPos(SearchState searchState) {
        long prevPos = this.stepBack(searchState.searchPos);
        long entry = this.bytes.readLong(prevPos);
        this.positions.clear(IntIntMultiMap.value(entry));
        this.removePos(prevPos);
    }

    @Override
    public void replacePrevPos(SearchState searchState, long newValue, boolean oldValueInPositions) {
        this.checkValueForPut(newValue);
        long prevPos = searchState.searchPos;
        if (!searchState.putAfterFailedSearch) {
            prevPos = this.stepBack(prevPos);
        }
        if (oldValueInPositions) {
            long oldEntry = this.bytes.readLong(prevPos);
            long oldValue = IntIntMultiMap.value(oldEntry);
            this.checkValueForRemove(oldValue);
            this.positions.clear(oldValue);
        }
        this.positions.set(newValue);
        this.bytes.writeLong(prevPos, IntIntMultiMap.entry(searchState.searchHash, newValue));
    }

    @Override
    public void putAfterFailedSearch(SearchState searchState, long value) {
        this.checkValueForPut(value);
        this.positions.set(value);
        this.bytes.writeLong(searchState.searchPos, IntIntMultiMap.entry(searchState.searchHash, value));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        long i = 0L;
        long pos = 0L;
        while (i < this.capacity) {
            long entry = this.bytes.readLong(pos);
            if (entry != 0L) {
                sb.append(IntIntMultiMap.key(entry)).append('=').append(IntIntMultiMap.value(entry)).append(", ");
            }
            ++i;
            pos += 8L;
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
            return sb.append(" }").toString();
        }
        return "{ }";
    }

    @Override
    public void forEach(MultiMap.EntryConsumer action) {
        long i = 0L;
        long pos = 0L;
        while (i < this.capacity) {
            long entry = this.bytes.readLong(pos);
            if (entry != 0L) {
                action.accept(IntIntMultiMap.key(entry), IntIntMultiMap.value(entry));
            }
            ++i;
            pos += 8L;
        }
    }

    @Override
    public DirectBitSet getPositions() {
        return this.positions;
    }

    @Override
    public void clear() {
        this.positions.clear();
        this.bytes.zeroOut();
    }
}

