/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.ChronicleHash;
import net.openhft.chronicle.ChronicleHashBuilder;
import net.openhft.chronicle.ChronicleHashErrorListener;
import net.openhft.chronicle.TimeProvider;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChannelProvider;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.ReplicationConfig;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.DummyValue;
import net.openhft.chronicle.set.DummyValueMarshaller;
import net.openhft.chronicle.set.SetFromMap;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.NullObjectFactory;
import org.jetbrains.annotations.NotNull;

public class ChronicleSetBuilder<E>
implements ChronicleHashBuilder<E, ChronicleSet<E>, ChronicleSetBuilder<E>> {
    private ChronicleMapBuilder<E, DummyValue> chronicleMapBuilder;

    ChronicleSetBuilder(Class<E> keyClass) {
        this.chronicleMapBuilder = ChronicleMapBuilder.of(keyClass, DummyValue.class).entryAndValueAlignment(Alignment.NO_ALIGNMENT).valueMarshallerAndFactory(DummyValueMarshaller.INSTANCE, (ObjectFactory<DummyValue>)NullObjectFactory.of());
    }

    public static <K> ChronicleSetBuilder<K> of(Class<K> keyClass) {
        return new ChronicleSetBuilder<K>(keyClass);
    }

    @Override
    public ChronicleSetBuilder<E> clone() {
        try {
            ChronicleSetBuilder result = (ChronicleSetBuilder)super.clone();
            result.chronicleMapBuilder = this.chronicleMapBuilder.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ChronicleSetBuilder<E> actualSegments(int actualSegments) {
        this.chronicleMapBuilder.actualSegments(actualSegments);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> minSegments(int minSegments) {
        this.chronicleMapBuilder.minSegments(minSegments);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> actualEntriesPerSegment(int actualEntriesPerSegment) {
        this.chronicleMapBuilder.actualEntriesPerSegment(actualEntriesPerSegment);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> keySize(int keySize) {
        this.chronicleMapBuilder.keySize(keySize);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> constantKeySizeBySample(E sampleKey) {
        this.chronicleMapBuilder.constantKeySizeBySample((Object)sampleKey);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> entrySize(int entrySize) {
        this.chronicleMapBuilder.entrySize(entrySize);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> entries(long entries) {
        this.chronicleMapBuilder.entries(entries);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> lockTimeOut(long lockTimeOut, TimeUnit unit) {
        this.chronicleMapBuilder.lockTimeOut(lockTimeOut, unit);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> errorListener(ChronicleHashErrorListener errorListener) {
        this.chronicleMapBuilder.errorListener(errorListener);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> largeSegments(boolean largeSegments) {
        this.chronicleMapBuilder.largeSegments(largeSegments);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> metaDataBytes(int metaDataBytes) {
        this.chronicleMapBuilder.metaDataBytes(metaDataBytes);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> replicators(byte identifier, ReplicationConfig ... replicators) {
        this.chronicleMapBuilder.replicators(identifier, replicators);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> channel(ChannelProvider.ChronicleChannel chronicleChannel) {
        this.chronicleMapBuilder.channel(chronicleChannel);
        return this;
    }

    public String toString() {
        return " ChronicleSetBuilder{chronicleMapBuilder=" + this.chronicleMapBuilder + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChronicleSetBuilder)) {
            return false;
        }
        return this.chronicleMapBuilder.equals(((ChronicleSetBuilder)o).chronicleMapBuilder);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public ChronicleSetBuilder<E> timeProvider(TimeProvider timeProvider) {
        this.chronicleMapBuilder.timeProvider(timeProvider);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.chronicleMapBuilder.bytesMarshallerFactory(bytesMarshallerFactory);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> objectSerializer(ObjectSerializer objectSerializer) {
        this.chronicleMapBuilder.objectSerializer(objectSerializer);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> keyMarshaller(@NotNull BytesMarshaller<E> keyMarshaller) {
        this.chronicleMapBuilder.keyMarshaller((BytesMarshaller)keyMarshaller);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> immutableKeys() {
        this.chronicleMapBuilder.immutableKeys();
        return this;
    }

    @Override
    public ChronicleSet<E> create(File file) throws IOException {
        ChronicleHash map = this.chronicleMapBuilder.create(file);
        return new SetFromMap(map);
    }

    @Override
    public ChronicleSet<E> create() throws IOException {
        ChronicleHash map = this.chronicleMapBuilder.create();
        return new SetFromMap(map);
    }
}

