/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.hash.StatelessClientConfig;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.lang.MemoryUnit;

class StatelessMapConfig<K, V>
implements StatelessClientConfig<ChronicleMap<K, V>> {
    private final ChronicleMapBuilder<K, V> mapBuilder;
    private final InetSocketAddress remoteAddress;
    private final long timeoutMs;
    private final String name;
    private int tcpBufferSize = (int)MemoryUnit.KILOBYTES.toBytes(64L);
    private final AtomicBoolean used;

    StatelessMapConfig(ChronicleMapBuilder<K, V> mapBuilder, InetSocketAddress remoteAddress, long timeoutMs, String name, AtomicBoolean used) {
        this.mapBuilder = mapBuilder;
        this.remoteAddress = remoteAddress;
        this.timeoutMs = timeoutMs;
        this.name = name;
        this.used = used;
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }

    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public StatelessMapConfig<K, V> timeout(long timeout, TimeUnit units) {
        return new StatelessMapConfig<K, V>(this.mapBuilder, this.remoteAddress, units.toMillis(timeout), this.name, this.used);
    }

    @Override
    public StatelessClientConfig<ChronicleMap<K, V>> name(String name) {
        return new StatelessMapConfig<K, V>(this.mapBuilder, this.remoteAddress, this.timeoutMs, name, this.used);
    }

    String name() {
        return this.name;
    }

    @Override
    public ChronicleMap<K, V> create() throws IOException {
        if (!this.used.getAndSet(true)) {
            return this.mapBuilder.createStatelessClient(this);
        }
        throw new IllegalStateException("A stateless client has already been created using this config chain. Create a new StatelessClientConfig (builder.statelessClient()) to create a new stateless client");
    }

    public int tcpBufferSize() {
        return this.tcpBufferSize;
    }

    public StatelessMapConfig tcpBufferSize(int packetSize) {
        this.tcpBufferSize = packetSize;
        return this;
    }
}

