/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.xstreem.convertors.ByteBufferConverter;
import net.openhft.xstreem.convertors.ChronicleMapConverter;
import net.openhft.xstreem.convertors.DataValueConverter;

class JsonSerializer {
    JsonSerializer() {
    }

    static synchronized <K, V> void getAll(File toFile, Map<K, V> map) throws IOException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        xstream.setMode(1001);
        xstream.alias("cmap", VanillaChronicleMap.EntrySet.class);
        xstream.registerConverter(new ChronicleMapConverter<K, V>(map));
        xstream.registerConverter((Converter)new ByteBufferConverter());
        xstream.registerConverter((Converter)new DataValueConverter());
        OutputStream outputStream = new FileOutputStream(toFile);
        if (toFile.getName().toLowerCase().endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        try (FileOutputStream out = outputStream;){
            xstream.toXML(map.entrySet(), (OutputStream)out);
        }
    }

    static synchronized <K, V> void putAll(File fromFile, Map<K, V> map) throws IOException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        xstream.setMode(1001);
        xstream.alias("cmap", VanillaChronicleMap.EntrySet.class);
        xstream.registerConverter(new ChronicleMapConverter<K, V>(map));
        xstream.registerConverter((Converter)new ByteBufferConverter());
        xstream.registerConverter((Converter)new DataValueConverter());
        InputStream inputStream = new FileInputStream(fromFile);
        if (fromFile.getName().toLowerCase().endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        try (FileInputStream out = inputStream;){
            xstream.fromXML((InputStream)out);
        }
    }
}

