/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.UdpTransportConfig;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.StatelessServerConnector;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.UdpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import org.jetbrains.annotations.NotNull;

final class Replicators {
    static final String ONLY_UDP_WARN_MESSAGE = "MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should usethe UdpReplicator if you have a large number of nodes, and you wishto receive the data before it becomes available on TCP/IP. Since datadelivery is not guaranteed, it is recommended that you only usethe UDP Replicator in conjunction with a TCP Replicator";

    private Replicators() {
    }

    static Replicator tcp(final AbstractReplication replication) {
        return new Replicator(){

            @Override
            protected Closeable applyTo(@NotNull ChronicleMapBuilder builder, @NotNull Replica replica, @NotNull Replica.EntryExternalizable entryExternalizable, ChronicleMap chronicleMap) throws IOException {
                StatelessServerConnector statelessServer = new StatelessServerConnector(builder.keyBuilder, builder.valueBuilder, (VanillaChronicleMap)chronicleMap, builder.entrySize(true));
                TcpTransportAndNetworkConfig tcpConfig = replication.tcpTransportAndNetwork();
                assert (tcpConfig != null);
                return new TcpReplicator(replica, entryExternalizable, tcpConfig, builder.entrySize(true), statelessServer, replication.remoteNodeValidator());
            }
        };
    }

    static Replicator udp(final UdpTransportConfig replicationConfig) {
        return new Replicator(){

            @Override
            protected Closeable applyTo(@NotNull ChronicleMapBuilder builder, @NotNull Replica map, @NotNull Replica.EntryExternalizable entryExternalizable, ChronicleMap chronicleMap) throws IOException {
                return new UdpReplicator(map, entryExternalizable, replicationConfig, builder.entrySize(true));
            }
        };
    }
}

