/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashErrorListener;
import net.openhft.chronicle.hash.ChronicleHashErrorListeners;
import net.openhft.chronicle.hash.ChronicleHashInstanceConfig;
import net.openhft.chronicle.hash.StatelessClientConfig;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.ReplicationHub;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.BytesMapEventListener;
import net.openhft.chronicle.map.ChannelProvider;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.MapInstanceConfig;
import net.openhft.chronicle.map.MultiMapFactory;
import net.openhft.chronicle.map.NullValueProvider;
import net.openhft.chronicle.map.Objects;
import net.openhft.chronicle.map.PrepareValueBytes;
import net.openhft.chronicle.map.PrepareValueBytesAsWriter;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.Replicators;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.chronicle.map.StatelessMapConfig;
import net.openhft.chronicle.map.UdpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.ZeroOutValueBytes;
import net.openhft.lang.Maths;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.DataValueGenerator;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChronicleMapBuilder<K, V>
implements Cloneable,
ChronicleHashBuilder<K, ChronicleMap<K, V>, ChronicleMapBuilder<K, V>> {
    static final byte UDP_REPLICATION_MODIFICATION_ITERATOR_ID = -128;
    private static final int DEFAULT_KEY_OR_VALUE_SIZE = 120;
    private static final int MAX_SEGMENTS = 0x40000000;
    private static final int MAX_SEGMENTS_TO_CHAISE_COMPACT_MULTI_MAPS = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger((String)ChronicleMapBuilder.class.getName());
    public static final long DEFAULT_STATELESS_CLIENT_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    SerializationBuilder<K> keyBuilder;
    SerializationBuilder<V> valueBuilder;
    private String name;
    private int minSegments = -1;
    private int actualSegments = -1;
    private long actualEntriesPerSegment = -1L;
    private int keySize = 0;
    private K sampleKey;
    private int valueSize = 0;
    private V sampleValue;
    private int entrySize = 0;
    private int maxEntryOversizeFactor = -1;
    private Alignment alignment = null;
    private long entries = 0x100000L;
    private long lockTimeOut = 20000L;
    private TimeUnit lockTimeOutUnit = TimeUnit.MILLISECONDS;
    private int metaDataBytes = 0;
    private ChronicleHashErrorListener errorListener = ChronicleHashErrorListeners.logging();
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private TimeProvider timeProvider = TimeProvider.SYSTEM;
    private BytesMarshallerFactory bytesMarshallerFactory;
    private ObjectSerializer objectSerializer;
    private MapEventListener<K, V> eventListener = null;
    private BytesMapEventListener bytesEventListener = null;
    private V defaultValue = null;
    private DefaultValueProvider<K, V> defaultValueProvider = null;
    private PrepareValueBytes<K, V> prepareValueBytes = null;
    private SingleChronicleHashReplication singleHashReplication = null;
    private InetSocketAddress[] pushToAddresses;

    ChronicleMapBuilder(Class<K> keyClass, Class<V> valueClass) {
        this.keyBuilder = new SerializationBuilder<K>(keyClass, SerializationBuilder.Role.KEY);
        this.valueBuilder = new SerializationBuilder<V>(valueClass, SerializationBuilder.Role.VALUE);
    }

    public static <K, V> ChronicleMapBuilder<K, V> of(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        return new ChronicleMapBuilder<K, V>(keyClass, valueClass);
    }

    private static long roundUpMapHeaderSize(long headerSize) {
        long roundUp = headerSize + 127L & 0xFFFFFFFFFFFFFF80L;
        if (roundUp - headerSize < 64L) {
            roundUp += 128L;
        }
        return roundUp;
    }

    private static void checkSegments(int segments) {
        if (segments <= 0 || segments > 0x40000000) {
            throw new IllegalArgumentException("segments should be positive, " + segments + " given");
        }
        if (segments > 0x40000000) {
            throw new IllegalArgumentException("Max segments is 1073741824, " + segments + " given");
        }
    }

    private static long divideUpper(long dividend, long divisor) {
        return (dividend - 1L) / divisor + 1L;
    }

    private static String pretty(int value) {
        return value > 0 ? value + "" : "not configured";
    }

    private static String pretty(Object obj) {
        return obj != null ? obj + "" : "not configured";
    }

    public ChronicleMapBuilder<K, V> pushTo(InetSocketAddress ... addresses) {
        this.pushToAddresses = addresses;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> clone() {
        try {
            ChronicleMapBuilder result = (ChronicleMapBuilder)super.clone();
            result.keyBuilder = this.keyBuilder.clone();
            result.valueBuilder = this.valueBuilder.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ChronicleMapBuilder<K, V> keySize(int keySize) {
        ChronicleMapBuilder.checkSizeIsNotStaticallyKnown(this.keyBuilder);
        if (keySize <= 0) {
            throw new IllegalArgumentException("Key size must be positive");
        }
        this.keySize = keySize;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> constantKeySizeBySample(K sampleKey) {
        this.sampleKey = sampleKey;
        return this;
    }

    private int keySize() {
        return this.keyOrValueSize(this.keySize, this.keyBuilder);
    }

    public ChronicleMapBuilder<K, V> valueSize(int valueSize) {
        ChronicleMapBuilder.checkSizeIsNotStaticallyKnown(this.valueBuilder);
        if (valueSize <= 0) {
            throw new IllegalArgumentException("Value size must be positive");
        }
        this.valueSize = valueSize;
        return this;
    }

    private static void checkSizeIsNotStaticallyKnown(SerializationBuilder builder) {
        if (builder.sizeIsStaticallyKnown) {
            throw new IllegalStateException("Size of type " + builder.eClass + " is statically known and shouldn't be specified manually");
        }
    }

    public ChronicleMapBuilder<K, V> constantValueSizeBySample(V sampleValue) {
        this.sampleValue = sampleValue;
        return this;
    }

    int valueSize() {
        return this.keyOrValueSize(this.valueSize, this.valueBuilder);
    }

    private int keyOrValueSize(int configuredSize, SerializationBuilder builder) {
        if (configuredSize > 0) {
            return configuredSize;
        }
        if (builder.constantSizeMarshaller()) {
            return builder.pseudoReadConstantSize();
        }
        return 120;
    }

    @Override
    public ChronicleMapBuilder<K, V> entrySize(int entrySize) {
        if (this.keyBuilder.sizeIsStaticallyKnown && this.valueBuilder.sizeIsStaticallyKnown) {
            throw new IllegalStateException("Sizes of key type: " + this.keyBuilder.eClass + " and " + "value type: " + this.valueBuilder.eClass + " are both statically known, " + "so entry size shouldn't be specified manually");
        }
        if (entrySize <= 0) {
            throw new IllegalArgumentException("Entry Size must be positive");
        }
        this.entrySize = entrySize;
        return this;
    }

    int entrySize(boolean replicated) {
        if (this.entrySize > 0) {
            return this.entryAndValueAlignment().alignSize(this.entrySize);
        }
        int size = this.metaDataBytes;
        int keySize = this.keySize();
        size += this.keyBuilder.sizeMarshaller().sizeEncodingSize(keySize);
        size += keySize;
        if (replicated) {
            size += 10;
        }
        int valueSize = this.valueSize();
        size += this.valueBuilder.sizeMarshaller().sizeEncodingSize(valueSize);
        size = this.entryAndValueAlignment().alignSize(size);
        size += valueSize;
        for (int i = 1; i <= 4; ++i) {
            int bound = i * 64;
            if (size >= bound || bound - size > bound / 20) continue;
            size = bound;
            break;
        }
        return this.entryAndValueAlignment().alignSize(size);
    }

    @Override
    public ChronicleMapBuilder<K, V> maxEntryOversizeFactor(int maxEntryOversizeFactor) {
        if (maxEntryOversizeFactor < 1 || maxEntryOversizeFactor > 64) {
            throw new IllegalArgumentException("maxEntryOversizeFactor should be in [1, 64] range, " + maxEntryOversizeFactor + " given");
        }
        this.maxEntryOversizeFactor = maxEntryOversizeFactor;
        return this;
    }

    int maxEntryOversizeFactor() {
        if (this.maxEntryOversizeFactor < 0) {
            return this.keyBuilder.constantSizeMarshaller() && this.valueBuilder.constantSizeMarshaller() ? 1 : 64;
        }
        return this.maxEntryOversizeFactor;
    }

    public ChronicleMapBuilder<K, V> entryAndValueAlignment(Alignment alignment) {
        this.alignment = alignment;
        this.checkAlignmentOnlyIfValuesPossiblyReferenceOffHeap();
        return this;
    }

    private void checkAlignmentOnlyIfValuesPossiblyReferenceOffHeap() {
        if (!(this.valueBuilder.possibleOffHeapReferences() || this.alignment != Alignment.OF_4_BYTES && this.alignment != Alignment.OF_8_BYTES)) {
            throw new IllegalStateException("Entry and value alignment should be configured only if values might point to off-heap memory");
        }
    }

    Alignment entryAndValueAlignment() {
        if (this.alignment != null) {
            return this.alignment;
        }
        Class firstPrimitiveFieldType = DataValueGenerator.firstPrimitiveFieldType(this.valueBuilder.eClass);
        if (firstPrimitiveFieldType == Long.TYPE || firstPrimitiveFieldType == Double.TYPE) {
            return Alignment.OF_8_BYTES;
        }
        if (firstPrimitiveFieldType == Integer.TYPE || firstPrimitiveFieldType == Float.TYPE) {
            return Alignment.OF_4_BYTES;
        }
        return Alignment.NO_ALIGNMENT;
    }

    @Override
    public ChronicleMapBuilder<K, V> entries(long entries) {
        if (entries <= 0L) {
            throw new IllegalArgumentException("Entries should be positive, " + entries + " given");
        }
        this.entries = entries;
        return this;
    }

    long entries() {
        return this.entries;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualEntriesPerSegment(long actualEntriesPerSegment) {
        if (actualEntriesPerSegment <= 0L) {
            throw new IllegalArgumentException("entries per segment should be positive, " + actualEntriesPerSegment + " given");
        }
        if (this.tooManyEntriesPerSegment(actualEntriesPerSegment)) {
            throw new IllegalArgumentException("max entries per segment is 4294967296, " + actualEntriesPerSegment + " given");
        }
        this.actualEntriesPerSegment = actualEntriesPerSegment;
        return this;
    }

    private boolean tooManyEntriesPerSegment(long entriesPerSegment) {
        return entriesPerSegment > 0x100000000L;
    }

    long actualEntriesPerSegment() {
        if (this.actualEntriesPerSegment > 0L) {
            return this.actualEntriesPerSegment;
        }
        int actualSegments = this.actualSegments();
        long actualEntries = this.totalEntriesIfPoorDistribution(actualSegments);
        long actualEntriesPerSegment = ChronicleMapBuilder.divideUpper(actualEntries, actualSegments);
        if (this.tooManyEntriesPerSegment(actualEntriesPerSegment)) {
            throw new IllegalStateException("max entries per segment is 4294967296 configured entries() and actualSegments() so that there should be " + actualEntriesPerSegment + " entries per segment");
        }
        return actualEntriesPerSegment;
    }

    private long totalEntriesIfPoorDistribution(int segments) {
        if (segments == 1) {
            return this.entries;
        }
        double poorDistEntriesScale = Math.log(segments) * (double)this.entries;
        return Math.min(this.entries * (long)segments, (long)((double)this.entries + poorDistEntriesScale * 0.14 + 32.0));
    }

    @Override
    public ChronicleMapBuilder<K, V> minSegments(int minSegments) {
        ChronicleMapBuilder.checkSegments(minSegments);
        this.minSegments = minSegments;
        return this;
    }

    int minSegments() {
        return Math.max(this.estimateSegments(), this.minSegments);
    }

    private int estimateSegments() {
        return (int)Math.min(Maths.nextPower2((long)(this.entries / 32L), (long)1L), (long)this.estimateSegementBasedOnSize());
    }

    private int estimateSegementBasedOnSize() {
        long size = (long)(Math.log10(this.entrySize + 32) / 2.0 * (double)this.entries);
        if (size < 10000L) {
            return 512;
        }
        if (size < 100000L) {
            return 1024;
        }
        if (size < 1000000L) {
            return 2048;
        }
        if (size < 10000000L) {
            return 4096;
        }
        if (size < 100000000L) {
            return 8192;
        }
        return 16384;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualSegments(int actualSegments) {
        ChronicleMapBuilder.checkSegments(actualSegments);
        this.actualSegments = actualSegments;
        return this;
    }

    int actualSegments() {
        if (this.actualSegments > 0) {
            return this.actualSegments;
        }
        long shortMMapSegments = this.trySegments(65536L, 0x100000);
        if (shortMMapSegments > 0L) {
            return (int)shortMMapSegments;
        }
        long intMMapSegments = this.trySegments(0x100000000L, 0x40000000);
        if (intMMapSegments > 0L) {
            return (int)intMMapSegments;
        }
        throw new IllegalStateException("Max segments is 1073741824, configured so much entries() that builder automatically decided to use " + -intMMapSegments + " segments");
    }

    private long trySegments(long maxSegmentCapacity, int maxSegments) {
        long segments = ChronicleMapBuilder.divideUpper(this.totalEntriesIfPoorDistribution(this.minSegments()), maxSegmentCapacity);
        return (segments = Maths.nextPower2((long)Math.max(segments, (long)this.minSegments()), (long)1L)) <= (long)maxSegments ? segments : -segments;
    }

    int segmentHeaderSize() {
        int segments = this.actualSegments();
        return segments <= 16384 ? 64 : 32;
    }

    MultiMapFactory multiMapFactory() {
        return MultiMapFactory.forCapacity(this.actualEntriesPerSegment());
    }

    @Override
    public ChronicleMapBuilder<K, V> lockTimeOut(long lockTimeOut, TimeUnit unit) {
        this.lockTimeOut = lockTimeOut;
        this.lockTimeOutUnit = unit;
        return this;
    }

    long lockTimeOut(TimeUnit unit) {
        return unit.convert(this.lockTimeOut, this.lockTimeOutUnit);
    }

    @Override
    public ChronicleMapBuilder<K, V> errorListener(ChronicleHashErrorListener errorListener) {
        this.errorListener = errorListener;
        return this;
    }

    ChronicleHashErrorListener errorListener() {
        return this.errorListener;
    }

    public ChronicleMapBuilder<K, V> putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public ChronicleMapBuilder<K, V> removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Override
    public ChronicleMapBuilder<K, V> metaDataBytes(int metaDataBytes) {
        if (metaDataBytes < 0 || metaDataBytes > 255) {
            throw new IllegalArgumentException("MetaDataBytes must be [0..255] was " + metaDataBytes);
        }
        this.metaDataBytes = metaDataBytes;
        return this;
    }

    int metaDataBytes() {
        return this.metaDataBytes;
    }

    public String toString() {
        return "ChronicleMapBuilder{name=" + this.name + ", actualSegments=" + ChronicleMapBuilder.pretty(this.actualSegments) + ", minSegments=" + ChronicleMapBuilder.pretty(this.minSegments) + ", actualEntriesPerSegment=" + ChronicleMapBuilder.pretty(this.actualEntriesPerSegment) + ", keySize=" + ChronicleMapBuilder.pretty(this.keySize) + ", sampleKeyForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleKey) + ", valueSize=" + ChronicleMapBuilder.pretty(this.valueSize) + ", sampleValueForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleValue) + ", entrySize=" + ChronicleMapBuilder.pretty(this.entrySize) + ", entryAndValueAlignment=" + (Object)((Object)this.entryAndValueAlignment()) + ", entries=" + this.entries() + ", lockTimeOut=" + this.lockTimeOut + " " + (Object)((Object)this.lockTimeOutUnit) + ", metaDataBytes=" + this.metaDataBytes() + ", errorListener=" + this.errorListener() + ", putReturnsNull=" + this.putReturnsNull() + ", removeReturnsNull=" + this.removeReturnsNull() + ", timeProvider=" + this.timeProvider() + ", bytesMarshallerFactory=" + ChronicleMapBuilder.pretty(this.bytesMarshallerFactory) + ", objectSerializer=" + ChronicleMapBuilder.pretty(this.objectSerializer) + ", keyBuilder=" + this.keyBuilder + ", valueBuilder=" + this.valueBuilder + ", eventListener=" + this.eventListener + ", defaultValue=" + this.defaultValue + ", defaultValueProvider=" + ChronicleMapBuilder.pretty(this.defaultValueProvider) + ", prepareValueBytes=" + ChronicleMapBuilder.pretty(this.prepareValueBytes) + '}';
    }

    public boolean equals(Object o) {
        return Objects.builderEquals(this, o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public ChronicleMapBuilder<K, V> timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this;
    }

    TimeProvider timeProvider() {
        return this.timeProvider;
    }

    BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory == null ? (this.bytesMarshallerFactory = new VanillaBytesMarshallerFactory()) : this.bytesMarshallerFactory;
    }

    @Override
    public ChronicleMapBuilder<K, V> bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        return this;
    }

    ObjectSerializer acquireObjectSerializer(ObjectSerializer defaultSerializer) {
        return this.objectSerializer == null ? BytesMarshallableSerializer.create((BytesMarshallerFactory)this.bytesMarshallerFactory(), (ObjectSerializer)defaultSerializer) : this.objectSerializer;
    }

    @Override
    public ChronicleMapBuilder<K, V> objectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshaller(@NotNull BytesMarshaller<? super K> keyMarshaller) {
        this.keyBuilder.marshaller(keyMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshallers(@NotNull BytesWriter<K> keyWriter, @NotNull BytesReader<K> keyReader) {
        this.keyBuilder.writer(keyWriter);
        this.keyBuilder.reader(keyReader);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keySizeMarshaller(@NotNull SizeMarshaller keySizeMarshaller) {
        this.keyBuilder.sizeMarshaller(keySizeMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyDeserializationFactory(@NotNull ObjectFactory<K> keyDeserializationFactory) {
        this.keyBuilder.factory(keyDeserializationFactory);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> immutableKeys() {
        this.keyBuilder.instancesAreMutable(false);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueMarshaller(@NotNull BytesMarshaller<? super V> valueMarshaller) {
        this.valueBuilder.marshaller(valueMarshaller);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueMarshallers(@NotNull BytesWriter<V> valueWriter, @NotNull BytesReader<V> valueReader) {
        this.valueBuilder.writer(valueWriter);
        this.valueBuilder.reader(valueReader);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueSizeMarshaller(@NotNull SizeMarshaller valueSizeMarshaller) {
        this.valueBuilder.sizeMarshaller(valueSizeMarshaller);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueDeserializationFactory(@NotNull ObjectFactory<V> valueDeserializationFactory) {
        this.valueBuilder.factory(valueDeserializationFactory);
        return this;
    }

    public ChronicleMapBuilder<K, V> eventListener(MapEventListener<K, V> eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    MapEventListener<K, V> eventListener() {
        return this.eventListener;
    }

    public ChronicleMapBuilder<K, V> bytesEventListener(BytesMapEventListener eventListener) {
        this.bytesEventListener = eventListener;
        return this;
    }

    BytesMapEventListener bytesEventListener() {
        return this.bytesEventListener;
    }

    public ChronicleMapBuilder<K, V> defaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
        this.defaultValueProvider = null;
        if (defaultValue == null) {
            this.defaultValueProvider = NullValueProvider.INSTANCE;
        }
        this.prepareValueBytes = null;
        return this;
    }

    public ChronicleMapBuilder<K, V> defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        this.defaultValueProvider = defaultValueProvider;
        this.defaultValue = null;
        this.prepareValueBytes = null;
        return this;
    }

    public ChronicleMapBuilder<K, V> prepareDefaultValueBytes(@NotNull PrepareValueBytes<K, V> prepareValueBytes) {
        this.prepareValueBytes = prepareValueBytes;
        this.defaultValue = null;
        this.defaultValueProvider = null;
        this.checkPrepareValueBytesOnlyIfConstantValueSize();
        return this;
    }

    private void checkPrepareValueBytesOnlyIfConstantValueSize() {
        if (this.prepareValueBytes != null && !this.valueBuilder.constantSizeMarshaller()) {
            throw new IllegalStateException("Prepare value bytes could be used only if value size is constant");
        }
    }

    PrepareValueBytesAsWriter<K> prepareValueBytesAsWriter() {
        PrepareValueBytes<K, V> prepareValueBytes = this.prepareValueBytes;
        if (prepareValueBytes == null && this.defaultValueProvider() != null || !this.valueBuilder.constantSizeMarshaller()) {
            return null;
        }
        if (prepareValueBytes == null) {
            prepareValueBytes = new ZeroOutValueBytes(this.valueSize());
        }
        return new PrepareValueBytesAsWriter<K>(prepareValueBytes, this.valueSize());
    }

    DefaultValueProvider<K, V> defaultValueProvider() {
        if (this.defaultValueProvider != null) {
            return this.defaultValueProvider;
        }
        if (this.defaultValue == null) {
            return null;
        }
        Object originalValueWriter = this.valueBuilder.interop();
        Provider writerProvider = Provider.of(originalValueWriter.getClass());
        ThreadLocalCopies copies = writerProvider.getCopies(null);
        Object valueWriter = writerProvider.get(copies, originalValueWriter);
        MetaProvider<V, ?, MetaBytesInterop<V, ?>> metaWriterProvider = this.valueBuilder.metaInteropProvider();
        copies = metaWriterProvider.getCopies(copies);
        MetaBytesInterop<V, ?> metaValueWriter = metaWriterProvider.get(copies, this.valueBuilder.metaInterop(), valueWriter, this.defaultValue);
        return new ConstantValueProvider(this.defaultValue, metaValueWriter, valueWriter);
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(SingleChronicleHashReplication replication) {
        this.singleHashReplication = replication;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(byte identifier) {
        return this.replication(SingleChronicleHashReplication.builder().createWithId(identifier));
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        return this.replication(((SingleChronicleHashReplication.Builder)SingleChronicleHashReplication.builder().tcpTransportAndNetwork(tcpTransportAndNetwork)).createWithId(identifier));
    }

    @Override
    public ChronicleHashInstanceConfig<ChronicleMap<K, V>> instance() {
        return new MapInstanceConfig(this.clone(), this.singleHashReplication, null, null, null, new AtomicBoolean(false));
    }

    @Override
    public ChronicleMap<K, V> createStatelessClient(InetSocketAddress serverAddress) throws IOException {
        return this.statelessClient(serverAddress).create();
    }

    ChronicleMap<K, V> createStatelessClient(StatelessMapConfig<K, V> statelessClientConfig) throws IOException {
        this.pushingToMapEventListener();
        this.preMapConstruction(false);
        return new StatelessChronicleMap(statelessClientConfig, this);
    }

    @Override
    public ChronicleMap<K, V> createPersistedTo(File file) throws IOException {
        return ((ChronicleMapBuilder)this.clone()).createWithFile(file, this.singleHashReplication, null);
    }

    @Override
    public StatelessClientConfig<ChronicleMap<K, V>> statelessClient(InetSocketAddress remoteAddress) {
        return new StatelessMapConfig(this.clone(), remoteAddress, DEFAULT_STATELESS_CLIENT_TIMEOUT, null, new AtomicBoolean(false));
    }

    @Override
    public ChronicleMap<K, V> create() {
        return ((ChronicleMapBuilder)this.clone()).createWithoutFile(this.singleHashReplication, null);
    }

    ChronicleMap<K, V> create(MapInstanceConfig<K, V> ib) throws IOException {
        if (ib.file != null) {
            return this.createWithFile(ib.file, ib.singleHashReplication, ib.channel);
        }
        return this.createWithoutFile(ib.singleHashReplication, ib.channel);
    }

    /*
     * Exception decompiling
     */
    ChronicleMap<K, V> createWithFile(File file, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    ChronicleMap<K, V> createWithoutFile(SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) {
        try {
            this.pushingToMapEventListener();
            VanillaChronicleMap<K, ?, ?, V, ?, ?> map = this.newMap(singleHashReplication, channel);
            DirectStore bytesStore = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, map.sizeInBytes(), true);
            map.createMappedStoreAndSegments((BytesStore)bytesStore);
            return this.establishReplication(map, singleHashReplication, channel);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void pushingToMapEventListener() {
        if (this.pushToAddresses == null || this.pushToAddresses.length == 0) {
            return;
        }
        try {
            Class<?> pmel = Class.forName("com.higherfrequencytrading.chronicle.enterprise.map.PushingMapEventListener");
            Constructor<?> constructor = pmel.getConstructor(ChronicleMap[].class);
            ChronicleMap[] statelessClients = new ChronicleMap[this.pushToAddresses.length];
            Object cmb = this.clone();
            ((ChronicleMapBuilder)cmb).pushTo(null);
            for (int i = 0; i < this.pushToAddresses.length; ++i) {
                statelessClients[i] = ((ChronicleMapBuilder)cmb).createStatelessClient(this.pushToAddresses[i]);
            }
            this.eventListener = (MapEventListener)constructor.newInstance(new Object[]{statelessClients});
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getLogger((String)this.getClass().getName()).warn("Chronicle Enterprise not found in the class path");
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)this.getClass().getName()).error("PushingMapEventListener failed to load", (Throwable)e);
        }
    }

    private VanillaChronicleMap<K, ?, ?, V, ?, ?> newMap(SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        boolean replicated = singleHashReplication != null || channel != null;
        this.preMapConstruction(replicated);
        if (replicated) {
            AbstractReplication replication = singleHashReplication != null ? singleHashReplication : channel.hub();
            return new ReplicatedChronicleMap(this, replication);
        }
        return new VanillaChronicleMap(this);
    }

    void preMapConstruction(boolean replicated) {
        this.keyBuilder.objectSerializer(this.acquireObjectSerializer((ObjectSerializer)JDKObjectSerializer.INSTANCE));
        this.valueBuilder.objectSerializer(this.acquireObjectSerializer((ObjectSerializer)JDKObjectSerializer.INSTANCE));
        long maxSize = (long)this.entrySize(replicated) * (long)this.figureBufferAllocationFactor();
        this.keyBuilder.maxSize(maxSize);
        this.valueBuilder.maxSize(maxSize);
        if (this.sampleKey != null) {
            this.keyBuilder.constantSizeBySample(this.sampleKey);
        }
        if (this.sampleValue != null) {
            this.valueBuilder.constantSizeBySample(this.sampleValue);
        }
        this.stateChecks();
    }

    private void stateChecks() {
        this.checkAlignmentOnlyIfValuesPossiblyReferenceOffHeap();
        this.checkPrepareValueBytesOnlyIfConstantValueSize();
    }

    private ChronicleMap<K, V> establishReplication(VanillaChronicleMap<K, ?, ?, V, ?, ?> map, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        if (map instanceof ReplicatedChronicleMap) {
            if (singleHashReplication != null && channel != null) {
                throw new AssertionError((Object)"Only one non-null replication should be passed");
            }
            ReplicatedChronicleMap result = (ReplicatedChronicleMap)map;
            ArrayList<Replicator> replicators = new ArrayList<Replicator>(2);
            if (singleHashReplication != null) {
                if (singleHashReplication.tcpTransportAndNetwork() != null) {
                    replicators.add(Replicators.tcp(singleHashReplication));
                }
                if (singleHashReplication.udpTransport() != null) {
                    replicators.add(Replicators.udp(singleHashReplication.udpTransport()));
                }
            } else {
                ReplicationHub hub = channel.hub();
                int entrySize = this.entrySize(true);
                if (entrySize > hub.maxEntrySize()) {
                    throw new IllegalArgumentException("During ChannelProviderBuilder setup, maxEntrySize=" + hub.maxEntrySize() + " was specified, but map with " + "entrySize=" + entrySize + " is attempted to apply to the replicator");
                }
                ChannelProvider provider = ChannelProvider.getProvider(hub);
                ChannelProvider.ChronicleChannel ch = provider.createChannel(channel.channelId());
                replicators.add(ch);
            }
            for (Replicator replicator : replicators) {
                Closeable token = replicator.applyTo(this, result, result, map);
                if (replicators.size() == 1 && token.getClass() == UdpReplicator.class) {
                    LOG.warn("MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should usethe UdpReplicator if you have a large number of nodes, and you wishto receive the data before it becomes available on TCP/IP. Since datadelivery is not guaranteed, it is recommended that you only usethe UDP Replicator in conjunction with a TCP Replicator");
                }
                result.addCloseable(token);
            }
        }
        return map;
    }

    private int figureBufferAllocationFactor() {
        return (int)Math.min(Math.max(2L, this.entries() >> 10), 64L);
    }
}

