/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.hash.ChronicleHashInstanceConfig;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.map.AbstractChronicleMapBuilder;
import net.openhft.chronicle.map.ChronicleMap;

final class InstanceConfig<K, V>
implements ChronicleHashInstanceConfig<ChronicleMap<K, V>> {
    final AbstractChronicleMapBuilder<K, V, ?> mapBuilder;
    final SingleChronicleHashReplication singleHashReplication;
    final ReplicationChannel channel;
    final File file;
    private boolean used = false;

    InstanceConfig(AbstractChronicleMapBuilder<K, V, ?> mapBuilder, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel, File file) {
        this.mapBuilder = mapBuilder;
        this.singleHashReplication = singleHashReplication;
        this.channel = channel;
        this.file = file;
    }

    @Override
    public ChronicleHashInstanceConfig<ChronicleMap<K, V>> replicated(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        return this.replicated(((SingleChronicleHashReplication.Builder)SingleChronicleHashReplication.builder().tcpTransportAndNetwork(tcpTransportAndNetwork)).createWithId(identifier));
    }

    @Override
    public ChronicleHashInstanceConfig<ChronicleMap<K, V>> replicated(SingleChronicleHashReplication replication) {
        return new InstanceConfig<K, V>(this.mapBuilder, replication, null, this.file);
    }

    @Override
    public ChronicleHashInstanceConfig<ChronicleMap<K, V>> replicatedViaChannel(ReplicationChannel channel) {
        return new InstanceConfig<K, V>(this.mapBuilder, null, channel, this.file);
    }

    @Override
    public ChronicleHashInstanceConfig<ChronicleMap<K, V>> persistedTo(File file) {
        return new InstanceConfig<K, V>(this.mapBuilder, this.singleHashReplication, this.channel, file);
    }

    @Override
    public synchronized ChronicleMap<K, V> create() throws IOException {
        if (this.used) {
            throw new IllegalStateException("A ChronicleMap has already been created using this instance config. Create a new instance config (builder.instance() or call any configuration method on this instance config) to create a new ChronicleMap instance");
        }
        this.used = true;
        return this.mapBuilder.create(this);
    }
}

