/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.Hasher;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.values.LongValue;

public class LongValueKeyMarshaller
implements BytesInterop<LongValue>,
BytesReader<LongValue>,
SizeMarshaller {
    private static final long serialVersionUID = 0L;
    public static final LongValueKeyMarshaller INSTANCE = new LongValueKeyMarshaller();
    private static final Class<LongValue> heapLongValueClass = DataValueClasses.heapClassFor(LongValue.class);

    LongValueKeyMarshaller() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public long size(LongValue e) {
        return 8L;
    }

    @Override
    public int sizeEncodingSize(long size) {
        return 0;
    }

    @Override
    public void writeSize(Bytes bytes, long size) {
    }

    @Override
    public boolean startsWith(Bytes bytes, LongValue e) {
        return e.getValue() == bytes.readLong(0L);
    }

    @Override
    public long hash(LongValue e) {
        return Hasher.hash(e.getValue());
    }

    @Override
    public void write(Bytes bytes, LongValue e) {
        bytes.writeLong(e.getValue());
    }

    @Override
    public long readSize(Bytes bytes) {
        return 8L;
    }

    @Override
    public LongValue read(Bytes bytes, long size) {
        return this.read(bytes, size, null);
    }

    @Override
    public LongValue read(Bytes bytes, long size, LongValue toReuse) {
        if (toReuse == null || toReuse instanceof Byteable && ((Byteable)toReuse).bytes() == null) {
            try {
                toReuse = heapLongValueClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AssertionError((Object)e);
            }
        }
        toReuse.setValue(bytes.readLong());
        return toReuse;
    }
}

