/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.map.Function;
import net.openhft.chronicle.map.Mutator;
import net.openhft.chronicle.map.ReaderWithSize;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.Work;
import net.openhft.chronicle.map.WriterWithSize;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatelessServerConnector<K, V> {
    public static final int TRANSACTION_ID_OFFSET = 5;
    public static final boolean MAP_SUPPORTS_BYTES = true;
    private static final Logger LOG = LoggerFactory.getLogger((String)StatelessServerConnector.class.getName());
    public static final StatelessChronicleMap.EventId[] VALUES = StatelessChronicleMap.EventId.values();
    public static final int SIZE_OF_IS_EXCEPTION = 1;
    public static final int HEADER_SIZE = 13;
    private final ReaderWithSize<K> keyReaderWithSize;
    private final WriterWithSize<K> keyWriterWithSize;
    private final ReaderWithSize<V> valueReaderWithSize;
    private final WriterWithSize<V> valueWriterWithSize;
    private final VanillaChronicleMap<K, ?, ?, V, ?, ?> map;
    private double maxEntrySizeBytes;

    StatelessServerConnector(SerializationBuilder<K> keySerializationBuilder, SerializationBuilder<V> valueSerializationBuilder, @NotNull VanillaChronicleMap<K, ?, ?, V, ?, ?> map, int maxEntrySizeBytes) {
        this.keyReaderWithSize = new ReaderWithSize<K>(keySerializationBuilder);
        this.keyWriterWithSize = new WriterWithSize<K>(keySerializationBuilder);
        this.valueReaderWithSize = new ReaderWithSize<V>(valueSerializationBuilder);
        this.valueWriterWithSize = new WriterWithSize<V>(valueSerializationBuilder);
        this.map = map;
        this.maxEntrySizeBytes = maxEntrySizeBytes;
    }

    Work processStatelessEvent(byte eventId, @NotNull Bytes writer, @NotNull ByteBufferBytes reader) {
        StatelessChronicleMap.EventId event = VALUES[eventId];
        switch (event) {
            case KEY_SET: {
                return this.keySet((Bytes)reader, writer);
            }
            case VALUES: {
                return this.values((Bytes)reader, writer);
            }
            case ENTRY_SET: {
                return this.entrySet((Bytes)reader, writer);
            }
            case PUT_WITHOUT_ACC: {
                return this.put((Bytes)reader);
            }
            case PUT_ALL_WITHOUT_ACC: {
                return this.putAll((Bytes)reader);
            }
            case REMOVE_WITHOUT_ACC: {
                return this.remove((Bytes)reader);
            }
        }
        long sizeLocation = this.reflectTransactionId((Bytes)reader, writer);
        switch (event) {
            case LONG_SIZE: {
                return this.longSize((Bytes)reader, writer, sizeLocation);
            }
            case IS_EMPTY: {
                return this.isEmpty((Bytes)reader, writer, sizeLocation);
            }
            case CONTAINS_KEY: {
                return this.containsKey((Bytes)reader, writer, sizeLocation);
            }
            case CONTAINS_VALUE: {
                return this.containsValue((Bytes)reader, writer, sizeLocation);
            }
            case GET: {
                return this.get((Bytes)reader, writer, sizeLocation);
            }
            case PUT: {
                return this.put((Bytes)reader, writer, sizeLocation);
            }
            case REMOVE: {
                return this.remove((Bytes)reader, writer, sizeLocation);
            }
            case CLEAR: {
                return this.clear((Bytes)reader, writer, sizeLocation);
            }
            case REPLACE: {
                return this.replace((Bytes)reader, writer, sizeLocation);
            }
            case REPLACE_WITH_OLD_AND_NEW_VALUE: {
                return this.replaceWithOldAndNew((Bytes)reader, writer, sizeLocation);
            }
            case PUT_IF_ABSENT: {
                return this.putIfAbsent((Bytes)reader, writer, sizeLocation);
            }
            case REMOVE_WITH_VALUE: {
                return this.removeWithValue((Bytes)reader, writer, sizeLocation);
            }
            case TO_STRING: {
                return this.toString((Bytes)reader, writer, sizeLocation);
            }
            case PUT_ALL: {
                return this.putAll((Bytes)reader, writer, sizeLocation);
            }
            case HASH_CODE: {
                return this.hashCode((Bytes)reader, writer, sizeLocation);
            }
            case MAP_FOR_KEY: {
                return this.mapForKey(reader, writer, sizeLocation);
            }
            case UPDATE_FOR_KEY: {
                return this.updateForKey(reader, writer, sizeLocation);
            }
        }
        throw new IllegalStateException("unsupported event=" + (Object)((Object)event));
    }

    public Work mapForKey(ByteBufferBytes reader, Bytes writer, long sizeLocation) {
        K key = this.keyReaderWithSize.read((Bytes)reader, null);
        Function function = (Function)reader.readObject();
        try {
            Object result = this.map.mapForKey(key, function);
            writer.writeObject(result);
        }
        catch (Throwable e) {
            LOG.info("", e);
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    public Work updateForKey(ByteBufferBytes reader, Bytes writer, long sizeLocation) {
        K key = this.keyReaderWithSize.read((Bytes)reader, null);
        Mutator mutator = (Mutator)reader.readObject();
        try {
            Object result = this.map.updateForKey(key, mutator);
            writer.writeObject(result);
        }
        catch (Throwable e) {
            LOG.info("", e);
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work removeWithValue(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            writer.writeBoolean(this.map.removeWithValue(reader));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work replaceWithOldAndNew(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            this.map.replaceWithOldAndNew(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work longSize(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            writer.writeLong(this.map.longSize());
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work hashCode(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            writer.writeInt(this.map.hashCode());
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work toString(Bytes reader, Bytes writer, long sizeLocation) {
        String str;
        long remaining = writer.remaining();
        try {
            str = this.map.toString();
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        assert (remaining > 4L);
        String result = (long)str.length() < remaining ? str : str.substring(0, (int)(remaining - 4L)) + "...";
        writer.writeObject((Object)result);
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work sendException(Bytes writer, long sizeLocation, Throwable e) {
        writer.position(sizeLocation + 13L);
        this.writeException(writer, e);
        this.writeSizeAndFlags(sizeLocation, true, writer);
        return null;
    }

    private Work isEmpty(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            writer.writeBoolean(this.map.isEmpty());
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work containsKey(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            writer.writeBoolean(this.map.containsKey(reader));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work containsValue(Bytes reader, Bytes writer, long sizeLocation) {
        V v = this.valueReaderWithSize.read(reader, null);
        try {
            writer.writeBoolean(this.map.containsValue(v));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work get(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            this.map.get(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work put(Bytes reader) {
        this.map.put(reader);
        return null;
    }

    private Work put(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            this.map.put(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work remove(Bytes reader) {
        this.map.removeKeyAsBytes(reader);
        return null;
    }

    private Work remove(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            this.map.remove(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work putAll(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            this.map.putAll(reader);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work putAll(Bytes reader) {
        this.map.putAll(reader);
        return null;
    }

    private Work clear(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            this.map.clear();
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work values(Bytes reader, Bytes writer) {
        Collection values;
        final long transactionId = reader.readLong();
        try {
            values = this.map.values();
        }
        catch (Throwable e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator iterator = values.iterator();
        return new Work(){

            @Override
            public boolean doWork(Bytes out) {
                long sizeLocation = StatelessServerConnector.this.header(out, transactionId);
                ThreadLocalCopies copies = StatelessServerConnector.this.valueWriterWithSize.getCopies(null);
                Object valueWriter = StatelessServerConnector.this.valueWriterWithSize.writerForLoop(copies);
                int count = 0;
                while (iterator.hasNext()) {
                    if ((double)out.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                        StatelessServerConnector.this.writeHeader(out, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    StatelessServerConnector.this.valueWriterWithSize.writeInLoop(out, iterator.next(), valueWriter, copies);
                }
                StatelessServerConnector.this.writeHeader(out, sizeLocation, count, false);
                return true;
            }
        };
    }

    private Work keySet(Bytes reader, Bytes writer) {
        Set ks;
        final long transactionId = reader.readLong();
        try {
            ks = this.map.keySet();
        }
        catch (Throwable e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator iterator = ks.iterator();
        return new Work(){

            @Override
            public boolean doWork(Bytes out) {
                long sizeLocation = StatelessServerConnector.this.header(out, transactionId);
                ThreadLocalCopies copies = StatelessServerConnector.this.keyWriterWithSize.getCopies(null);
                Object keyWriter = StatelessServerConnector.this.keyWriterWithSize.writerForLoop(copies);
                int count = 0;
                while (iterator.hasNext()) {
                    if ((double)out.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                        StatelessServerConnector.this.writeHeader(out, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    Object key = iterator.next();
                    StatelessServerConnector.this.keyWriterWithSize.writeInLoop(out, key, keyWriter, copies);
                }
                StatelessServerConnector.this.writeHeader(out, sizeLocation, count, false);
                return true;
            }
        };
    }

    private Work entrySet(Bytes reader, Bytes writer) {
        Set<Map.Entry<K, V>> entries;
        final long transactionId = reader.readLong();
        try {
            entries = this.map.entrySet();
        }
        catch (Throwable e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator<Map.Entry<K, V>> iterator = entries.iterator();
        return new Work(){

            @Override
            public boolean doWork(Bytes out) {
                if ((double)out.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                    return false;
                }
                long sizeLocation = StatelessServerConnector.this.header(out, transactionId);
                ThreadLocalCopies copies = StatelessServerConnector.this.keyWriterWithSize.getCopies(null);
                Object keyWriter = StatelessServerConnector.this.keyWriterWithSize.writerForLoop(copies);
                copies = StatelessServerConnector.this.valueWriterWithSize.getCopies(copies);
                Object valueWriter = StatelessServerConnector.this.valueWriterWithSize.writerForLoop(copies);
                int count = 0;
                while (iterator.hasNext()) {
                    if ((double)out.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                        StatelessServerConnector.this.writeHeader(out, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    Map.Entry next = (Map.Entry)iterator.next();
                    StatelessServerConnector.this.keyWriterWithSize.writeInLoop(out, next.getKey(), keyWriter, copies);
                    StatelessServerConnector.this.valueWriterWithSize.writeInLoop(out, next.getValue(), valueWriter, copies);
                }
                StatelessServerConnector.this.writeHeader(out, sizeLocation, count, false);
                return true;
            }
        };
    }

    private Work putIfAbsent(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            this.map.putIfAbsent(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work replace(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            this.map.replaceKV(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private long reflectTransactionId(Bytes reader, Bytes writer) {
        long sizeLocation = writer.position();
        writer.skip(5L);
        long transactionId = reader.readLong();
        writer.writeLong(transactionId);
        return sizeLocation;
    }

    private void writeSizeAndFlags(long locationOfSize, boolean isException, Bytes out) {
        long size = out.position() - locationOfSize;
        out.writeInt(locationOfSize, (int)size);
        out.writeBoolean(locationOfSize + 4L, isException);
    }

    private void writeException(Bytes out, Throwable e) {
        out.writeObject((Object)e);
    }

    private Map<K, V> readEntries(Bytes reader) {
        long numberOfEntries = reader.readStopBit();
        HashMap<K, V> result = new HashMap<K, V>();
        ThreadLocalCopies copies = this.keyReaderWithSize.getCopies(null);
        BytesReader<K> keyReader = this.keyReaderWithSize.readerForLoop(copies);
        copies = this.valueReaderWithSize.getCopies(copies);
        BytesReader<V> valueReader = this.valueReaderWithSize.readerForLoop(copies);
        for (long i = 0L; i < numberOfEntries; ++i) {
            K key = this.keyReaderWithSize.readInLoop(reader, keyReader);
            V value = this.valueReaderWithSize.readInLoop(reader, valueReader);
            result.put(key, value);
        }
        return result;
    }

    private Work sendException(Bytes reader, Bytes writer, Throwable e) {
        long sizeLocation = this.reflectTransactionId(reader, writer);
        return this.sendException(writer, sizeLocation, e);
    }

    private long header(Bytes writer, long transactionId) {
        long sizeLocation = writer.position();
        writer.skip(5L);
        writer.writeLong(transactionId);
        writer.skip(1L);
        writer.skip(4L);
        return sizeLocation;
    }

    private void writeHeader(Bytes writer, long sizeLocation, int count, boolean hasAnotherChunk) {
        long end = writer.position();
        int size = (int)(end - sizeLocation);
        writer.position(sizeLocation);
        writer.writeInt(size);
        writer.writeBoolean(false);
        writer.skip(8L);
        writer.writeBoolean(hasAnotherChunk);
        writer.writeInt(count);
        writer.position(end);
    }
}

