/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import com.sun.jdi.connect.spi.ClosedConnectionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.RemoteCallTimeoutException;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.map.AbstractChannelReplicator;
import net.openhft.chronicle.map.AbstractChronicleMapBuilder;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.CloseablesManager;
import net.openhft.chronicle.map.Function;
import net.openhft.chronicle.map.IORuntimeException;
import net.openhft.chronicle.map.Mutator;
import net.openhft.chronicle.map.ReadContext;
import net.openhft.chronicle.map.ReaderWithSize;
import net.openhft.chronicle.map.StatelessMapConfig;
import net.openhft.chronicle.map.WriteContext;
import net.openhft.chronicle.map.WriterWithSize;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.thread.NamedThreadFactory;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatelessChronicleMap<K, V>
implements ChronicleMap<K, V>,
Closeable,
Cloneable {
    public static final String START_OF = "Attempt to write ";
    private static final Logger LOG = LoggerFactory.getLogger(StatelessChronicleMap.class);
    public static final byte STATELESS_CLIENT_IDENTIFIER = -127;
    private final byte[] connectionByte = new byte[1];
    private final ByteBuffer connectionOutBuffer = ByteBuffer.wrap(this.connectionByte);
    private final String name;
    private final AbstractChronicleMapBuilder chronicleMapBuilder;
    private ByteBuffer buffer;
    private ByteBufferBytes bytes;
    private final ReaderWithSize<K> keyReaderWithSize;
    private final WriterWithSize<K> keyWriterWithSize;
    private final ReaderWithSize<V> valueReaderWithSize;
    private final WriterWithSize<V> valueWriterWithSize;
    private volatile SocketChannel clientChannel;
    private CloseablesManager closeables;
    private final StatelessMapConfig config;
    private int maxEntrySize;
    private final Class<K> kClass;
    private final Class<V> vClass;
    private final boolean putReturnsNull;
    private final boolean removeReturnsNull;
    private ExecutorService executorService;
    private long transactionID;

    StatelessChronicleMap(StatelessMapConfig config, AbstractChronicleMapBuilder chronicleMapBuilder) throws IOException {
        this.chronicleMapBuilder = chronicleMapBuilder;
        this.config = config;
        this.keyReaderWithSize = new ReaderWithSize(chronicleMapBuilder.keyBuilder);
        this.keyWriterWithSize = new WriterWithSize(chronicleMapBuilder.keyBuilder);
        this.valueReaderWithSize = new ReaderWithSize(chronicleMapBuilder.valueBuilder);
        this.valueWriterWithSize = new WriterWithSize(chronicleMapBuilder.valueBuilder);
        this.putReturnsNull = chronicleMapBuilder.putReturnsNull();
        this.removeReturnsNull = chronicleMapBuilder.removeReturnsNull();
        this.maxEntrySize = chronicleMapBuilder.entrySize(true);
        if (this.maxEntrySize < 128) {
            this.maxEntrySize = 128;
        }
        this.vClass = chronicleMapBuilder.valueBuilder.eClass;
        this.kClass = chronicleMapBuilder.keyBuilder.eClass;
        this.name = chronicleMapBuilder.name();
        this.attemptConnect(config.remoteAddress());
        this.buffer = ByteBuffer.allocateDirect(this.maxEntrySize).order(ByteOrder.nativeOrder());
        this.bytes = new ByteBufferBytes(this.buffer.slice());
    }

    @Override
    public Future<V> getLater(final @NotNull K key) {
        return this.lazyExecutorService().submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return StatelessChronicleMap.this.get(key);
            }
        });
    }

    @Override
    public Future<V> putLater(final @NotNull K key, final @NotNull V value) {
        return this.lazyExecutorService().submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                Object oldValue = StatelessChronicleMap.this.put(key, value);
                return oldValue;
            }
        });
    }

    @Override
    public Future<V> removeLater(final @NotNull K key) {
        return this.lazyExecutorService().submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                Object oldValue = StatelessChronicleMap.this.remove(key);
                return oldValue;
            }
        });
    }

    @Override
    public void getAll(File toFile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(File fromFile) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService lazyExecutorService() {
        if (this.executorService == null) {
            StatelessChronicleMap statelessChronicleMap = this;
            synchronized (statelessChronicleMap) {
                if (this.executorService == null) {
                    this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(this.chronicleMapBuilder.name() + "-stateless-client-async", Boolean.valueOf(true)));
                }
            }
        }
        return this.executorService;
    }

    private SocketChannel lazyConnect(long timeoutMs, InetSocketAddress remoteAddress) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("attempting to connect to " + remoteAddress);
        }
        SocketChannel result = null;
        long timeoutAt = System.currentTimeMillis() + timeoutMs;
        while (true) {
            this.checkTimeout(timeoutAt);
            this.closeExisting();
            try {
                result = AbstractChannelReplicator.openSocketChannel(this.closeables);
                result.connect(this.config.remoteAddress());
                result.socket().setTcpNoDelay(true);
                this.doHandShaking(result);
            }
            catch (IOException e) {
                this.closeables.closeQuietly();
                continue;
            }
            catch (Exception e) {
                this.closeables.closeQuietly();
                throw e;
            }
            break;
        }
        return result;
    }

    private void attemptConnect(InetSocketAddress remoteAddress) throws IOException {
        this.closeExisting();
        try {
            this.clientChannel = AbstractChannelReplicator.openSocketChannel(this.closeables);
            this.clientChannel.connect(remoteAddress);
            this.doHandShaking(this.clientChannel);
        }
        catch (IOException e) {
            this.closeables.closeQuietly();
        }
    }

    private void closeExisting() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = new CloseablesManager();
    }

    private void doHandShaking(@NotNull SocketChannel clientChannel) throws IOException {
        this.connectionByte[0] = -127;
        this.connectionOutBuffer.clear();
        long timeoutTime = System.currentTimeMillis() + this.config.timeoutMs();
        while (this.connectionOutBuffer.hasRemaining()) {
            clientChannel.write(this.connectionOutBuffer);
            this.checkTimeout(timeoutTime);
        }
        this.connectionOutBuffer.clear();
        while (this.connectionOutBuffer.position() <= 0) {
            clientChannel.read(this.connectionOutBuffer);
            this.checkTimeout(timeoutTime);
        }
        byte remoteIdentifier = this.connectionByte[0];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attached to a map with a remote identifier=" + remoteIdentifier);
        }
    }

    @Override
    public File file() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void close() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = null;
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(20L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private long nextUniqueTransaction(long time) {
        this.transactionID = time == this.transactionID ? time + 1L : time;
        return this.transactionID;
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        long sizeLocation = this.writeEventAnSkip(EventId.PUT_IF_ABSENT);
        ThreadLocalCopies copies = this.writeKey(key);
        copies = this.writeValue(value, copies);
        return this.readValue(sizeLocation, copies);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return false;
        }
        long sizeLocation = this.writeEventAnSkip(EventId.REMOVE_WITH_VALUE);
        ThreadLocalCopies copies = this.writeKey(key);
        this.writeValue(value, copies);
        return this.blockingFetch(sizeLocation).readBoolean();
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        long sizeLocation = this.writeEventAnSkip(EventId.REPLACE_WITH_OLD_AND_NEW_VALUE);
        ThreadLocalCopies copies = this.writeKey(key);
        copies = this.writeValue(oldValue, copies);
        this.writeValue(newValue, copies);
        return this.blockingFetch(sizeLocation).readBoolean();
    }

    @Override
    public synchronized V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        long sizeLocation = this.writeEventAnSkip(EventId.REPLACE);
        ThreadLocalCopies copies = this.writeKey(key);
        copies = this.writeValue(value, copies);
        return this.readValue(sizeLocation, copies);
    }

    @Override
    public synchronized int size() {
        return (int)this.longSize();
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass().isAssignableFrom(Map.class)) {
            return false;
        }
        Map that = (Map)object;
        int size = this.size();
        if (that.size() != size) {
            return false;
        }
        Set<Map.Entry<K, V>> entries = this.entrySet();
        return that.entrySet().equals(entries);
    }

    @Override
    public synchronized int hashCode() {
        return this.blockingFetch(this.writeEventAnSkip(EventId.HASH_CODE)).readInt();
    }

    public synchronized String toString() {
        return "name=" + this.name + ", " + (String)this.blockingFetch(this.writeEventAnSkip(EventId.TO_STRING)).readObject(String.class);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.blockingFetch(this.writeEventAnSkip(EventId.IS_EMPTY)).readBoolean();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (key == null) {
            throw StatelessChronicleMap.keyNotNullNPE();
        }
        long sizeLocation = this.writeEventAnSkip(EventId.CONTAINS_KEY);
        this.writeKey(key);
        return this.blockingFetch(sizeLocation).readBoolean();
    }

    private static NullPointerException keyNotNullNPE() {
        return new NullPointerException("key can not be null");
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        long sizeLocation = this.writeEventAnSkip(EventId.CONTAINS_VALUE);
        this.writeValue(value, null);
        return this.blockingFetch(sizeLocation).readBoolean();
    }

    @Override
    public synchronized long longSize() {
        return this.blockingFetch(this.writeEventAnSkip(EventId.LONG_SIZE)).readLong();
    }

    @Override
    public synchronized V get(Object key) {
        long sizeLocation = this.writeEventAnSkip(EventId.GET);
        ThreadLocalCopies copies = this.writeKey(key);
        return this.readValue(sizeLocation, copies);
    }

    @Override
    public synchronized V getUsing(K key, V usingValue) {
        throw new UnsupportedOperationException("getUsing() is not supported for stateless clients");
    }

    @Override
    public synchronized V acquireUsing(@NotNull K key, V usingValue) {
        throw new UnsupportedOperationException("acquireUsing() is not supported for stateless clients");
    }

    @Override
    @NotNull
    public synchronized WriteContext<K, V> acquireUsingLocked(@NotNull K key, @NotNull V usingValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public synchronized ReadContext<K, V> getUsingLocked(@NotNull K key, @NotNull V usingValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized V remove(Object key) {
        if (key == null) {
            throw StatelessChronicleMap.keyNotNullNPE();
        }
        long sizeLocation = this.removeReturnsNull ? this.writeEvent(EventId.REMOVE_WITHOUT_ACC) : this.writeEventAnSkip(EventId.REMOVE);
        ThreadLocalCopies copies = this.writeKey(key);
        if (this.removeReturnsNull) {
            this.sendWithoutAcc((Bytes)this.bytes, sizeLocation);
            return null;
        }
        return this.readValue(sizeLocation, copies);
    }

    @Override
    public synchronized V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        long sizeLocation = this.putReturnsNull ? this.writeEvent(EventId.PUT_WITHOUT_ACC) : this.writeEventAnSkip(EventId.PUT);
        ThreadLocalCopies copies = this.writeKey(key);
        copies = this.writeValue(value, copies);
        if (this.putReturnsNull) {
            this.sendWithoutAcc((Bytes)this.bytes, sizeLocation);
            return null;
        }
        return this.readValue(sizeLocation, copies);
    }

    @Override
    public synchronized <R> R mapForKey(K key, @NotNull Function<? super V, R> function) {
        long sizeLocation = this.writeEventAnSkip(EventId.MAP_FOR_KEY);
        this.writeKey(key);
        this.writeObject(function);
        Bytes reader = this.blockingFetch(sizeLocation);
        return (R)reader.readObject();
    }

    @Override
    public synchronized <R> R updateForKey(K key, @NotNull Mutator<? super V, R> mutator) {
        long sizeLocation = this.writeEventAnSkip(EventId.UPDATE_FOR_KEY);
        this.writeKey(key);
        this.writeObject(mutator);
        Bytes reader = this.blockingFetch(sizeLocation);
        return (R)reader.readObject();
    }

    private synchronized <R> void writeObject(@NotNull Object function) {
        long start = this.bytes.position();
        while (true) {
            try {
                this.bytes.writeObject(function);
                return;
            }
            catch (IllegalStateException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException && cause.getMessage().contains("Not enough available space")) {
                    LOG.debug("resizing buffer");
                    this.resizeBuffer(this.buffer.capacity() + this.maxEntrySize, start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        long sizeLocation = this.putReturnsNull ? this.writeEvent(EventId.PUT_ALL_WITHOUT_ACC) : this.writeEventAnSkip(EventId.PUT_ALL);
        this.writeEntriesForPutAll(map);
        if (this.putReturnsNull) {
            this.sendWithoutAcc((Bytes)this.bytes, sizeLocation);
        } else {
            this.blockingFetch(sizeLocation);
        }
    }

    private synchronized void sendWithoutAcc(Bytes bytes, long sizeLocation) {
        this.writeSizeAt(sizeLocation);
        long timeoutTime = this.config.timeoutMs() + System.currentTimeMillis();
        try {
            while (true) {
                if (this.clientChannel == null) {
                    this.clientChannel = this.lazyConnect(this.config.timeoutMs(), this.config.remoteAddress());
                }
                try {
                    this.send(bytes, timeoutTime);
                    return;
                }
                catch (ClosedConnectionException | ClosedChannelException e) {
                    this.checkTimeout(timeoutTime);
                    this.clientChannel = this.lazyConnect(this.config.timeoutMs(), this.config.remoteAddress());
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
    }

    private synchronized void writeEntriesForPutAll(Map<? extends K, ? extends V> map) {
        int numberOfEntries = map.size();
        int numberOfEntriesReadSoFar = 0;
        this.bytes.writeStopBit((long)numberOfEntries);
        assert (this.bytes.limit() == this.bytes.capacity());
        ThreadLocalCopies copies = this.keyWriterWithSize.getCopies(null);
        Object keyWriter = this.keyWriterWithSize.writerForLoop(copies);
        copies = this.valueWriterWithSize.getCopies(copies);
        Object valueWriter = this.valueWriterWithSize.writerForLoop(copies);
        for (Map.Entry<K, V> e : map.entrySet()) {
            K key = e.getKey();
            V value = e.getValue();
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            long start = this.bytes.position();
            this.resizeIfRequired(numberOfEntries, ++numberOfEntriesReadSoFar, start);
            Class<?> keyClass = key.getClass();
            if (!this.kClass.isAssignableFrom(keyClass)) {
                throw new ClassCastException("key=" + key + " is of type=" + keyClass + " " + "and should" + " be of type=" + this.kClass);
            }
            this.writeKeyInLoop(key, keyWriter, copies);
            Class<?> valueClass = value.getClass();
            if (!this.vClass.isAssignableFrom(valueClass)) {
                throw new ClassCastException("value=" + value + " is of type=" + valueClass + " and " + "should  be of type=" + this.vClass);
            }
            this.writeValueInLoop(value, valueWriter, copies);
            int len = (int)(this.bytes.position() - start);
            if (len <= this.maxEntrySize) continue;
            this.maxEntrySize = len;
        }
    }

    private void resizeIfRequired(int numberOfEntries, int numberOfEntriesReadSoFar, long start) {
        long remaining = this.bytes.remaining();
        if (remaining < (long)this.maxEntrySize) {
            long estimatedRequiredSize = this.estimateSize(numberOfEntries, numberOfEntriesReadSoFar);
            this.resizeBuffer((int)(estimatedRequiredSize + (long)this.maxEntrySize), start);
        }
    }

    private long estimateSize(int numberOfEntries, int numberOfEntriesReadSoFar) {
        double percentageComplete = (double)numberOfEntriesReadSoFar / (double)numberOfEntries;
        return (long)((double)this.bytes.position() / percentageComplete);
    }

    private void resizeBuffer(int size, long start) {
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("resizing buffer to size=" + size);
        }
        if (size < this.buffer.capacity()) {
            throw new IllegalStateException("it not possible to resize the buffer smaller");
        }
        assert (size < Integer.MAX_VALUE);
        ByteBuffer result = ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
        long bytesPosition = this.bytes.position();
        this.bytes = new ByteBufferBytes(result.slice());
        this.buffer.position(0);
        this.buffer.limit((int)bytesPosition);
        int numberOfLongs = (int)bytesPosition / 8;
        for (i = 0; i < numberOfLongs; ++i) {
            this.bytes.writeLong(this.buffer.getLong());
        }
        i = numberOfLongs * 8;
        while ((long)i < bytesPosition) {
            this.bytes.writeByte((int)this.buffer.get());
            ++i;
        }
        this.buffer = result;
        assert ((long)this.buffer.capacity() == this.bytes.capacity());
        assert (this.buffer.capacity() == size);
        assert ((long)this.buffer.capacity() == this.bytes.capacity());
        assert (this.bytes.limit() == this.bytes.capacity());
        this.bytes.position(start);
    }

    @Override
    public synchronized void clear() {
        this.blockingFetch(this.writeEventAnSkip(EventId.CLEAR));
    }

    @Override
    @NotNull
    public Collection<V> values() {
        long sizeLocation = this.writeEventAnSkip(EventId.VALUES);
        long startTime = System.currentTimeMillis();
        long transactionId = this.nextUniqueTransaction(startTime);
        long timeoutTime = System.currentTimeMillis() + this.config.timeoutMs();
        Bytes in = this.blockingFetch0(sizeLocation, transactionId, startTime);
        ArrayList<V> result = new ArrayList<V>();
        BytesReader<V> valueReader = this.valueReaderWithSize.readerForLoop(null);
        while (true) {
            boolean hasMoreEntries = in.readBoolean();
            long size = in.readInt();
            int i = 0;
            while ((long)i < size) {
                result.add(this.valueReaderWithSize.readInLoop(in, valueReader));
                ++i;
            }
            if (!hasMoreEntries) break;
            this.compact(in);
            in = this.blockingFetchReadOnly(timeoutTime, transactionId);
        }
        return result;
    }

    @Override
    @NotNull
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        long sizeLocation = this.writeEventAnSkip(EventId.ENTRY_SET);
        long startTime = System.currentTimeMillis();
        long transactionId = this.nextUniqueTransaction(startTime);
        long timeoutTime = System.currentTimeMillis() + this.config.timeoutMs();
        Bytes in = this.blockingFetch0(sizeLocation, transactionId, startTime);
        ThreadLocalCopies copies = this.keyReaderWithSize.getCopies(null);
        BytesReader<K> keyReader = this.keyReaderWithSize.readerForLoop(copies);
        copies = this.valueReaderWithSize.getCopies(copies);
        BytesReader<V> valueReader = this.valueReaderWithSize.readerForLoop(copies);
        HashMap<K, V> result = new HashMap<K, V>();
        while (true) {
            boolean hasMoreEntries = in.readBoolean();
            long size = in.readInt();
            int i = 0;
            while ((long)i < size) {
                K k = this.keyReaderWithSize.readInLoop(in, keyReader);
                V v = this.valueReaderWithSize.readInLoop(in, valueReader);
                result.put(k, v);
                ++i;
            }
            if (!hasMoreEntries) break;
            this.compact(in);
            in = this.blockingFetchReadOnly(timeoutTime, transactionId);
        }
        return result.entrySet();
    }

    private void compact(Bytes in) {
        if (in.remaining() == 0L) {
            this.bytes.clear();
            this.bytes.buffer().clear();
        } else {
            this.buffer.compact();
        }
    }

    @Override
    @NotNull
    public synchronized Set<K> keySet() {
        long sizeLocation = this.writeEventAnSkip(EventId.KEY_SET);
        long startTime = System.currentTimeMillis();
        long transactionId = this.nextUniqueTransaction(startTime);
        long timeoutTime = startTime + this.config.timeoutMs();
        Bytes in = this.blockingFetch0(sizeLocation, transactionId, startTime);
        BytesReader<K> keyReader = this.keyReaderWithSize.readerForLoop(null);
        HashSet<K> result = new HashSet<K>();
        while (true) {
            boolean hasMoreEntries = in.readBoolean();
            long size = in.readInt();
            int i = 0;
            while ((long)i < size) {
                result.add(this.keyReaderWithSize.readInLoop(in, keyReader));
                ++i;
            }
            if (!hasMoreEntries) break;
            this.compact(in);
            in = this.blockingFetchReadOnly(timeoutTime, transactionId);
        }
        return result;
    }

    private long writeEvent(EventId event) {
        this.buffer.clear();
        this.bytes.clear();
        this.bytes.write((int)((byte)event.ordinal()));
        long sizeLocation = this.markSizeLocation();
        return sizeLocation;
    }

    private long writeEventAnSkip(EventId event) {
        long sizeLocation = this.writeEvent(event);
        this.bytes.skip(8L);
        return sizeLocation;
    }

    private Bytes blockingFetch(long sizeLocation) {
        try {
            long startTime = System.currentTimeMillis();
            return this.blockingFetchThrowable(sizeLocation, this.config.timeoutMs(), this.nextUniqueTransaction(startTime), startTime);
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Bytes blockingFetch0(long sizeLocation, long transactionId, long startTime) {
        try {
            return this.blockingFetchThrowable(sizeLocation, this.config.timeoutMs(), transactionId, startTime);
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Bytes blockingFetchThrowable(long sizeLocation, long timeOutMs, long transactionId, long startTime) throws IOException {
        long timeoutTime = startTime + timeOutMs;
        while (true) {
            if (this.clientChannel == null) {
                this.clientChannel = this.lazyConnect(this.config.timeoutMs(), this.config.remoteAddress());
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sending data with transactionId=" + transactionId);
                }
                this.writeSizeAndTransactionIdAt(sizeLocation, transactionId);
                this.send((Bytes)this.bytes, timeoutTime);
                this.bytes.clear();
                this.bytes.buffer().clear();
                return this.blockingFetch(timeoutTime, transactionId);
            }
            catch (ClosedConnectionException | ClosedChannelException e) {
                this.checkTimeout(timeoutTime);
                this.clientChannel = this.lazyConnect(this.config.timeoutMs(), this.config.remoteAddress());
                continue;
            }
            break;
        }
    }

    private Bytes blockingFetchReadOnly(long timeoutTime, long transactionId) {
        try {
            return this.blockingFetch(timeoutTime, transactionId);
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Bytes blockingFetch(long timeoutTime, long transactionId) throws IOException {
        int size = this.receive(4, timeoutTime).readInt();
        int requiredSize = size + 4;
        if (this.bytes.capacity() < (long)requiredSize) {
            long pos = this.bytes.position();
            long limit = this.bytes.position();
            this.bytes.position(limit);
            this.resizeBuffer(requiredSize, pos);
        } else {
            this.bytes.limit(this.bytes.capacity());
        }
        this.receive(size, timeoutTime);
        boolean isException = this.bytes.readBoolean();
        long inTransactionId = this.bytes.readLong();
        if (inTransactionId != transactionId) {
            throw new IllegalStateException("the received transaction-id=" + inTransactionId + ", does not match the expected transaction-id=" + transactionId);
        }
        if (isException) {
            Throwable throwable = (Throwable)this.bytes.readObject();
            try {
                Field stackTrace = Throwable.class.getDeclaredField("stackTrace");
                stackTrace.setAccessible(true);
                ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>(Arrays.asList((StackTraceElement[])stackTrace.get(throwable)));
                for (int i = stes.size() - 1; i > 0 && ((StackTraceElement)stes.get(i)).getClassName().startsWith("Thread"); --i) {
                    stes.remove(i);
                }
                InetSocketAddress address = this.config.remoteAddress();
                stes.add(new StackTraceElement("~ remote", "tcp ~", address.getHostName(), address.getPort()));
                StackTraceElement[] stackTrace2 = Thread.currentThread().getStackTrace();
                for (int i = 4; i < stackTrace2.length; ++i) {
                    stes.add(stackTrace2[i]);
                }
                stackTrace.set(throwable, stes.toArray(new StackTraceElement[stes.size()]));
            }
            catch (Exception ignore) {
                // empty catch block
            }
            NativeBytes.UNSAFE.throwException(throwable);
        }
        return this.bytes;
    }

    private Bytes receive(int requiredNumberOfBytes, long timeoutTime) throws IOException {
        while (this.bytes.buffer().position() < requiredNumberOfBytes) {
            assert ((long)requiredNumberOfBytes <= this.bytes.capacity());
            int len = this.clientChannel.read(this.bytes.buffer());
            if (len == -1) {
                throw new IORuntimeException("Disconnected to remote server");
            }
            this.checkTimeout(timeoutTime);
        }
        this.bytes.limit((long)this.bytes.buffer().position());
        return this.bytes;
    }

    private void send(Bytes out, long timeoutTime) throws IOException {
        this.buffer.limit((int)out.position());
        this.buffer.position(0);
        while (this.buffer.remaining() > 0) {
            this.clientChannel.write(this.buffer);
            this.checkTimeout(timeoutTime);
        }
        out.clear();
        this.buffer.clear();
    }

    private void checkTimeout(long timeoutTime) {
        if (timeoutTime < System.currentTimeMillis()) {
            throw new RemoteCallTimeoutException();
        }
    }

    private void writeSizeAndTransactionIdAt(long locationOfSize, long transactionId) {
        long size = this.bytes.position() - locationOfSize;
        long pos = this.bytes.position();
        this.bytes.position(locationOfSize);
        this.bytes.writeInt((int)size - 4);
        this.bytes.writeLong(transactionId);
        this.bytes.position(pos);
    }

    private void writeSizeAt(long locationOfSize) {
        long size = this.bytes.position() - locationOfSize;
        this.bytes.writeInt(locationOfSize, (int)size - 4);
    }

    private long markSizeLocation() {
        long position = this.bytes.position();
        this.bytes.skip(4L);
        return position;
    }

    private ThreadLocalCopies writeKey(K key) {
        return this.writeKey(key, null);
    }

    private ThreadLocalCopies writeKey(K key, ThreadLocalCopies copies) {
        long start = this.bytes.position();
        while (true) {
            try {
                return this.keyWriterWithSize.write((Bytes)this.bytes, key, copies);
            }
            catch (IndexOutOfBoundsException e) {
                this.resizeBuffer((int)(this.bytes.capacity() + (long)this.maxEntrySize), start);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.resizeToMessage(start, e);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Not enough available space")) {
                    this.resizeBuffer((int)(this.bytes.capacity() + (long)this.maxEntrySize), start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private ThreadLocalCopies writeKeyInLoop(K key, Object writer, ThreadLocalCopies copies) {
        long start = this.bytes.position();
        while (true) {
            try {
                return this.keyWriterWithSize.writeInLoop((Bytes)this.bytes, key, writer, copies);
            }
            catch (IndexOutOfBoundsException e) {
                this.resizeBuffer((int)(this.bytes.capacity() + (long)this.maxEntrySize), start);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.resizeToMessage(start, e);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Not enough available space")) {
                    this.resizeBuffer((int)(this.bytes.capacity() + (long)this.maxEntrySize), start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private V readValue(long sizeLocation, ThreadLocalCopies copies) {
        return this.valueReaderWithSize.readNullable(this.blockingFetch(sizeLocation), copies);
    }

    private ThreadLocalCopies writeValue(V value, ThreadLocalCopies copies) {
        long start = this.bytes.position();
        while (true) {
            try {
                assert (this.bytes.position() == start);
                this.bytes.limit(this.bytes.capacity());
                return this.valueWriterWithSize.write((Bytes)this.bytes, value, copies);
            }
            catch (IllegalArgumentException e) {
                this.resizeToMessage(start, e);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Not enough available space")) {
                    this.resizeBuffer((int)(this.bytes.capacity() + (long)this.maxEntrySize), start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private ThreadLocalCopies writeValueInLoop(V value, Object writer, ThreadLocalCopies copies) {
        long start = this.bytes.position();
        while (true) {
            try {
                assert (this.bytes.position() == start);
                this.bytes.limit(this.bytes.capacity());
                return this.valueWriterWithSize.writeInLoop((Bytes)this.bytes, value, writer, copies);
            }
            catch (IllegalArgumentException e) {
                this.resizeToMessage(start, e);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Not enough available space")) {
                    this.resizeBuffer((int)(this.bytes.capacity() + (long)this.maxEntrySize), start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void resizeToMessage(long start, IllegalArgumentException e) {
        String message = e.getMessage();
        if (message.startsWith(START_OF)) {
            String substring = message.substring(START_OF.length(), message.length());
            int i = substring.indexOf(32);
            if (i != -1) {
                int size = Integer.parseInt(substring.substring(0, i));
                long requiresExtra = (long)size - this.bytes.remaining();
                System.out.println(size + substring);
                this.resizeBuffer((int)(this.bytes.capacity() + requiresExtra), start);
            } else {
                this.resizeBuffer((int)(this.bytes.capacity() + (long)this.maxEntrySize), start);
            }
        } else {
            throw e;
        }
    }

    class Entry
    implements Map.Entry<K, V> {
        final K key;
        final V value;

        Entry(K k1, V v) {
            this.value = v;
            this.key = k1;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            Object oldValue = this.value;
            StatelessChronicleMap.this.put(this.getKey(), newValue);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    static enum EventId {
        HEARTBEAT,
        STATEFUL_UPDATE,
        LONG_SIZE,
        SIZE,
        IS_EMPTY,
        CONTAINS_KEY,
        CONTAINS_VALUE,
        GET,
        PUT,
        PUT_WITHOUT_ACC,
        REMOVE,
        REMOVE_WITHOUT_ACC,
        CLEAR,
        KEY_SET,
        VALUES,
        ENTRY_SET,
        REPLACE,
        REPLACE_WITH_OLD_AND_NEW_VALUE,
        PUT_IF_ABSENT,
        REMOVE_WITH_VALUE,
        TO_STRING,
        PUT_ALL,
        PUT_ALL_WITHOUT_ACC,
        HASH_CODE,
        MAP_FOR_KEY,
        UPDATE_FOR_KEY;

    }
}

