/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.map.AbstractChronicleMapBuilder;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChronicleMapBuilderI;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.OnHeapUpdatableChronicleMapBuilder;
import net.openhft.chronicle.map.PrepareValueBytes;
import net.openhft.chronicle.map.ZeroOutValueBytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.model.DataValueClasses;
import org.jetbrains.annotations.NotNull;

final class OffHeapUpdatableChronicleMapBuilder<K, V>
extends AbstractChronicleMapBuilder<K, V, OffHeapUpdatableChronicleMapBuilder<K, V>> {
    public static <K, V> ChronicleMapBuilderI<K, V> of(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        if (valueClass.isEnum()) {
            return OnHeapUpdatableChronicleMapBuilder.of(keyClass, valueClass);
        }
        if (keyClass.isInterface() && keyClass != CharSequence.class) {
            keyClass = DataValueClasses.directClassFor(keyClass);
        }
        if (valueClass.isInterface() && valueClass != CharSequence.class) {
            valueClass = DataValueClasses.directClassFor(valueClass);
        } else if (!OffHeapUpdatableChronicleMapBuilder.offHeapReference(valueClass)) {
            return OnHeapUpdatableChronicleMapBuilder.of(keyClass, valueClass);
        }
        return new OffHeapUpdatableChronicleMapBuilder<K, V>(keyClass, valueClass);
    }

    OffHeapUpdatableChronicleMapBuilder(Class<K> keyClass, Class<V> valueClass) {
        super(keyClass, valueClass);
        this.prepareValueBytesOnAcquire((PrepareValueBytes)new ZeroOutValueBytes(this.valueSize()));
    }

    @Override
    OffHeapUpdatableChronicleMapBuilder<K, V> self() {
        return this;
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> valueSize(int valueSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> entrySize(int entrySize) {
        return (OffHeapUpdatableChronicleMapBuilder)super.entrySize(entrySize);
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> entryAndValueAlignment(Alignment alignment) {
        return (OffHeapUpdatableChronicleMapBuilder)super.entryAndValueAlignment(alignment);
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> defaultValue(V defaultValue) {
        return (OffHeapUpdatableChronicleMapBuilder)super.defaultValue((Object)defaultValue);
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        return (OffHeapUpdatableChronicleMapBuilder)super.defaultValueProvider((DefaultValueProvider)defaultValueProvider);
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> prepareValueBytesOnAcquire(@NotNull PrepareValueBytes<K, V> prepareValueBytes) {
        return (OffHeapUpdatableChronicleMapBuilder)super.prepareValueBytesOnAcquire((PrepareValueBytes)prepareValueBytes);
    }

    @Override
    public ChronicleMapBuilderI<K, V> valueMarshaller(@NotNull BytesMarshaller<V> valueMarshaller) {
        throw new UnsupportedOperationException("not supported for this combination of key/value type");
    }

    @Override
    public ChronicleMapBuilderI<K, V> valueMarshallers(@NotNull BytesWriter<V> valueWriter, @NotNull BytesReader<V> valueReader) {
        throw new UnsupportedOperationException("not supported for this combination of key/value type");
    }

    @Override
    public ChronicleMapBuilderI<K, V> valueSizeMarshaller(@NotNull SizeMarshaller valueSizeMarshaller) {
        throw new UnsupportedOperationException("not supported for this combination of key/value type");
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> constantValueSizeBySample(V sampleValue) {
        throw new UnsupportedOperationException("not supported for this combination of key/value type");
    }
}

