/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashErrorListener;
import net.openhft.chronicle.hash.ChronicleHashInstanceConfig;
import net.openhft.chronicle.hash.StatelessClientConfig;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.BytesMapEventListener;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilderI;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.OffHeapUpdatableChronicleMapBuilder;
import net.openhft.chronicle.map.OnHeapUpdatableChronicleMapBuilder;
import net.openhft.chronicle.map.PrepareValueBytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import org.jetbrains.annotations.NotNull;

public final class ChronicleMapBuilder<K, V>
implements ChronicleMapBuilderI<K, V>,
ChronicleHashBuilder<K, ChronicleMap<K, V>, ChronicleMapBuilder<K, V>> {
    final ChronicleMapBuilderI<K, V> delegate;

    public static <K, V> ChronicleMapBuilder<K, V> of(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        if (valueClass.isEnum()) {
            return new ChronicleMapBuilder<K, V>(OnHeapUpdatableChronicleMapBuilder.of(keyClass, valueClass));
        }
        if (keyClass.isInterface() && !ChronicleMapBuilder.builtInType(keyClass)) {
            keyClass = DataValueClasses.directClassFor(keyClass);
        }
        if (valueClass.isInterface() && !ChronicleMapBuilder.builtInType(valueClass)) {
            valueClass = DataValueClasses.directClassFor(valueClass);
        } else if (!ChronicleMapBuilder.offHeapReference(valueClass)) {
            return new ChronicleMapBuilder(OnHeapUpdatableChronicleMapBuilder.of(keyClass, valueClass));
        }
        OffHeapUpdatableChronicleMapBuilder builder = new OffHeapUpdatableChronicleMapBuilder(keyClass, valueClass);
        return new ChronicleMapBuilder(builder);
    }

    static boolean builtInType(Class clazz) {
        return clazz.getClassLoader() == Class.class.getClassLoader();
    }

    ChronicleMapBuilder(ChronicleMapBuilderI<K, V> delegate) {
        this.delegate = delegate;
    }

    private static boolean offHeapReference(Class valueClass) {
        return Byteable.class.isAssignableFrom(valueClass);
    }

    @Override
    public ChronicleMapBuilder<K, V> entrySize(int entrySize) {
        this.delegate.entrySize(entrySize);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> entryAndValueAlignment(Alignment alignment) {
        this.delegate.entryAndValueAlignment(alignment);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> defaultValue(V defaultValue) {
        this.delegate.defaultValue(defaultValue);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> prepareValueBytesOnAcquire(@NotNull PrepareValueBytes<K, V> prepareValueBytes) {
        this.delegate.prepareValueBytesOnAcquire(prepareValueBytes);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keySize(int keySize) {
        this.delegate.keySize(keySize);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> constantKeySizeBySample(K sampleKey) {
        this.delegate.constantKeySizeBySample(sampleKey);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> valueSize(int valueSize) {
        this.delegate.valueSize(valueSize);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> constantValueSizeBySample(@NotNull V sampleValue) {
        this.delegate.constantValueSizeBySample(sampleValue);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> objectSerializer(@NotNull ObjectSerializer objectSerializer) {
        this.delegate.objectSerializer(objectSerializer);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> valueDeserializationFactory(@NotNull ObjectFactory<V> valueDeserializationFactory) {
        this.delegate.valueDeserializationFactory(valueDeserializationFactory);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        this.delegate.defaultValueProvider(defaultValueProvider);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> valueMarshaller(@NotNull BytesMarshaller<V> valueMarshaller) {
        this.delegate.valueMarshaller(valueMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> valueMarshallers(@NotNull BytesWriter<V> valueWriter, @NotNull BytesReader<V> valueReader) {
        this.delegate.valueMarshallers(valueWriter, valueReader);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> valueSizeMarshaller(@NotNull SizeMarshaller valueSizeMarshaller) {
        this.delegate.valueSizeMarshaller(valueSizeMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> entries(long l) {
        this.delegate.entries(l);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> name(String name) {
        this.delegate.name(name);
        return this;
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(SingleChronicleHashReplication withId) {
        this.delegate.replication(withId);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> pushTo(InetSocketAddress ... addresses) {
        this.delegate.pushTo(addresses);
        return this;
    }

    @Override
    public ChronicleMap<K, V> create() {
        return this.delegate.create();
    }

    @Override
    public ChronicleMapBuilder<K, V> actualSegments(int actualSegments) {
        this.delegate.actualSegments(actualSegments);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> minSegments(int minSegments) {
        this.delegate.minSegments(minSegments);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualEntriesPerSegment(long actualEntriesPerSegment) {
        this.delegate.actualEntriesPerSegment(actualEntriesPerSegment);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> lockTimeOut(long lockTimeOut, TimeUnit unit) {
        this.delegate.lockTimeOut(lockTimeOut, unit);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> errorListener(ChronicleHashErrorListener errorListener) {
        this.delegate.errorListener(errorListener);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> metaDataBytes(int metaDataBytes) {
        this.delegate.metaDataBytes(metaDataBytes);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> timeProvider(TimeProvider timeProvider) {
        this.delegate.timeProvider(timeProvider);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.delegate.bytesMarshallerFactory(bytesMarshallerFactory);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshaller(BytesMarshaller<K> keyMarshaller) {
        this.delegate.keyMarshaller(keyMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshallers(BytesWriter<K> keyWriter, BytesReader<K> keyReader) {
        this.delegate.keyMarshallers(keyWriter, keyReader);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keySizeMarshaller(SizeMarshaller keySizeMarshaller) {
        this.delegate.keySizeMarshaller(keySizeMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyDeserializationFactory(ObjectFactory<K> keyDeserializationFactory) {
        this.delegate.keyDeserializationFactory(keyDeserializationFactory);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> immutableKeys() {
        this.delegate.immutableKeys();
        return this;
    }

    @Override
    public StatelessClientConfig<ChronicleMap<K, V>> statelessClient(InetSocketAddress remoteAddress) {
        return this.delegate.statelessClient(remoteAddress);
    }

    @Override
    public ChronicleHashInstanceConfig<ChronicleMap<K, V>> instance() {
        return this.delegate.instance();
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(byte identifier) {
        this.delegate.replication(identifier);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        this.delegate.replication(identifier, tcpTransportAndNetwork);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> clone() {
        this.delegate.clone();
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> putReturnsNull(boolean b) {
        this.delegate.putReturnsNull(b);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> removeReturnsNull(boolean b) {
        this.delegate.removeReturnsNull(b);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> eventListener(MapEventListener<K, V> eventListener) {
        this.delegate.eventListener(eventListener);
        return this;
    }

    @Override
    public ChronicleMapBuilderI<K, V> bytesEventListener(BytesMapEventListener eventListener) {
        this.delegate.bytesEventListener(eventListener);
        return this;
    }

    @Override
    public ChronicleMap<K, V> createPersistedTo(File file) throws IOException {
        return this.delegate.createPersistedTo(file);
    }

    @Override
    public ChronicleMapBuilder<K, V> bootstrapOnlyLocalEntries(boolean bootstrapOnlyLocalEntries) {
        this.delegate.bootstrapOnlyLocalEntries(bootstrapOnlyLocalEntries);
        return this;
    }

    public ChronicleMapBuilderI<K, V> checkSerializedValues() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ChronicleMapBuilder<K, V> disableOversizedEntries(boolean disableOversizedEntries) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

