/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.serialization.impl;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import net.openhft.chronicle.map.serialization.BytesReader;
import net.openhft.chronicle.map.threadlocal.StatefulCopyable;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.pool.CharSequenceInterner;
import org.jetbrains.annotations.NotNull;

public final class CharSequenceReader<S extends CharSequence>
implements BytesReader<S>,
StatefulCopyable<CharSequenceReader<S>> {
    private static final long serialVersionUID = 0L;
    private static final CharSequenceReader<String> DEFAULT_READER = new CharSequenceReader<String>(NoInterning.INSTANCE, (Serializable)((Object)NoInterning.INSTANCE));
    private final StringBuilder sb = new StringBuilder(128);
    @NotNull
    private final CharSequenceInterner<S> interner;
    @NotNull
    private final Serializable identity;

    public static CharSequenceReader<String> of() {
        return DEFAULT_READER;
    }

    public static <S extends CharSequence, I extends CharSequenceInterner<S> & Serializable> CharSequenceReader<S> of(@NotNull I interner, @NotNull Serializable stateIdentity) {
        return new CharSequenceReader<S>(interner, stateIdentity);
    }

    private CharSequenceReader(@NotNull CharSequenceInterner<S> interner, @NotNull Serializable identity) {
        this.interner = interner;
        this.identity = identity;
    }

    @Override
    public S read(Bytes bytes, long size) {
        this.sb.setLength(0);
        try {
            AbstractBytes.readUTF0((Bytes)bytes, (Appendable)this.sb, (int)((int)size));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return (S)((CharSequence)this.interner.intern((CharSequence)this.sb));
    }

    @Override
    public S read(Bytes bytes, long size, S s) {
        Appendable appendable;
        if (s instanceof Appendable) {
            appendable = (Appendable)s;
            if (s instanceof StringBuilder) {
                ((StringBuilder)s).setLength(0);
            } else if (s instanceof StringBuffer) {
                ((StringBuffer)s).setLength(0);
            }
        } else {
            this.sb.setLength(0);
            appendable = this.sb;
        }
        try {
            AbstractBytes.readUTF0((Bytes)bytes, (Appendable)appendable, (int)((int)size));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (appendable == s) {
            return s;
        }
        return (S)((CharSequence)this.interner.intern((CharSequence)this.sb));
    }

    @Override
    public Object stateIdentity() {
        return this.identity;
    }

    @Override
    public CharSequenceReader<S> copy() {
        return new CharSequenceReader<S>(this.interner, this.identity);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.interner == NoInterning.INSTANCE) {
            return DEFAULT_READER;
        }
        return this;
    }

    private static enum NoInterning implements CharSequenceInterner<String>
    {
        INSTANCE;


        public String intern(CharSequence cs) {
            return cs.toString();
        }
    }
}

