/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.serialization;

import net.openhft.chronicle.map.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;

public final class SizeMarshallers {
    public static SizeMarshaller stopBit() {
        return StopBit.INSTANCE;
    }

    public static SizeMarshaller constant(long size) {
        return new ConstantSizeMarshaller(size);
    }

    private SizeMarshallers() {
    }

    private static class ConstantSizeMarshaller
    implements SizeMarshaller {
        private static final long serialVersionUID = 0L;
        private final long size;

        private ConstantSizeMarshaller(long size) {
            this.size = size;
        }

        @Override
        public int sizeEncodingSize(long size) {
            return 0;
        }

        @Override
        public void writeSize(Bytes bytes, long size) {
        }

        @Override
        public long readSize(Bytes bytes) {
            return this.size;
        }
    }

    private static enum StopBit implements SizeMarshaller
    {
        INSTANCE;


        @Override
        public int sizeEncodingSize(long size) {
            if (size <= 127L) {
                return 1;
            }
            return (70 - Long.numberOfLeadingZeros(size)) / 7;
        }

        @Override
        public void writeSize(Bytes bytes, long size) {
            bytes.writeStopBit(size);
        }

        @Override
        public long readSize(Bytes bytes) {
            return bytes.readStopBit();
        }
    }
}

