/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.map.AddressAndPort;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.ConcurrentExpiryMap;
import net.openhft.chronicle.map.DiscoveryNodeBytesMarshallable;
import net.openhft.chronicle.map.IdentifierListener;
import net.openhft.chronicle.map.KnownNodes;
import net.openhft.chronicle.map.NodeDiscoveryBroadcaster;
import net.openhft.chronicle.map.Replicators;
import net.openhft.chronicle.map.TcpReplicationConfig;
import net.openhft.chronicle.map.UDPEventListener;
import net.openhft.chronicle.map.UdpReplicationConfig;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public class NodeDiscovery {
    public ChronicleMap<Integer, CharSequence> discoverMap(int udpBroadcastPort, int tcpPort) throws IOException, InterruptedException {
        byte identifier;
        AddressAndPort ourAddressAndPort;
        ConcurrentSkipListSet<AddressAndPort> knownHostPorts;
        KnownNodes knownNodes;
        block4: {
            AtomicInteger proposedIdentifier = new AtomicInteger();
            AtomicBoolean useAnotherIdentifier = new AtomicBoolean();
            UdpReplicationConfig udpConfig = UdpReplicationConfig.simple(Inet4Address.getByName("255.255.255.255"), udpBroadcastPort);
            knownNodes = new KnownNodes();
            knownHostPorts = new ConcurrentSkipListSet<AddressAndPort>();
            ATSDirectBitSet knownIdentifiers = new ATSDirectBitSet((Bytes)new ByteBufferBytes(ByteBuffer.allocate(16)));
            AtomicReference<CountDownLatch> countDownLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
            ourAddressAndPort = new AddressAndPort(InetAddress.getLocalHost().getAddress(), (short)tcpPort);
            UDPEventListener udpEventListener = new UDPEventListener((DirectBitSet)knownIdentifiers, ourAddressAndPort, proposedIdentifier, useAnotherIdentifier, countDownLatch){
                final /* synthetic */ DirectBitSet val$knownIdentifiers;
                final /* synthetic */ AddressAndPort val$ourAddressAndPort;
                final /* synthetic */ AtomicInteger val$proposedIdentifier;
                final /* synthetic */ AtomicBoolean val$useAnotherIdentifier;
                final /* synthetic */ AtomicReference val$countDownLatch;
                {
                    this.val$knownIdentifiers = directBitSet;
                    this.val$ourAddressAndPort = addressAndPort;
                    this.val$proposedIdentifier = atomicInteger;
                    this.val$useAnotherIdentifier = atomicBoolean;
                    this.val$countDownLatch = atomicReference;
                }

                @Override
                public void onRemoteNodeEvent(KnownNodes remoteNode, ConcurrentExpiryMap<AddressAndPort, DiscoveryNodeBytesMarshallable.ProposedNodes> proposedIdentifiersWithHost) {
                    knownHostPorts.addAll(remoteNode.addressAndPorts());
                    NodeDiscovery.this.orBitSets(remoteNode.activeIdentifierBitSet(), this.val$knownIdentifiers);
                    for (DiscoveryNodeBytesMarshallable.ProposedNodes proposedIdentifierWithHost : proposedIdentifiersWithHost.values()) {
                        if (proposedIdentifierWithHost.addressAndPort().equals(this.val$ourAddressAndPort)) continue;
                        byte remoteIdentifier = proposedIdentifierWithHost.identifier();
                        this.val$knownIdentifiers.set((long)remoteIdentifier, true);
                        knownHostPorts.add(proposedIdentifierWithHost.addressAndPort());
                        if (remoteIdentifier == this.val$proposedIdentifier.get()) {
                            this.val$useAnotherIdentifier.set(true);
                        }
                        ((CountDownLatch)this.val$countDownLatch.get()).countDown();
                    }
                }
            };
            DiscoveryNodeBytesMarshallable externalizable = new DiscoveryNodeBytesMarshallable(knownNodes, udpEventListener);
            NodeDiscoveryBroadcaster nodeDiscoveryBroadcaster = new NodeDiscoveryBroadcaster(udpConfig, 1024, externalizable);
            externalizable.setModificationNotifier(nodeDiscoveryBroadcaster);
            DiscoveryNodeBytesMarshallable.ProposedNodes ourHostPort = new DiscoveryNodeBytesMarshallable.ProposedNodes(ourAddressAndPort, -1);
            for (int i = 0; i < 20; ++i) {
                externalizable.sendBootStrap(ourHostPort);
                if (countDownLatch.get().await(50L, TimeUnit.MILLISECONDS)) break;
            }
            boolean isFistTime = true;
            block1: while (true) {
                useAnotherIdentifier.set(false);
                identifier = NodeDiscovery.proposeRandomUnusedIdentifier((DirectBitSet)knownIdentifiers, isFistTime);
                proposedIdentifier.set(identifier);
                NodeDiscoveryBroadcaster.LOG.info("proposing to use identifier=" + identifier);
                isFistTime = false;
                DiscoveryNodeBytesMarshallable.ProposedNodes proposedNodes = new DiscoveryNodeBytesMarshallable.ProposedNodes(ourAddressAndPort, identifier);
                Thread.sleep(500L);
                countDownLatch.set(new CountDownLatch(1));
                for (int i = 0; i < 20; ++i) {
                    externalizable.sendBootStrap(proposedNodes);
                    if (!countDownLatch.get().await(50L, TimeUnit.MILLISECONDS)) continue;
                    if (useAnotherIdentifier.get()) {
                        NodeDiscoveryBroadcaster.LOG.info("Another node is using identifier=" + identifier + ", " + "going to have to select another one.");
                        continue block1;
                    }
                    break block4;
                }
                break;
            }
            NodeDiscoveryBroadcaster.LOG.info("looks like we are the only node in the grid, so going to use identifier=" + identifier);
        }
        IdentifierListener identifierListener = new IdentifierListener(){
            final ConcurrentMap<Byte, SocketAddress> identifiers = new ConcurrentHashMap<Byte, SocketAddress>();

            @Override
            public boolean isIdentifierUnique(byte remoteIdentifier, SocketAddress remoteAddress) {
                SocketAddress socketAddress = this.identifiers.putIfAbsent(remoteIdentifier, remoteAddress);
                knownNodes.activeIdentifierBitSet().set((long)remoteIdentifier);
                return socketAddress == null;
            }
        };
        knownNodes.add(ourAddressAndPort, identifier);
        TcpReplicationConfig tcpConfig = TcpReplicationConfig.of(tcpPort, this.toInetSocketArray(knownHostPorts)).heartBeatInterval(1L, TimeUnit.SECONDS).nonUniqueIdentifierListener(identifierListener);
        return ChronicleMapBuilder.of(Integer.class, CharSequence.class).entries(20000L).addReplicator(Replicators.tcp(identifier, tcpConfig)).create();
    }

    private InetSocketAddress[] toInetSocketArray(Set<AddressAndPort> source) throws UnknownHostException {
        HashSet<AddressAndPort> addressAndPorts = new HashSet<AddressAndPort>(source);
        if (addressAndPorts.isEmpty()) {
            return new InetSocketAddress[0];
        }
        InetSocketAddress[] addresses = new InetSocketAddress[addressAndPorts.size()];
        int i = 0;
        for (AddressAndPort addressAndPort : addressAndPorts) {
            addresses[i++] = new InetSocketAddress(InetAddress.getByAddress(addressAndPort.address()).getHostAddress(), (int)addressAndPort.port());
        }
        return addresses;
    }

    private DirectBitSet orBitSets(@NotNull DirectBitSet source, @NotNull DirectBitSet destination) {
        int i = (int)source.nextSetBit(0L);
        while (i > 0) {
            try {
                destination.set((long)i, true);
            }
            catch (IndexOutOfBoundsException e) {
                NodeDiscoveryBroadcaster.LOG.error("", (Throwable)e);
            }
            i = (int)source.nextSetBit((long)(i + 1));
        }
        return destination;
    }

    static byte proposeRandomUnusedIdentifier(DirectBitSet knownIdentifiers, boolean isFirstTime) throws UnknownHostException {
        byte possible;
        if (isFirstTime) {
            byte[] address = InetAddress.getLocalHost().getAddress();
            int lastAddress = address[address.length - 1];
            if (lastAddress > 127) {
                lastAddress -= 127;
            }
            if (lastAddress > 127) {
                lastAddress -= 127;
            }
            possible = (byte)lastAddress;
        } else {
            possible = (byte)(Math.random() * 128.0);
        }
        int count = 0;
        while (!knownIdentifiers.setIfClear((long)possible)) {
            if (++count == 128) {
                throw new IllegalStateException("The grid is full, its not possible for any more nodes to going the grid.");
            }
            if (possible == 128) {
                possible = 0;
                continue;
            }
            possible = (byte)(possible + 1);
        }
        return possible;
    }

    private static DirectBitSet newBitSet(int numberOfBits) {
        ByteBufferBytes bytes = new ByteBufferBytes(ByteBuffer.wrap(new byte[(numberOfBits + 7) / 8]));
        return new ATSDirectBitSet((Bytes)bytes);
    }
}

