/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import net.openhft.chronicle.map.AddressAndPort;
import net.openhft.chronicle.map.NodeDiscoveryBroadcaster;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.model.constraints.NotNull;

class KnownNodes
implements BytesMarshallable {
    private Bytes activeIdentifiersBitSetBytes;
    private ConcurrentSkipListSet<AddressAndPort> addressAndPorts = new ConcurrentSkipListSet();
    private ATSDirectBitSet atsDirectBitSet;

    KnownNodes() {
        this.activeIdentifiersBitSetBytes = new ByteBufferBytes(ByteBuffer.allocate(16));
        this.addressAndPorts = new ConcurrentSkipListSet();
        this.atsDirectBitSet = new ATSDirectBitSet(this.activeIdentifiersBitSetBytes);
    }

    public Set<AddressAndPort> addressAndPorts() {
        return this.addressAndPorts;
    }

    public void add(AddressAndPort inetSocketAddress, byte identifier) {
        this.activeIdentifierBitSet().set((long)identifier);
        this.addressAndPorts.add(inetSocketAddress);
    }

    public DirectBitSet activeIdentifierBitSet() {
        return this.atsDirectBitSet;
    }

    public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
        int size = in.readShort();
        for (int i = 0; i < size; ++i) {
            AddressAndPort addressAndPort = new AddressAndPort();
            addressAndPort.readMarshallable(in);
            this.addressAndPorts.add(addressAndPort);
        }
        ByteBufferBytes activeIdentifiersBitSetBytes = new ByteBufferBytes(ByteBuffer.allocate(16));
        activeIdentifiersBitSetBytes.readMarshallable(in);
        ATSDirectBitSet bitset = new ATSDirectBitSet((Bytes)activeIdentifiersBitSetBytes);
        long next = bitset.nextSetBit(0L);
        while (next > 0L) {
            this.atsDirectBitSet.set(next);
            next = bitset.nextSetBit(next + 1L);
        }
    }

    public void writeMarshallable(@NotNull Bytes out) {
        HashSet<AddressAndPort> addressAndPorts = new HashSet<AddressAndPort>(this.addressAndPorts);
        out.writeShort(addressAndPorts.size());
        for (AddressAndPort bytesMarshallable : addressAndPorts) {
            bytesMarshallable.writeMarshallable(out);
        }
        this.activeIdentifiersBitSetBytes.clear();
        this.activeIdentifiersBitSetBytes.writeMarshallable(out);
    }

    public String toString() {
        return "RemoteNodes{ addressAndPorts=" + this.addressAndPorts + ", bitSet=" + NodeDiscoveryBroadcaster.toString((DirectBitSet)this.atsDirectBitSet) + '}';
    }
}

