/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collections;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.collections.AbstractChannelReplicator;
import net.openhft.collections.ClusterReplicator;
import net.openhft.collections.ReplicaExternalizable;
import net.openhft.collections.SharedHashMap;
import net.openhft.collections.SharedHashMapBuilder;
import net.openhft.collections.TcpReplicator;
import net.openhft.collections.TcpReplicatorBuilder;
import net.openhft.collections.UdpReplicator;
import net.openhft.collections.UdpReplicatorBuilder;
import net.openhft.collections.VanillaSharedReplicatedHashMap;

public class ClusterReplicatorBuilder {
    Set<Closeable> closeables = new HashSet<Closeable>();
    private final byte identifier;
    private UdpReplicatorBuilder udpReplicatorBuilder = null;
    private TcpReplicatorBuilder tcpReplicatorBuilder = null;
    private int maxEntrySize;
    private int maxNumberOfChronicles = 128;
    private ClusterReplicator clusterReplicator;
    private final Map<Short, ReplicaExternalizable> replicas = new ConcurrentHashMap<Short, ReplicaExternalizable>();

    ClusterReplicatorBuilder(byte identifier, int maxEntrySize1) {
        this.identifier = identifier;
        this.maxEntrySize = maxEntrySize1;
        if (identifier <= 0 || identifier >= 128) {
            throw new IllegalArgumentException("Identifier must be positive and <128, identifier=" + identifier);
        }
    }

    public ClusterReplicatorBuilder udpReplicator(UdpReplicatorBuilder udpReplicatorBuilder) throws IOException {
        this.udpReplicatorBuilder = udpReplicatorBuilder;
        return this;
    }

    public ClusterReplicatorBuilder tcpReplicatorBuilder(TcpReplicatorBuilder tcpReplicatorBuilder) {
        this.tcpReplicatorBuilder = tcpReplicatorBuilder;
        return this;
    }

    public <K, V> SharedHashMap<K, V> create(short chronicleChannel, ChronicleMapBuilder<K, V> builder) throws IOException {
        SharedHashMapBuilder builder0 = builder.clone();
        ((ChronicleMapBuilder)builder0).identifier(this.identifier);
        VanillaSharedReplicatedHashMap result = new VanillaSharedReplicatedHashMap(builder0, builder0.kClass(), builder0.vClass());
        if (this.clusterReplicator == null) {
            this.replicas.put(chronicleChannel, result);
        } else {
            this.clusterReplicator.add(chronicleChannel, result);
        }
        return result;
    }

    public ClusterReplicator create() throws IOException {
        ClusterReplicator clusterReplicator = new ClusterReplicator(this.identifier, this.maxNumberOfChronicles);
        for (Map.Entry<Short, ReplicaExternalizable> entry : this.replicas.entrySet()) {
            clusterReplicator.add(entry.getKey(), entry.getValue());
        }
        if (this.tcpReplicatorBuilder != null) {
            TcpReplicator tcpReplicator = new TcpReplicator(clusterReplicator, clusterReplicator, this.tcpReplicatorBuilder, this.maxEntrySize);
            this.closeables.add((Closeable)tcpReplicator);
            clusterReplicator.add((AbstractChannelReplicator)tcpReplicator);
        }
        if (this.udpReplicatorBuilder != null) {
            InetAddress address = this.udpReplicatorBuilder.address();
            if (address == null) {
                throw new IllegalArgumentException("address can not be null");
            }
            if (address.isMulticastAddress() && this.udpReplicatorBuilder.networkInterface() == null) {
                throw new IllegalArgumentException("MISSING: NetworkInterface, When using a multicast addresses, please provided a networkInterface");
            }
            UdpReplicator udpReplicator = new UdpReplicator(clusterReplicator, (UdpReplicatorBuilder)this.udpReplicatorBuilder.clone(), this.maxEntrySize, this.identifier, 128);
            this.closeables.add((Closeable)udpReplicator);
            clusterReplicator.add((AbstractChannelReplicator)udpReplicator);
        }
        this.clusterReplicator = clusterReplicator;
        return clusterReplicator;
    }
}

