/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.logger.ChronicleLogAppenderConfig;
import net.openhft.chronicle.logger.ChronicleLogHelper;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.TimeStampFormatter;
import net.openhft.lang.io.ByteStringAppender;
import net.openhft.lang.io.RandomDataOutput;
import net.openhft.lang.model.constraints.NotNull;

public class ChronicleLogWriters {
    public static ChronicleLogWriter binary(@NotNull Chronicle chronicle) throws IOException {
        return chronicle instanceof VanillaChronicle ? new BinaryWriter(chronicle) : new SynchronizedWriter(new BinaryWriter(chronicle));
    }

    public static ChronicleLogWriter binary(@NotNull ChronicleLogAppenderConfig cfg, String path) throws IOException {
        return ChronicleLogWriters.binary(cfg.build(path));
    }

    public static ChronicleLogWriter text(@NotNull Chronicle chronicle, String dateFormat, Integer stackTraceDepth) throws IOException {
        return chronicle instanceof VanillaChronicle ? new TextWriter(chronicle, dateFormat, stackTraceDepth) : new SynchronizedWriter(new TextWriter(chronicle, dateFormat, stackTraceDepth));
    }

    public static ChronicleLogWriter text(@NotNull ChronicleLogAppenderConfig cfg, String path, String dateFormat, Integer stackTraceDepth) throws IOException {
        return ChronicleLogWriters.text(cfg.build(path), dateFormat, stackTraceDepth);
    }

    public static final class SynchronizedWriter
    implements ChronicleLogWriter,
    Closeable {
        private final ChronicleLogWriter writer;
        private final Object sync;

        public SynchronizedWriter(ChronicleLogWriter writer) {
            this.writer = writer;
            this.sync = new Object();
        }

        public ChronicleLogWriter writer() {
            return this.writer;
        }

        @Override
        public Chronicle getChronicle() {
            return this.writer.getChronicle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.sync;
            synchronized (object) {
                this.writer.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message) {
            Object object = this.sync;
            synchronized (object) {
                this.writer.write(level, timestamp, threadName, loggerName, message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable) {
            Object object = this.sync;
            synchronized (object) {
                this.writer.write(level, timestamp, threadName, loggerName, message, throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object arg1) {
            Object object = this.sync;
            synchronized (object) {
                this.writer.write(level, timestamp, threadName, loggerName, message, throwable, arg1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object arg1, Object arg2) {
            Object object = this.sync;
            synchronized (object) {
                this.writer.write(level, timestamp, threadName, loggerName, message, throwable, arg1, arg2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object[] args) {
            Object object = this.sync;
            synchronized (object) {
                this.writer.write(level, timestamp, threadName, loggerName, message, throwable, args);
            }
        }
    }

    public static class SimpleWriter
    implements ChronicleLogWriter {
        private final TimeStampFormatter timeStampFormatter = TimeStampFormatter.fromDateFormat("yyyy.MM.dd-HH:mm:ss.SSS");
        private final PrintStream stream;

        public SimpleWriter(@NotNull PrintStream stream) throws IOException {
            this.stream = stream;
        }

        @Override
        public Chronicle getChronicle() {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable) {
            if (throwable == null) {
                this.stream.printf("%s|%s|%s|%s|%s\n", this.timeStampFormatter.format(timestamp), level.toString(), threadName, loggerName, message);
            } else {
                this.stream.printf("%s|%s|%s|%s|%s|%s\n", this.timeStampFormatter.format(timestamp), level.toString(), threadName, loggerName, message, throwable.toString());
            }
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message) {
            this.write(level, timestamp, threadName, loggerName, message, null);
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object arg1) {
            this.write(level, timestamp, threadName, loggerName, message, throwable);
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object arg1, Object arg2) {
            this.write(level, timestamp, threadName, loggerName, message, throwable);
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object[] args) {
            this.write(level, timestamp, threadName, loggerName, message, throwable);
        }
    }

    public static class TextWriter
    extends AbstractChronicleLogWriter {
        private final TimeStampFormatter timeStampFormatter;
        private final int stackTraceDepth;

        public TextWriter(@NotNull Chronicle chronicle, String dateFormat, Integer stackTraceDepth) throws IOException {
            super(chronicle);
            this.stackTraceDepth = stackTraceDepth != null ? stackTraceDepth : -1;
            this.timeStampFormatter = TimeStampFormatter.fromDateFormat(dateFormat);
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message) {
            this.write(level, timestamp, threadName, loggerName, message, null);
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.timeStampFormatter.format(timestamp, (ByteStringAppender)appender);
                appender.append('|');
                level.printTo((ByteStringAppender)appender);
                appender.append('|');
                appender.append((CharSequence)threadName);
                appender.append('|');
                appender.append((CharSequence)loggerName);
                appender.append('|');
                appender.append((CharSequence)message);
                if (throwable != null) {
                    appender.append((CharSequence)" - ");
                    ChronicleLogHelper.appendStackTraceAsString(appender, throwable, ", ", this.stackTraceDepth);
                }
                appender.append('\n');
                appender.finish();
            }
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object arg1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object arg1, Object arg2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object[] args) {
        }
    }

    public static final class BinaryWriter
    extends AbstractChronicleLogWriter {
        public BinaryWriter(@NotNull Chronicle chronicle) throws IOException {
            super(chronicle);
        }

        private void logCommon(ExcerptAppender appender, ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message) {
            appender.writeByte(1);
            appender.writeLong(timestamp);
            level.writeTo((RandomDataOutput)appender);
            appender.writeUTF\u0394((CharSequence)threadName);
            appender.writeUTF\u0394((CharSequence)loggerName);
            appender.writeUTF\u0394((CharSequence)message);
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.logCommon(appender, level, timestamp, threadName, loggerName, message);
                appender.finish();
            }
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.logCommon(appender, level, timestamp, threadName, loggerName, message);
                appender.writeStopBit(0L);
                if (throwable != null) {
                    appender.writeBoolean(true);
                    appender.writeObject((Object)throwable);
                } else {
                    appender.writeBoolean(false);
                }
                appender.finish();
            }
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object arg1) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.logCommon(appender, level, timestamp, threadName, loggerName, message);
                appender.writeStopBit(1L);
                appender.writeObject(arg1);
                if (throwable != null) {
                    appender.writeBoolean(true);
                    appender.writeObject((Object)throwable);
                } else {
                    appender.writeBoolean(false);
                }
                appender.finish();
            }
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object arg1, Object arg2) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.logCommon(appender, level, timestamp, threadName, loggerName, message);
                appender.writeStopBit(2L);
                appender.writeObject(arg1);
                appender.writeObject(arg2);
                if (throwable != null) {
                    appender.writeBoolean(true);
                    appender.writeObject((Object)throwable);
                } else {
                    appender.writeBoolean(false);
                }
                appender.finish();
            }
        }

        @Override
        public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object[] args) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.logCommon(appender, level, timestamp, threadName, loggerName, message);
                if (args != null) {
                    appender.writeStopBit((long)args.length);
                    for (int i = 0; i < args.length; ++i) {
                        appender.writeObject(args[i]);
                    }
                } else {
                    appender.writeStopBit(0L);
                }
                if (throwable != null) {
                    appender.writeBoolean(true);
                    appender.writeObject((Object)throwable);
                } else {
                    appender.writeBoolean(false);
                }
                appender.finish();
            }
        }
    }

    public static abstract class AbstractChronicleLogWriter
    implements ChronicleLogWriter {
        private final ExcerptAppenderProvider appenderProvider;
        private final Chronicle chronicle;

        public AbstractChronicleLogWriter(@NotNull Chronicle chronicle) throws IOException {
            this.chronicle = chronicle;
            this.appenderProvider = chronicle instanceof VanillaChronicle ? new VanillaExcerptAppenderProvider(chronicle) : new IndexedExcerptAppenderProvider(chronicle);
        }

        @Override
        public Chronicle getChronicle() {
            return this.chronicle;
        }

        @Override
        public void close() throws IOException {
            if (this.chronicle != null) {
                this.chronicle.close();
            }
        }

        protected ExcerptAppender getAppender() {
            return this.appenderProvider.get();
        }
    }

    public static class VanillaExcerptAppenderProvider
    implements ExcerptAppenderProvider {
        private final Chronicle chronicle;

        public VanillaExcerptAppenderProvider(@NotNull Chronicle chronicle) {
            this.chronicle = chronicle;
        }

        @Override
        public ExcerptAppender get() {
            try {
                return this.chronicle.createAppender();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class IndexedExcerptAppenderProvider
    implements ExcerptAppenderProvider {
        private ExcerptAppender appender;

        public IndexedExcerptAppenderProvider(@NotNull Chronicle chronicle) {
            try {
                this.appender = chronicle.createAppender();
            }
            catch (IOException e) {
                this.appender = null;
                e.printStackTrace();
            }
        }

        @Override
        public ExcerptAppender get() {
            return this.appender;
        }
    }

    public static interface ExcerptAppenderProvider {
        public ExcerptAppender get();
    }
}

