/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import net.openhft.chronicle.logger.ChronicleLogEvent;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.model.constraints.NotNull;

final class BinaryChronicleLogEvent
implements ChronicleLogEvent {
    private final byte version;
    private final long timestamp;
    private final ChronicleLogLevel level;
    private final String threadName;
    private final String loggerName;
    private final String message;
    private final Object[] args;
    private final Throwable throwable;

    static BinaryChronicleLogEvent read(@NotNull Bytes in) throws IllegalStateException {
        byte version = in.readByte();
        if (version == 1) {
            long timestamp = in.readLong();
            ChronicleLogLevel level = ChronicleLogLevel.readBinary((RandomDataInput)in);
            String threadName = in.readUTF\u0394();
            String loggerName = in.readUTF\u0394();
            String message = in.readUTF\u0394();
            long argsLen = in.readStopBit();
            if (argsLen < 0L || argsLen > Integer.MAX_VALUE) {
                throw new IllegalStateException();
            }
            Object[] args = null;
            if (argsLen != 0L) {
                args = new Object[(int)argsLen];
                int i = 0;
                while ((long)i < argsLen) {
                    args[i] = in.readObject();
                    ++i;
                }
            }
            Throwable throwable = in.readBoolean() ? (Throwable)in.readObject(Throwable.class) : null;
            return new BinaryChronicleLogEvent(version, timestamp, level, threadName, loggerName, message, args, throwable);
        }
        throw new IllegalStateException("message version= " + version);
    }

    private BinaryChronicleLogEvent(byte version, long timestamp, ChronicleLogLevel level, String threadName, String loggerName, String message, Object[] args, Throwable throwable) {
        this.version = version;
        this.timestamp = timestamp;
        this.level = level;
        this.threadName = threadName;
        this.loggerName = loggerName;
        this.message = message;
        this.args = args;
        this.throwable = throwable;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public ChronicleLogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object[] getArgumentArray() {
        return this.args != null ? this.args : EMPTY_ARGS;
    }

    @Override
    public boolean hasArguments() {
        return this.args != null;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

