/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import net.openhft.lang.io.ByteStringAppender;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.RandomDataOutput;
import net.openhft.lang.model.constraints.NotNull;

public enum ChronicleLogLevel {
    ERROR(50, "ERROR"),
    WARN(40, "WARN"),
    INFO(30, "INFO"),
    DEBUG(20, "DEBUG"),
    TRACE(10, "TRACE");

    private static final int CASE_DIFF = -32;
    private static final ChronicleLogLevel[] VALUES;
    private final int levelInt;
    private final String levelStr;

    static boolean fastEqualsIgnoreCase(@NotNull String upperCase, @NotNull CharSequence other) {
        int l = upperCase.length();
        if (l != other.length()) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            char oC;
            char uC = upperCase.charAt(i);
            if (uC == (oC = other.charAt(i)) || uC == oC + -32) continue;
            return false;
        }
        return true;
    }

    private ChronicleLogLevel(int levelInt, String levelStr) {
        this.levelInt = levelInt;
        this.levelStr = levelStr;
    }

    public boolean isHigherOrEqualTo(ChronicleLogLevel presumablyLowerLevel) {
        return this.levelInt >= presumablyLowerLevel.levelInt;
    }

    public void printTo(ByteStringAppender appender) {
        appender.append((CharSequence)this.levelStr);
    }

    public void writeTo(RandomDataOutput out) {
        out.writeByte(this.ordinal());
    }

    public String toString() {
        return this.levelStr;
    }

    public static ChronicleLogLevel readBinary(RandomDataInput in) {
        return VALUES[in.readByte()];
    }

    public static ChronicleLogLevel fromStringLevel(CharSequence levelStr) {
        if (levelStr != null) {
            for (ChronicleLogLevel cll : VALUES) {
                if (!ChronicleLogLevel.fastEqualsIgnoreCase(cll.levelStr, levelStr)) continue;
                return cll;
            }
        }
        throw new IllegalArgumentException(levelStr + " not a valid level value");
    }

    static {
        VALUES = ChronicleLogLevel.values();
    }
}

