/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Objects;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.logger.ChronicleLogEvent;
import net.openhft.chronicle.logger.ChronicleLogHelper;
import net.openhft.chronicle.logger.ChronicleLogProcessor;
import net.openhft.chronicle.logger.ChronicleLogReader;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.constraints.NotNull;

public final class ChroniTool {
    public static final DateFormat DF = new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss.SSS");
    public static final ChronicleLogReader READER_BINARY = new BinaryProcessor(){
        private StringWriter writer = new StringWriter();

        public void process(ChronicleLogEvent event) {
            this.writer.getBuffer().setLength(0);
            System.out.println(ChroniTool.asString(event, this.writer));
        }
    };
    public static final ChronicleLogReader READER_TEXT = new TextProcessor(){
        private StringWriter writer = new StringWriter();

        public void process(ChronicleLogEvent event) {
            this.writer.getBuffer().setLength(0);
            System.out.println(ChroniTool.asString(event, this.writer));
        }
    };

    public static StringWriter asString(ChronicleLogEvent event, StringWriter writer) {
        Throwable th;
        writer.append(DF.format(event.getTimeStamp()));
        writer.append("|");
        writer.append(event.getLevel().toString());
        writer.append("|");
        writer.append(event.getThreadName());
        writer.append("|");
        writer.append(event.getLoggerName());
        writer.append("|");
        writer.append(event.getMessage());
        Object[] args = event.getArgumentArray();
        if (args != null && args.length > 0) {
            writer.append("|args {");
            for (int i = 0; i < args.length; ++i) {
                writer.append(Objects.toString(args[i]));
                if (i == args.length - 1) continue;
                writer.append(", ");
            }
            writer.append("}");
        }
        if ((th = event.getThrowable()) != null) {
            writer.append("|exception: ");
            writer.append(th.toString());
            writer.append("\n");
            th.printStackTrace(new PrintWriter(writer));
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(@NotNull Chronicle chronicle, @NotNull ChronicleLogReader reader, boolean waitForData, boolean fromEnd) throws IOException {
        try (ExcerptTailer tailer = null;){
            ExcerptTailer excerptTailer = tailer = fromEnd ? chronicle.createTailer().toEnd() : chronicle.createTailer().toStart();
            while (true) {
                if (tailer.nextIndex()) {
                    reader.read((Bytes)tailer);
                    tailer.finish();
                    continue;
                }
                if (waitForData) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ignored) {}
                    continue;
                }
                break;
            }
        }
    }

    private ChroniTool() {
    }

    public static abstract class TextProcessor
    implements ChronicleLogReader,
    ChronicleLogProcessor {
        public void read(Bytes bytes) {
            this.process(ChronicleLogHelper.decodeText((Bytes)bytes));
        }
    }

    public static abstract class BinaryProcessor
    implements ChronicleLogReader,
    ChronicleLogProcessor {
        public void read(Bytes bytes) {
            this.process(ChronicleLogHelper.decodeBinary((Bytes)bytes));
        }
    }
}

