/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.jul;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.openhft.chronicle.logger.ChronicleLogManager;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.jul.ChronicleLogger;

public class ChronicleLoggerManager
extends LogManager {
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private final ChronicleLogManager manager = ChronicleLogManager.getInstance();

    @Override
    public boolean addLogger(Logger logger) {
        return false;
    }

    @Override
    public Logger getLogger(String name) {
        try {
            return this.doGetLogger(name);
        }
        catch (Exception e) {
            System.err.println("Unable to initialize chronicle-logger-jul (" + name + ")\n  " + e.getMessage());
            return ChronicleLogger.Null.INSTANCE;
        }
    }

    @Override
    public Enumeration<String> getLoggerNames() {
        return Collections.enumeration(this.loggers.keySet());
    }

    @Override
    public void reset() throws SecurityException {
        this.loggers.clear();
        this.manager.clear();
    }

    private synchronized Logger doGetLogger(String name) throws IOException {
        Logger logger = this.loggers.get(name);
        if (logger == null) {
            ChronicleLogWriter writer = this.manager.getWriter(name);
            logger = new ChronicleLogger(writer, name, this.manager.cfg().getLevel(name));
            this.loggers.put(name, logger);
        }
        return logger;
    }
}

