/*
 * Decompiled with CFR 0.152.
 */
package net.openhft;

import java.util.concurrent.TimeUnit;
import net.openhft.lang.io.IOTools;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@State(value=Scope.Thread)
public class Lo4J2PerfTest {
    private final Logger chronicleLogger = LoggerFactory.getLogger((String)"perf-chro");
    private final Logger fileLogger = LoggerFactory.getLogger((String)"perf-file");

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(Lo4J2PerfTest.class.getSimpleName()).warmupIterations(5).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    private static String rootPath() {
        String sep;
        String path = System.getenv("HOME");
        if (!path.endsWith(sep = System.getProperty("file.separator"))) {
            path = path + sep;
        }
        return path + "chronicle-log4j2-bench";
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void testChronicle() {
        this.chronicleLogger.debug("Test {} {} {}", new Object[]{1, 2, 3});
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void testChronicleException() {
        this.chronicleLogger.debug("Throwable test 2", (Throwable)new UnsupportedOperationException("Exception message"));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void testFile() {
        this.fileLogger.debug("Test {} {} {}", new Object[]{1, 2, 3});
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void testFileException() {
        this.fileLogger.debug("Throwable test 2", (Throwable)new UnsupportedOperationException("Exception message"));
    }

    @TearDown
    public void tearDown() {
        IOTools.deleteDir((String)Lo4J2PerfTest.rootPath());
    }
}

