/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.decentred.util.PublicKeyRegistry;
import net.openhft.chronicle.salt.Ed25519;

public class VanillaPublicKeyRegistry
implements PublicKeyRegistry {
    private final Map<Long, BytesStore> publicKeyMap = new ConcurrentHashMap<Long, BytesStore>();
    private boolean internal;

    @Override
    public void register(long address, BytesStore publicKey) {
        this.publicKeyMap.put(address, publicKey.copy());
    }

    @Override
    public Boolean verify(long address, BytesStore sigAndMsg) {
        if (this.internal) {
            return true;
        }
        BytesStore publicKey = this.publicKeyMap.get(address);
        if (publicKey == null) {
            return null;
        }
        return Ed25519.verify((BytesStore)sigAndMsg, (BytesStore)publicKey);
    }

    @Override
    public boolean internal() {
        return this.internal;
    }

    @Override
    public PublicKeyRegistry internal(boolean internal) {
        this.internal = internal;
        return this;
    }
}

