/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.decentred.util.DtoParselet;
import net.openhft.chronicle.decentred.util.DtoParser;
import net.openhft.chronicle.decentred.util.IntObjMap;

final class VanillaDtoParser<T>
implements DtoParser<T> {
    private final Class<T> clazz;
    private final IntObjMap<DtoParselet> parseletMap;
    private final Map<Class, Method> classConsumerMap;

    VanillaDtoParser(Class<T> clazz, IntObjMap<DtoParselet> parseletMap, Map<Class, Method> classConsumerMap) {
        this.clazz = Objects.requireNonNull(clazz);
        this.parseletMap = Objects.requireNonNull(parseletMap);
        this.classConsumerMap = Objects.requireNonNull(classConsumerMap);
    }

    @Override
    public void parseOne(Bytes bytes, T listener) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(listener);
        int protocolMessageType = bytes.readInt(bytes.readPosition() + 68L);
        DtoParselet parselet = this.parseletMap.get(protocolMessageType);
        if (parselet == null) {
            Jvm.warn().on(this.getClass(), "Unable to find a parselet for protocol " + (protocolMessageType >>> 16) + " messageType " + (protocolMessageType & 0xFFFF));
        } else {
            parselet.parse(bytes, listener);
        }
    }

    @Override
    public void onMessage(T component, Object message) {
        Objects.requireNonNull(component);
        Objects.requireNonNull(message);
        Method consumer = this.classConsumerMap.get(message.getClass());
        if (consumer == null) {
            Jvm.warn().on(this.getClass(), "Unable to find a consumer for " + message.getClass());
        } else {
            try {
                consumer.invoke(component, message);
            }
            catch (ReflectiveOperationException e) {
                Jvm.warn().on(this.getClass(), "Unable to invoke " + consumer + " " + message, (Throwable)e);
            }
        }
    }

    @Override
    public Class<T> superInterface() {
        return this.clazz;
    }
}

