/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.IntArrays;
import com.koloboke.collect.impl.Maths;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.LHashCapacities;
import com.koloboke.function.IntObjConsumer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.chronicle.decentred.util.IntObjMap;

@SuppressFBWarnings(value={"IA_AMBIGUOUS_INVOCATION_OF_INHERITED_OR_OUTER_METHOD"})
final class KolobokeIntObjMap<V>
extends IntObjMap<V> {
    int freeValue;
    V[] values;
    int[] set;
    private HashConfigWrapper configWrapper;
    int size;
    private int maxSize;
    private int modCount = 0;
    static final HashConfigWrapper DEFAULT_CONFIG_WRAPPER = new HashConfigWrapper(HashConfig.getDefault());

    KolobokeIntObjMap(int expectedSize) {
        this.init(DEFAULT_CONFIG_WRAPPER, expectedSize);
    }

    static void verifyConfig(HashConfig config) {
        if (config.getGrowthFactor() != 2.0) {
            throw new IllegalArgumentException(config + " passed, HashConfig for a hashtable\n" + "implementation with linear probing must have growthFactor of 2.0.\n" + "A Koloboke Compile-generated hashtable implementation could have\n" + "a different growth factor, if the implemented type is annotated with\n" + "@com.koloboke.compile.hash.algo.openaddressing.QuadraticProbing or\n" + "@com.koloboke.compile.hash.algo.openaddressing.DoubleHashing");
        }
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(int key) {
        return this.contains(key);
    }

    public int capacity() {
        return this.set.length;
    }

    final void init(HashConfigWrapper configWrapper, int size, int freeValue) {
        this.freeValue = freeValue;
        this.init(configWrapper, size);
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final int modCount() {
        return this.modCount;
    }

    final void incrementModCount() {
        ++this.modCount;
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        int free = this.freeValue;
        if (key != free) {
            int[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVIntKeyMixing.mix((int)key) & capacityMask;
            int cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    final void init(HashConfigWrapper configWrapper, int size) {
        KolobokeIntObjMap.verifyConfig(configWrapper.config());
        this.configWrapper = configWrapper;
        this.size = 0;
        this.internalInit(this.targetCapacity(size));
    }

    private void internalInit(int capacity) {
        assert (Maths.isPowerOf2((int)capacity));
        this.maxSize = this.maxSize(capacity);
        this.allocateArrays(capacity);
    }

    private int maxSize(int capacity) {
        return !this.isMaxCapacity(capacity) ? this.configWrapper.maxSize(capacity) : capacity - 1;
    }

    @Override
    public V get(int key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    private int findNewFreeOrRemoved() {
        int newFree;
        int free = this.freeValue;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    int insert(int key, V value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVIntKeyMixing.mix((int)key) & capacityMask;
        int cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return index;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    int changeFree() {
        int mc = this.modCount();
        int newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        IntArrays.replaceAll((int[])this.set, (int)this.freeValue, (int)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    final void initForRehash(int newCapacity) {
        ++this.modCount;
        this.internalInit(newCapacity);
    }

    private void _UpdatableSeparateKVIntLHashSO_allocateArrays(int capacity) {
        this.set = new int[capacity];
        if (this.freeValue != 0) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    private void _UpdatableLHash_clear() {
        ++this.modCount;
        this.size = 0;
    }

    private void _UpdatableSeparateKVIntLHashSO_clear() {
        this._UpdatableLHash_clear();
        Arrays.fill(this.set, this.freeValue);
    }

    void allocateArrays(int capacity) {
        this._UpdatableSeparateKVIntLHashSO_allocateArrays(capacity);
        this.values = new Object[capacity];
    }

    @Override
    public void forEach(IntObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    private void _UpdatableLHashSeparateKVIntObjMapSO_clear() {
        this._UpdatableSeparateKVIntLHashSO_clear();
        Arrays.fill(this.values, null);
    }

    final void postInsertHook() {
        int capacity;
        if (++this.size > this.maxSize && !this.isMaxCapacity(capacity = this.capacity())) {
            this.rehash(capacity << 1);
        }
    }

    boolean doubleSizedArrays() {
        return false;
    }

    private int targetCapacity(int size) {
        return LHashCapacities.capacity((HashConfigWrapper)this.configWrapper, (int)size, (boolean)this.doubleSizedArrays());
    }

    private boolean isMaxCapacity(int capacity) {
        return LHashCapacities.isMaxCapacity((int)capacity, (boolean)this.doubleSizedArrays());
    }

    @Override
    @SuppressFBWarnings(value={"EC_UNRELATED_TYPES_USING_POINTER_EQUALITY"})
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            V val = vals[i];
            sb.append(val != this ? val : "(this Map)");
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        V[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        V[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVIntKeyMixing.mix((int)key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void justPut(int key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        this._UpdatableLHashSeparateKVIntObjMapSO_clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    KolobokeIntObjMap(HashConfig hashConfig, int expectedSize) {
        this.init(new HashConfigWrapper(hashConfig), expectedSize);
    }

    static class Support {
        Support() {
        }
    }
}

