/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.salt.Ed25519;

public class KeyPair {
    public final Bytes<Void> publicKey = Bytes.allocateDirect((long)32L);
    public final Bytes<Void> secretKey = Bytes.allocateDirect((long)64L);

    public KeyPair() {
        Ed25519.generatePublicAndSecretKey(this.publicKey, this.secretKey);
    }

    public KeyPair(long id) {
        VanillaBytes privateKey = Bytes.allocateDirect((long)32L);
        privateKey.zeroOut(0L, 32L);
        privateKey.writeLong(24L, id);
        privateKey.writeSkip(32L);
        Ed25519.privateToPublicAndSecret(this.publicKey, this.secretKey, (BytesStore)privateKey);
        privateKey.release();
    }

    @Deprecated
    public KeyPair(char ch) {
        VanillaBytes privateKey = Bytes.allocateDirect((long)32L);
        while (privateKey.writeRemaining() > 0L) {
            privateKey.append(ch);
        }
        Ed25519.privateToPublicAndSecret(this.publicKey, this.secretKey, (BytesStore)privateKey);
        privateKey.release();
    }
}

